/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.test.TestTools;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={JdbcTest.class})
public class TestJdbcDistQuery
extends JdbcTestBase {
    private static final Logger logger = LoggerFactory.getLogger(TestJdbcDistQuery.class);
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)50000);

    @BeforeClass
    public static void setup() {
        dirTestWatcher.copyFileToRoot(Paths.get("sample-data", new String[0]));
    }

    private static void nextUntilEnd(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
        }
    }

    @Test
    public void testSimpleQuerySingleFile() throws Exception {
        this.testQuery("select R_REGIONKEY, R_NAME from dfs.`sample-data/regionsSF/`");
    }

    @Test
    public void testSimpleQueryMultiFile() throws Exception {
        this.testQuery("select R_REGIONKEY, R_NAME from dfs.`sample-data/regionsMF/`");
    }

    @Test
    public void testWhereOverSFile() throws Exception {
        this.testQuery("select R_REGIONKEY, R_NAME from dfs.`sample-data/regionsSF/` WHERE R_REGIONKEY = 1");
    }

    @Test
    public void testWhereOverMFile() throws Exception {
        this.testQuery("select R_REGIONKEY, R_NAME from dfs.`sample-data/regionsMF/` WHERE R_REGIONKEY = 1");
    }

    @Test
    public void testAggSingleFile() throws Exception {
        this.testQuery("select R_REGIONKEY from dfs.`sample-data/regionsSF/` group by R_REGIONKEY");
    }

    @Test
    public void testAggMultiFile() throws Exception {
        this.testQuery("select R_REGIONKEY from dfs.`sample-data/regionsMF/` group by R_REGIONKEY");
    }

    @Test
    public void testAggOrderByDiffGKeyMultiFile() throws Exception {
        this.testQuery("select R_REGIONKEY, SUM(cast(R_REGIONKEY AS int)) As S from dfs.`sample-data/regionsMF/` group by R_REGIONKEY ORDER BY S");
    }

    @Test
    public void testAggOrderBySameGKeyMultiFile() throws Exception {
        this.testQuery("select R_REGIONKEY, SUM(cast(R_REGIONKEY AS int)) As S from dfs.`sample-data/regionsMF/` group by R_REGIONKEY ORDER BY R_REGIONKEY");
    }

    @Ignore
    @Test
    public void testJoinSingleFile() throws Exception {
        this.testQuery("select T1.R_REGIONKEY from dfs.`sample-data/regionsSF/` as T1 join dfs.`sample-data/nationsSF/` as T2 on T1.R_REGIONKEY = T2.N_REGIONKEY");
    }

    @Ignore
    @Test
    public void testJoinMultiFile() throws Exception {
        this.testQuery("select T1.R_REGIONKEY from dfs.`sample-data/regionsMF/` as T1 join dfs.`sample-data/nationsMF/` as T2 on T1.R_REGIONKEY = T2.N_REGIONKEY");
    }

    @Ignore
    @Test
    public void testJoinMFileWhere() throws Exception {
        this.testQuery("select T1.R_REGIONKEY, T1.R_NAME from dfs.`sample-data/regionsMF/` as T1 join dfs.`sample-data/nationsMF/` as T2 on T1.R_REGIONKEY = T2.N_REGIONKEY WHERE T1.R_REGIONKEY  = 3 ");
    }

    @Test
    public void testSortSingleFile() throws Exception {
        this.testQuery("select R_REGIONKEY from dfs.`sample-data/regionsSF/` order by R_REGIONKEY");
    }

    @Test
    public void testSortMultiFile() throws Exception {
        this.testQuery("select R_REGIONKEY from dfs.`sample-data/regionsMF/` order by R_REGIONKEY");
    }

    @Test
    public void testSortMFileWhere() throws Exception {
        this.testQuery("select R_REGIONKEY from dfs.`sample-data/regionsMF/` WHERE R_REGIONKEY = 1 order by R_REGIONKEY");
    }

    @Ignore
    @Test
    public void testJoinAggSortWhere() throws Exception {
        this.testQuery("select T1.R_REGIONKEY, COUNT(1) as CNT from dfs.`sample-data/regionsMF/` as T1 join dfs.`sample-data/nationsMF/` as T2 on T1.R_REGIONKEY = T2.N_REGIONKEY WHERE T1.R_REGIONKEY  = 3 GROUP BY T1.R_REGIONKEY ORDER BY T1.R_REGIONKEY");
    }

    @Test
    public void testSelectLimit() throws Exception {
        this.testQuery("select R_REGIONKEY, R_NAME from dfs.`sample-data/regionsMF/` limit 2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testQuery(String sql) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean success = false;
        try (Connection c = TestJdbcDistQuery.connect();){
            boolean first = true;
            for (int x = 0; x < 1; ++x) {
                int i;
                Stopwatch watch = Stopwatch.createStarted();
                Statement s = c.createStatement();
                ResultSet r = s.executeQuery(sql);
                ResultSetMetaData md = r.getMetaData();
                if (first) {
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        sb.append(md.getColumnName(i));
                        sb.append('\t');
                    }
                    sb.append('\n');
                    first = false;
                }
                while (r.next()) {
                    md = r.getMetaData();
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        sb.append(r.getObject(i));
                        sb.append('\t');
                    }
                    sb.append('\n');
                }
                sb.append(String.format("Query completed in %d millis.\n", watch.elapsed(TimeUnit.MILLISECONDS)));
            }
            sb.append("\n\n\n");
            success = true;
        }
        finally {
            if (!success) {
                Thread.sleep(2000L);
            }
        }
        logger.info(sb.toString());
    }

    @Test
    public void testSchemaForEmptyResultSet() throws Exception {
        String query = "select fullname, occupation, postal_code from cp.`customer.json` where 0 = 1";
        try (Connection c = TestJdbcDistQuery.connect();){
            Statement s = c.createStatement();
            ResultSet r = s.executeQuery(query);
            ResultSetMetaData md = r.getMetaData();
            ArrayList columns = Lists.newArrayList();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                columns.add(md.getColumnName(i));
            }
            Object[] expected = new String[]{"fullname", "occupation", "postal_code"};
            Assert.assertEquals((long)3L, (long)md.getColumnCount());
            Assert.assertArrayEquals((Object[])expected, (Object[])columns.toArray());
            TestJdbcDistQuery.nextUntilEnd(r);
        }
    }

    static {
        Driver.load();
    }
}

