/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import org.apache.drill.categories.JdbcTest;
import org.apache.drill.jdbc.test.JdbcTestQueryBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={JdbcTest.class})
public class JdbcNullOrderingAndGroupingTest
extends JdbcTestQueryBase {
    static final Logger logger = LoggerFactory.getLogger(JdbcNullOrderingAndGroupingTest.class);

    @BeforeClass
    public static void setUpClass() throws Exception {
        JdbcNullOrderingAndGroupingTest.testQuery(String.format("alter session set `%s` = true", "planner.enable_decimal_data_type"));
        System.setProperty("drill.exec.http.enabled", "false");
    }

    @AfterClass
    public static void resetDefaults() throws Exception {
        JdbcNullOrderingAndGroupingTest.testQuery(String.format("alter session set `%s` = false", "planner.enable_decimal_data_type"));
    }

    @Test
    public void testOrderDonutsTopping3AscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, tbl.topping[3].type AS topping3 \nFROM cp.`donuts.json` AS tbl \nORDER BY topping3 ASC NULLS FIRST").returns("id=0005; topping3=null\nid=0002; topping3=Chocolate\nid=0003; topping3=Maple\nid=0001; topping3=Powdered Sugar\nid=0004; topping3=Powdered Sugar");
    }

    @Test
    public void testOrderDonutsTopping3AscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, tbl.topping[3].type AS topping3 \nFROM cp.`donuts.json` AS tbl \nORDER BY topping3 ASC NULLS LAST").returns("id=0002; topping3=Chocolate\nid=0003; topping3=Maple\nid=0001; topping3=Powdered Sugar\nid=0004; topping3=Powdered Sugar\nid=0005; topping3=null");
    }

    @Test
    public void testOrderDonutsTopping3AscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, tbl.topping[3].type AS topping3 \nFROM cp.`donuts.json` AS tbl \nORDER BY topping3 ASC").returns("id=0002; topping3=Chocolate\nid=0003; topping3=Maple\nid=0001; topping3=Powdered Sugar\nid=0004; topping3=Powdered Sugar\nid=0005; topping3=null");
    }

    @Test
    public void testOrderDonutsTopping3DescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, tbl.topping[3].type AS topping3 \nFROM cp.`donuts.json` AS tbl \nORDER BY topping3 DESC NULLS FIRST").returns("id=0005; topping3=null\nid=0001; topping3=Powdered Sugar\nid=0004; topping3=Powdered Sugar\nid=0003; topping3=Maple\nid=0002; topping3=Chocolate");
    }

    @Test
    public void testOrderDonutsTopping3DescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, tbl.topping[3].type AS topping3 \nFROM cp.`donuts.json` AS tbl \nORDER BY topping3 DESC NULLS LAST").returns("id=0001; topping3=Powdered Sugar\nid=0004; topping3=Powdered Sugar\nid=0003; topping3=Maple\nid=0002; topping3=Chocolate\nid=0005; topping3=null");
    }

    @Test
    public void testOrderDonutsTopping3DescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, tbl.topping[3].type AS topping3 \nFROM cp.`donuts.json` AS tbl \nORDER BY topping3 DESC").returns("id=0005; topping3=null\nid=0001; topping3=Powdered Sugar\nid=0004; topping3=Powdered Sugar\nid=0003; topping3=Maple\nid=0002; topping3=Chocolate");
    }

    @Test
    public void testOrderDonutsTopping3DefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, tbl.topping[3].type AS topping3 \nFROM cp.`donuts.json` AS tbl \nORDER BY topping3 NULLS FIRST").returns("id=0005; topping3=null\nid=0002; topping3=Chocolate\nid=0003; topping3=Maple\nid=0001; topping3=Powdered Sugar\nid=0004; topping3=Powdered Sugar");
    }

    @Test
    public void testOrderDonutsTopping3DefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, tbl.topping[3].type AS topping3 \nFROM cp.`donuts.json` AS tbl \nORDER BY topping3 NULLS LAST").returns("id=0002; topping3=Chocolate\nid=0003; topping3=Maple\nid=0001; topping3=Powdered Sugar\nid=0004; topping3=Powdered Sugar\nid=0005; topping3=null");
    }

    @Test
    public void testOrderDonutsTopping3DefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, tbl.topping[3].type AS topping3 \nFROM cp.`donuts.json` AS tbl \nORDER BY topping3").returns("id=0002; topping3=Chocolate\nid=0003; topping3=Maple\nid=0001; topping3=Powdered Sugar\nid=0004; topping3=Powdered Sugar\nid=0005; topping3=null");
    }

    @Test
    public void testOrderVarCharAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_VarChar AS VARCHAR ) AS as_VARCHAR \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_VARCHAR ASC NULLS FIRST").returns("id=2; as_VARCHAR=null\nid=3; as_VARCHAR=A\nid=1; as_VARCHAR=B");
    }

    @Test
    public void testOrderVarCharAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_VarChar AS VARCHAR ) AS as_VARCHAR \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_VARCHAR ASC NULLS LAST").returns("id=3; as_VARCHAR=A\nid=1; as_VARCHAR=B\nid=2; as_VARCHAR=null");
    }

    @Test
    public void testOrderVarCharAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_VarChar AS VARCHAR ) AS as_VARCHAR \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_VARCHAR ASC").returns("id=3; as_VARCHAR=A\nid=1; as_VARCHAR=B\nid=2; as_VARCHAR=null");
    }

    @Test
    public void testOrderVarCharDescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_VarChar AS VARCHAR ) AS as_VARCHAR \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_VARCHAR DESC NULLS FIRST").returns("id=2; as_VARCHAR=null\nid=1; as_VARCHAR=B\nid=3; as_VARCHAR=A");
    }

    @Test
    public void testOrderVarCharDescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_VarChar AS VARCHAR ) AS as_VARCHAR \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_VARCHAR DESC NULLS LAST").returns("id=1; as_VARCHAR=B\nid=3; as_VARCHAR=A\nid=2; as_VARCHAR=null");
    }

    @Test
    public void testOrderVarCharDescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_VarChar AS VARCHAR ) AS as_VARCHAR \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_VARCHAR DESC").returns("id=2; as_VARCHAR=null\nid=1; as_VARCHAR=B\nid=3; as_VARCHAR=A");
    }

    @Test
    public void testOrderVarCharDefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_VarChar AS VARCHAR ) AS as_VARCHAR \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_VARCHAR NULLS FIRST").returns("id=2; as_VARCHAR=null\nid=3; as_VARCHAR=A\nid=1; as_VARCHAR=B");
    }

    @Test
    public void testOrderVarCharDefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_VarChar AS VARCHAR ) AS as_VARCHAR \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_VARCHAR NULLS LAST").returns("id=3; as_VARCHAR=A\nid=1; as_VARCHAR=B\nid=2; as_VARCHAR=null");
    }

    @Test
    public void testOrderVarCharDefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_VarChar AS VARCHAR ) AS as_VARCHAR \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_VARCHAR").returns("id=3; as_VARCHAR=A\nid=1; as_VARCHAR=B\nid=2; as_VARCHAR=null");
    }

    @Test
    public void testOrderIntAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Int AS INT ) AS as_INT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INT ASC NULLS FIRST").returns("id=2; as_INT=null\nid=3; as_INT=19\nid=1; as_INT=180");
    }

    @Test
    public void testOrderIntAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Int AS INT ) AS as_INT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INT ASC NULLS LAST").returns("id=3; as_INT=19\nid=1; as_INT=180\nid=2; as_INT=null");
    }

    @Test
    public void testOrderIntAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Int AS INT ) AS as_INT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INT ASC").returns("id=3; as_INT=19\nid=1; as_INT=180\nid=2; as_INT=null");
    }

    @Test
    public void testOrderIntDescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Int AS INT ) AS as_INT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INT DESC NULLS FIRST").returns("id=2; as_INT=null\nid=1; as_INT=180\nid=3; as_INT=19");
    }

    @Test
    public void testOrderIntDescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Int AS INT ) AS as_INT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INT DESC NULLS LAST").returns("id=1; as_INT=180\nid=3; as_INT=19\nid=2; as_INT=null");
    }

    @Test
    public void testOrderIntDescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Int AS INT ) AS as_INT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INT DESC").returns("id=2; as_INT=null\nid=1; as_INT=180\nid=3; as_INT=19");
    }

    @Test
    public void testOrderIntDefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Int AS INT ) AS as_INT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INT NULLS FIRST").returns("id=2; as_INT=null\nid=3; as_INT=19\nid=1; as_INT=180");
    }

    @Test
    public void testOrderIntDefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Int AS INT ) AS as_INT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INT NULLS LAST").returns("id=3; as_INT=19\nid=1; as_INT=180\nid=2; as_INT=null");
    }

    @Test
    public void testOrderIntDefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Int AS INT ) AS as_INT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INT").returns("id=3; as_INT=19\nid=1; as_INT=180\nid=2; as_INT=null");
    }

    @Test
    public void testOrderFloatAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Float AS FLOAT ) AS as_FLOAT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_FLOAT ASC NULLS FIRST").returns("id=2; as_FLOAT=null\nid=3; as_FLOAT=19.0\nid=1; as_FLOAT=180.0");
    }

    @Test
    public void testOrderFloatAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Float AS FLOAT ) AS as_FLOAT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_FLOAT ASC NULLS LAST").returns("id=3; as_FLOAT=19.0\nid=1; as_FLOAT=180.0\nid=2; as_FLOAT=null");
    }

    @Test
    public void testOrderFloatAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Float AS FLOAT ) AS as_FLOAT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_FLOAT ASC").returns("id=3; as_FLOAT=19.0\nid=1; as_FLOAT=180.0\nid=2; as_FLOAT=null");
    }

    @Test
    public void testOrderFloatDescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Float AS FLOAT ) AS as_FLOAT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_FLOAT DESC NULLS FIRST").returns("id=2; as_FLOAT=null\nid=1; as_FLOAT=180.0\nid=3; as_FLOAT=19.0");
    }

    @Test
    public void testOrderFloatDescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Float AS FLOAT ) AS as_FLOAT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_FLOAT DESC NULLS LAST").returns("id=1; as_FLOAT=180.0\nid=3; as_FLOAT=19.0\nid=2; as_FLOAT=null");
    }

    @Test
    public void testOrderFloatDescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Float AS FLOAT ) AS as_FLOAT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_FLOAT DESC").returns("id=2; as_FLOAT=null\nid=1; as_FLOAT=180.0\nid=3; as_FLOAT=19.0");
    }

    @Test
    public void testOrderFloatDefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Float AS FLOAT ) AS as_FLOAT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_FLOAT NULLS FIRST").returns("id=2; as_FLOAT=null\nid=3; as_FLOAT=19.0\nid=1; as_FLOAT=180.0");
    }

    @Test
    public void testOrderFloatDefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Float AS FLOAT ) AS as_FLOAT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_FLOAT NULLS LAST").returns("id=3; as_FLOAT=19.0\nid=1; as_FLOAT=180.0\nid=2; as_FLOAT=null");
    }

    @Test
    public void testOrderFloatDefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Float AS FLOAT ) AS as_FLOAT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_FLOAT").returns("id=3; as_FLOAT=19.0\nid=1; as_FLOAT=180.0\nid=2; as_FLOAT=null");
    }

    @Test
    public void testOrderBigIntAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_BigInt AS BIGINT ) AS as_BIGINT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_BIGINT ASC NULLS FIRST").returns("id=2; as_BIGINT=null\nid=3; as_BIGINT=19\nid=1; as_BIGINT=180");
    }

    @Test
    public void testOrderBigIntAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_BigInt AS BIGINT ) AS as_BIGINT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_BIGINT ASC NULLS LAST").returns("id=3; as_BIGINT=19\nid=1; as_BIGINT=180\nid=2; as_BIGINT=null");
    }

    @Test
    public void testOrderBigIntAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_BigInt AS BIGINT ) AS as_BIGINT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_BIGINT ASC").returns("id=3; as_BIGINT=19\nid=1; as_BIGINT=180\nid=2; as_BIGINT=null");
    }

    @Test
    public void testOrderBigIntDescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_BigInt AS BIGINT ) AS as_BIGINT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_BIGINT DESC NULLS FIRST").returns("id=2; as_BIGINT=null\nid=1; as_BIGINT=180\nid=3; as_BIGINT=19");
    }

    @Test
    public void testOrderBigIntDescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_BigInt AS BIGINT ) AS as_BIGINT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_BIGINT DESC NULLS LAST").returns("id=1; as_BIGINT=180\nid=3; as_BIGINT=19\nid=2; as_BIGINT=null");
    }

    @Test
    public void testOrderBigIntDescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_BigInt AS BIGINT ) AS as_BIGINT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_BIGINT DESC").returns("id=2; as_BIGINT=null\nid=1; as_BIGINT=180\nid=3; as_BIGINT=19");
    }

    @Test
    public void testOrderBigIntDefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_BigInt AS BIGINT ) AS as_BIGINT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_BIGINT NULLS FIRST").returns("id=2; as_BIGINT=null\nid=3; as_BIGINT=19\nid=1; as_BIGINT=180");
    }

    @Test
    public void testOrderBigIntDefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_BigInt AS BIGINT ) AS as_BIGINT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_BIGINT NULLS LAST").returns("id=3; as_BIGINT=19\nid=1; as_BIGINT=180\nid=2; as_BIGINT=null");
    }

    @Test
    public void testOrderBigIntDefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_BigInt AS BIGINT ) AS as_BIGINT \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_BIGINT").returns("id=3; as_BIGINT=19\nid=1; as_BIGINT=180\nid=2; as_BIGINT=null");
    }

    @Test
    public void testOrderDateAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Date AS DATE ) AS as_DATE \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DATE ASC NULLS FIRST").returns("id=2; as_DATE=null\nid=3; as_DATE=2014-01-01\nid=1; as_DATE=2014-12-31");
    }

    @Test
    public void testOrderDateAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Date AS DATE ) AS as_DATE \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DATE ASC NULLS LAST").returns("id=3; as_DATE=2014-01-01\nid=1; as_DATE=2014-12-31\nid=2; as_DATE=null");
    }

    @Test
    public void testOrderDateAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Date AS DATE ) AS as_DATE \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DATE ASC").returns("id=3; as_DATE=2014-01-01\nid=1; as_DATE=2014-12-31\nid=2; as_DATE=null");
    }

    @Test
    public void testOrderDateDescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Date AS DATE ) AS as_DATE \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DATE DESC NULLS FIRST").returns("id=2; as_DATE=null\nid=1; as_DATE=2014-12-31\nid=3; as_DATE=2014-01-01");
    }

    @Test
    public void testOrderDateDescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Date AS DATE ) AS as_DATE \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DATE DESC NULLS LAST").returns("id=1; as_DATE=2014-12-31\nid=3; as_DATE=2014-01-01\nid=2; as_DATE=null");
    }

    @Test
    public void testOrderDateDescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Date AS DATE ) AS as_DATE \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DATE DESC").returns("id=2; as_DATE=null\nid=1; as_DATE=2014-12-31\nid=3; as_DATE=2014-01-01");
    }

    @Test
    public void testOrderDateDefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Date AS DATE ) AS as_DATE \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DATE NULLS FIRST").returns("id=2; as_DATE=null\nid=3; as_DATE=2014-01-01\nid=1; as_DATE=2014-12-31");
    }

    @Test
    public void testOrderDateDefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Date AS DATE ) AS as_DATE \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DATE NULLS LAST").returns("id=3; as_DATE=2014-01-01\nid=1; as_DATE=2014-12-31\nid=2; as_DATE=null");
    }

    @Test
    public void testOrderDateDefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Date AS DATE ) AS as_DATE \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DATE").returns("id=3; as_DATE=2014-01-01\nid=1; as_DATE=2014-12-31\nid=2; as_DATE=null");
    }

    @Test
    public void testOrderIntervalAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Interval AS INTERVAL HOUR ) AS as_INTERVAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INTERVAL ASC NULLS FIRST").returns("id=2; as_INTERVAL=null\nid=3; as_INTERVAL=PT3600S\nid=1; as_INTERVAL=PT7200S");
    }

    @Test
    public void testOrderIntervalAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Interval AS INTERVAL HOUR ) AS as_INTERVAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INTERVAL ASC NULLS LAST").returns("id=3; as_INTERVAL=PT3600S\nid=1; as_INTERVAL=PT7200S\nid=2; as_INTERVAL=null");
    }

    @Test
    public void testOrderIntervalAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Interval AS INTERVAL HOUR ) AS as_INTERVAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INTERVAL ASC").returns("id=3; as_INTERVAL=PT3600S\nid=1; as_INTERVAL=PT7200S\nid=2; as_INTERVAL=null");
    }

    @Test
    public void testOrderIntervalDescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Interval AS INTERVAL HOUR ) AS as_INTERVAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INTERVAL DESC NULLS FIRST").returns("id=2; as_INTERVAL=null\nid=1; as_INTERVAL=PT7200S\nid=3; as_INTERVAL=PT3600S");
    }

    @Test
    public void testOrderIntervalDescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Interval AS INTERVAL HOUR ) AS as_INTERVAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INTERVAL DESC NULLS LAST").returns("id=1; as_INTERVAL=PT7200S\nid=3; as_INTERVAL=PT3600S\nid=2; as_INTERVAL=null");
    }

    @Test
    public void testOrderIntervalDescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Interval AS INTERVAL HOUR ) AS as_INTERVAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INTERVAL DESC").returns("id=2; as_INTERVAL=null\nid=1; as_INTERVAL=PT7200S\nid=3; as_INTERVAL=PT3600S");
    }

    @Test
    public void testOrderIntervalDefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Interval AS INTERVAL HOUR ) AS as_INTERVAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INTERVAL NULLS FIRST").returns("id=2; as_INTERVAL=null\nid=3; as_INTERVAL=PT3600S\nid=1; as_INTERVAL=PT7200S");
    }

    @Test
    public void testOrderIntervalDefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Interval AS INTERVAL HOUR ) AS as_INTERVAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INTERVAL NULLS LAST").returns("id=3; as_INTERVAL=PT3600S\nid=1; as_INTERVAL=PT7200S\nid=2; as_INTERVAL=null");
    }

    @Test
    public void testOrderIntervalDefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Interval AS INTERVAL HOUR ) AS as_INTERVAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_INTERVAL").returns("id=3; as_INTERVAL=PT3600S\nid=1; as_INTERVAL=PT7200S\nid=2; as_INTERVAL=null");
    }

    @Test
    public void testOrderDecimalAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal AS DECIMAL ) AS as_DECIMAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL ASC NULLS FIRST").returns("id=2; as_DECIMAL=null\nid=3; as_DECIMAL=19\nid=1; as_DECIMAL=180");
    }

    @Test
    public void testOrderDecimalAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal AS DECIMAL ) AS as_DECIMAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL ASC NULLS LAST").returns("id=3; as_DECIMAL=19\nid=1; as_DECIMAL=180\nid=2; as_DECIMAL=null");
    }

    @Test
    public void testOrderDecimalAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal AS DECIMAL ) AS as_DECIMAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL ASC").returns("id=3; as_DECIMAL=19\nid=1; as_DECIMAL=180\nid=2; as_DECIMAL=null");
    }

    @Test
    public void testOrderDecimalDescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal AS DECIMAL ) AS as_DECIMAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL DESC NULLS FIRST").returns("id=2; as_DECIMAL=null\nid=1; as_DECIMAL=180\nid=3; as_DECIMAL=19");
    }

    @Test
    public void testOrderDecimalDescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal AS DECIMAL ) AS as_DECIMAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL DESC NULLS LAST").returns("id=1; as_DECIMAL=180\nid=3; as_DECIMAL=19\nid=2; as_DECIMAL=null");
    }

    @Test
    public void testOrderDecimalDescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal AS DECIMAL ) AS as_DECIMAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL DESC").returns("id=2; as_DECIMAL=null\nid=1; as_DECIMAL=180\nid=3; as_DECIMAL=19");
    }

    @Test
    public void testOrderDecimalDefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal AS DECIMAL ) AS as_DECIMAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL NULLS FIRST").returns("id=2; as_DECIMAL=null\nid=3; as_DECIMAL=19\nid=1; as_DECIMAL=180");
    }

    @Test
    public void testOrderDecimalDefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal AS DECIMAL ) AS as_DECIMAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL NULLS LAST").returns("id=3; as_DECIMAL=19\nid=1; as_DECIMAL=180\nid=2; as_DECIMAL=null");
    }

    @Test
    public void testOrderDecimalDefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal AS DECIMAL ) AS as_DECIMAL \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL").returns("id=3; as_DECIMAL=19\nid=1; as_DECIMAL=180\nid=2; as_DECIMAL=null");
    }

    @Test
    public void testOrderDecimal5AscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal5 AS DECIMAL(5) ) AS as_DECIMAL5 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL5 ASC NULLS FIRST").returns("id=2; as_DECIMAL5=null\nid=3; as_DECIMAL5=1235\nid=1; as_DECIMAL5=9877");
    }

    @Test
    public void testOrderDecimal5AscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal5 AS DECIMAL(5) ) AS as_DECIMAL5 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL5 ASC NULLS LAST").returns("id=3; as_DECIMAL5=1235\nid=1; as_DECIMAL5=9877\nid=2; as_DECIMAL5=null");
    }

    @Test
    public void testOrderDecimal5AscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal5 AS DECIMAL(5) ) AS as_DECIMAL5 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL5 ASC").returns("id=3; as_DECIMAL5=1235\nid=1; as_DECIMAL5=9877\nid=2; as_DECIMAL5=null");
    }

    @Test
    public void testOrderDecimal5DescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal5 AS DECIMAL(5) ) AS as_DECIMAL5 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL5 DESC NULLS FIRST").returns("id=2; as_DECIMAL5=null\nid=1; as_DECIMAL5=9877\nid=3; as_DECIMAL5=1235");
    }

    @Test
    public void testOrderDecimal5DescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal5 AS DECIMAL(5) ) AS as_DECIMAL5 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL5 DESC NULLS LAST").returns("id=1; as_DECIMAL5=9877\nid=3; as_DECIMAL5=1235\nid=2; as_DECIMAL5=null");
    }

    @Test
    public void testOrderDecimal5DescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal5 AS DECIMAL(5) ) AS as_DECIMAL5 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL5 DESC").returns("id=2; as_DECIMAL5=null\nid=1; as_DECIMAL5=9877\nid=3; as_DECIMAL5=1235");
    }

    @Test
    public void testOrderDecimal5DefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal5 AS DECIMAL(5) ) AS as_DECIMAL5 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL5 NULLS FIRST").returns("id=2; as_DECIMAL5=null\nid=3; as_DECIMAL5=1235\nid=1; as_DECIMAL5=9877");
    }

    @Test
    public void testOrderDecimal5DefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal5 AS DECIMAL(5) ) AS as_DECIMAL5 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL5 NULLS LAST").returns("id=3; as_DECIMAL5=1235\nid=1; as_DECIMAL5=9877\nid=2; as_DECIMAL5=null");
    }

    @Test
    public void testOrderDecimal5DefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal5 AS DECIMAL(5) ) AS as_DECIMAL5 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL5").returns("id=3; as_DECIMAL5=1235\nid=1; as_DECIMAL5=9877\nid=2; as_DECIMAL5=null");
    }

    @Test
    public void testOrderDecimal35AscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal35 AS DECIMAL(35) ) AS as_DECIMAL35 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL35 ASC NULLS FIRST").returns("id=2; as_DECIMAL35=null\nid=3; as_DECIMAL35=12345678901234567890123456789012345\nid=1; as_DECIMAL35=43210987654321098765432109876543210");
    }

    @Test
    public void testOrderDecimal35AscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal35 AS DECIMAL(35) ) AS as_DECIMAL35 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL35 ASC NULLS LAST").returns("id=3; as_DECIMAL35=12345678901234567890123456789012345\nid=1; as_DECIMAL35=43210987654321098765432109876543210\nid=2; as_DECIMAL35=null");
    }

    @Test
    public void testOrderDecimal35AscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal35 AS DECIMAL(35) ) AS as_DECIMAL35 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL35 ASC").returns("id=3; as_DECIMAL35=12345678901234567890123456789012345\nid=1; as_DECIMAL35=43210987654321098765432109876543210\nid=2; as_DECIMAL35=null");
    }

    @Test
    public void testOrderDecimal35DescNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal35 AS DECIMAL(35) ) AS as_DECIMAL35 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL35 DESC NULLS FIRST").returns("id=2; as_DECIMAL35=null\nid=1; as_DECIMAL35=43210987654321098765432109876543210\nid=3; as_DECIMAL35=12345678901234567890123456789012345");
    }

    @Test
    public void testOrderDecimal35DescNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal35 AS DECIMAL(35) ) AS as_DECIMAL35 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL35 DESC NULLS LAST").returns("id=1; as_DECIMAL35=43210987654321098765432109876543210\nid=3; as_DECIMAL35=12345678901234567890123456789012345\nid=2; as_DECIMAL35=null");
    }

    @Test
    public void testOrderDecimal35DescNullsDefaultFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal35 AS DECIMAL(35) ) AS as_DECIMAL35 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL35 DESC").returns("id=2; as_DECIMAL35=null\nid=1; as_DECIMAL35=43210987654321098765432109876543210\nid=3; as_DECIMAL35=12345678901234567890123456789012345");
    }

    @Test
    public void testOrderDecimal35DefaultedAscNullsFirst() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal35 AS DECIMAL(35) ) AS as_DECIMAL35 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL35 NULLS FIRST").returns("id=2; as_DECIMAL35=null\nid=3; as_DECIMAL35=12345678901234567890123456789012345\nid=1; as_DECIMAL35=43210987654321098765432109876543210");
    }

    @Test
    public void testOrderDecimal35DefaultedAscNullsLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal35 AS DECIMAL(35) ) AS as_DECIMAL35 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL35 NULLS LAST").returns("id=3; as_DECIMAL35=12345678901234567890123456789012345\nid=1; as_DECIMAL35=43210987654321098765432109876543210\nid=2; as_DECIMAL35=null");
    }

    @Test
    public void testOrderDecimal35DefaultedAscNullsDefaultLast() throws Exception {
        JdbcNullOrderingAndGroupingTest.withNoDefaultSchema().sql("SELECT tbl.id, \n       CAST( tbl.for_Decimal35 AS DECIMAL(35) ) AS as_DECIMAL35 \nFROM cp.`null_ordering_and_grouping_data.json` AS tbl \nORDER BY as_DECIMAL35").returns("id=3; as_DECIMAL35=12345678901234567890123456789012345\nid=1; as_DECIMAL35=43210987654321098765432109876543210\nid=2; as_DECIMAL35=null");
    }
}

