/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Semaphore;
import org.apache.drill.categories.JdbcTest;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={JdbcTest.class})
public class PreparedStatementMaxRowsTest
extends JdbcTestBase {
    private static final Random RANDOMIZER = new Random(20150304L);
    private static final String SYS_OPTIONS_SQL = "SELECT * FROM sys.options";
    private static final String SYS_OPTIONS_SQL_LIMIT_10 = "SELECT * FROM sys.options LIMIT 12";
    private static final String ALTER_SYS_OPTIONS_MAX_ROWS_LIMIT_X = "ALTER SYSTEM SET `exec.query.max_rows`=";
    private static final Semaphore maxRowsSysOptionLock = new Semaphore(1);
    private static Connection connection;

    @BeforeClass
    public static void setUpConnection() throws SQLException {
        Driver.load();
        Properties properties = new Properties();
        properties.setProperty(ExecConstants.bootDefaultFor((String)"prepare.statement.create_timeout_ms"), "30000");
        connection = DriverManager.getConnection("jdbc:drill:zk=local", properties);
        try (Statement stmt = connection.createStatement();){
            stmt.execute(String.format("alter session set `%s` = true", "planner.enable_decimal_data_type"));
        }
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void getExclusiveLock() {
        maxRowsSysOptionLock.acquireUninterruptibly();
    }

    @After
    public void releaseExclusiveLock() {
        maxRowsSysOptionLock.release();
    }

    @Test
    public void testDefaultGetMaxRows() throws SQLException {
        try (PreparedStatement pStmt = connection.prepareStatement(SYS_OPTIONS_SQL);){
            int maxRowsValue = pStmt.getMaxRows();
            Assert.assertEquals((long)0L, (long)maxRowsValue);
        }
    }

    @Test
    public void testInvalidSetMaxRows() throws SQLException {
        try (PreparedStatement pStmt = connection.prepareStatement(SYS_OPTIONS_SQL);){
            int valueToSet = -10;
            int origMaxRows = pStmt.getMaxRows();
            try {
                pStmt.setMaxRows(valueToSet);
            }
            catch (SQLException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("illegal maxRows value: " + valueToSet)));
            }
            Assert.assertEquals((long)origMaxRows, (long)pStmt.getMaxRows());
        }
    }

    @Test
    public void testValidSetMaxRows() throws SQLException {
        try (PreparedStatement pStmt = connection.prepareStatement(SYS_OPTIONS_SQL);){
            int valueToSet = RANDOMIZER.nextInt(59) + 1;
            pStmt.setMaxRows(valueToSet);
            Assert.assertEquals((long)valueToSet, (long)pStmt.getMaxRows());
        }
    }

    @Test
    public void testSetMaxRowsAsZero() throws SQLException {
        try (PreparedStatement pStmt = connection.prepareStatement(SYS_OPTIONS_SQL);){
            pStmt.setMaxRows(0);
            pStmt.execute();
            ResultSet rs = pStmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertTrue((rowCount > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetMaxRowsLowerThanQueryLimit() throws SQLException {
        try (PreparedStatement pStmt = connection.prepareStatement(SYS_OPTIONS_SQL_LIMIT_10);){
            int valueToSet = RANDOMIZER.nextInt(9) + 1;
            pStmt.setMaxRows(valueToSet);
            pStmt.executeQuery();
            ResultSet rs = pStmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertEquals((long)valueToSet, (long)rowCount);
        }
    }

    @Test
    public void testSetMaxRowsHigherThanQueryLimit() throws SQLException {
        try (PreparedStatement pStmt = connection.prepareStatement(SYS_OPTIONS_SQL_LIMIT_10);){
            int valueToSet = RANDOMIZER.nextInt(10) + 11;
            pStmt.setMaxRows(valueToSet);
            pStmt.executeQuery();
            ResultSet rs = pStmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertTrue((valueToSet > rowCount ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSetMaxRowsLowerThanSystemLimit() throws SQLException {
        int sysValueToSet = RANDOMIZER.nextInt(5) + 6;
        this.setSystemMaxRows(sysValueToSet);
        try (PreparedStatement pStmt = connection.prepareStatement(SYS_OPTIONS_SQL);){
            int valueToSet = RANDOMIZER.nextInt(5) + 1;
            pStmt.setMaxRows(valueToSet);
            pStmt.executeQuery();
            ResultSet rs = pStmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertEquals((long)valueToSet, (long)rowCount);
        }
        this.setSystemMaxRows(0);
    }

    @Test
    public void testSetMaxRowsHigherThanSystemLimit() throws SQLException {
        int sysValueToSet = RANDOMIZER.nextInt(5) + 6;
        this.setSystemMaxRows(sysValueToSet);
        try (PreparedStatement pStmt = connection.prepareStatement(SYS_OPTIONS_SQL);){
            int valueToSet = RANDOMIZER.nextInt(5) + 11;
            pStmt.setMaxRows(valueToSet);
            pStmt.executeQuery();
            ResultSet rs = pStmt.getResultSet();
            int rowCount = 0;
            while (rs.next()) {
                rs.getBytes(1);
                ++rowCount;
            }
            rs.close();
            Assert.assertEquals((long)sysValueToSet, (long)rowCount);
        }
        this.setSystemMaxRows(0);
    }

    private void setSystemMaxRows(int sysValueToSet) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeQuery(ALTER_SYS_OPTIONS_MAX_ROWS_LIMIT_X + sysValueToSet);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
            }
            rs.close();
        }
    }
}

