/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.jdbc.test.JdbcTestActionBase;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestJdbcMetadata
extends JdbcTestActionBase {
    private static final Logger logger = LoggerFactory.getLogger(TestJdbcMetadata.class);
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)120000);

    @Test
    public void catalogs() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getCatalogs();
            }
        }, 1L);
    }

    @Test
    public void allSchemas() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getSchemas();
            }
        });
    }

    @Test
    public void schemasWithConditions() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getSchemas("DRILL", "%fs%");
            }
        }, 6L);
    }

    @Test
    public void allTables() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getTables(null, null, null, null);
            }
        });
    }

    @Test
    public void tablesWithConditions() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getTables("DRILL", "sys", "opt%", new String[]{"SYSTEM_TABLE", "SYSTEM_VIEW"});
            }
        }, 1L);
    }

    @Test
    public void allColumns() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getColumns(null, null, null, null);
            }
        });
    }

    @Test
    public void columnsWithConditions() throws Exception {
        this.testAction(new JdbcTestActionBase.JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                return c.getMetaData().getColumns("DRILL", "sys", "opt%", "%ame");
            }
        }, 1L);
    }
}

