/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.jdbc.test.JdbcAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class JdbcTestActionBase
extends JdbcTestBase {
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)40000);
    protected static final String WORKING_PATH;
    static Connection connection;
    public final TestRule resetWatcher = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            try {
                JdbcTestActionBase.resetConnection();
            }
            catch (Exception e1) {
                throw new RuntimeException("Failure while resetting client.", e1);
            }
        }
    };

    protected void testQuery(final String sql) throws Exception {
        this.testAction(new JdbcAction(){

            @Override
            public ResultSet getResult(Connection c) throws SQLException {
                Statement s = c.createStatement();
                ResultSet r = s.executeQuery(sql);
                return r;
            }
        });
    }

    protected void testAction(JdbcAction action) throws Exception {
        this.testAction(action, -1L);
    }

    protected void testAction(JdbcAction action, long rowcount) throws Exception {
        int rows = 0;
        Stopwatch watch = Stopwatch.createStarted();
        ResultSet r = action.getResult(connection);
        boolean first = true;
        while (r.next()) {
            int i;
            ++rows;
            ResultSetMetaData md = r.getMetaData();
            if (first) {
                for (i = 1; i <= md.getColumnCount(); ++i) {
                    System.out.print(md.getColumnName(i));
                    System.out.print('\t');
                }
                System.out.println();
                first = false;
            }
            for (i = 1; i <= md.getColumnCount(); ++i) {
                System.out.print(r.getObject(i));
                System.out.print('\t');
            }
            System.out.println();
        }
        System.out.println(String.format("Query completed in %d millis.", watch.elapsed(TimeUnit.MILLISECONDS)));
        if (rowcount != -1L) {
            Assert.assertEquals((long)rowcount, (long)rows);
        }
        System.out.println("\n\n\n");
    }

    static void resetConnection() throws Exception {
        JdbcTestActionBase.closeClient();
        JdbcTestActionBase.openClient();
    }

    @BeforeClass
    public static void openClient() throws Exception {
        connection = DriverManager.getConnection("jdbc:drill:zk=local", JdbcAssert.getDefaultProperties());
    }

    @AfterClass
    public static void closeClient() throws IOException, SQLException {
        connection.close();
    }

    static {
        Driver.load();
        WORKING_PATH = Paths.get("", new String[0]).toAbsolutePath().toString();
    }

    public static interface JdbcAction {
        public ResultSet getResult(Connection var1) throws SQLException;
    }
}

