/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.data.Filter;
import org.apache.drill.common.logical.data.Join;
import org.apache.drill.common.logical.data.Limit;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.common.logical.data.Project;
import org.apache.drill.common.logical.data.Scan;
import org.apache.drill.common.logical.data.Store;
import org.apache.drill.common.logical.data.Union;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.jdbc.test.JdbcAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class JdbcDataTest
extends JdbcTestBase {
    private static String MODEL;
    private static String EXPECTED;

    @BeforeClass
    public static void setupFixtures() throws IOException {
        MODEL = Resources.toString((URL)Resources.getResource((String)"test-models.json"), (Charset)Charsets.UTF_8);
        EXPECTED = Resources.toString((URL)Resources.getResource((String)"donuts-output-data.txt"), (Charset)Charsets.UTF_8);
    }

    public static void main(String[] args) throws Exception {
    }

    @Test
    public void testLoadDriver() throws ClassNotFoundException {
        Class.forName("org.apache.drill.jdbc.Driver");
    }

    @Test
    public void testLoadDriverServiceLoader() {
        ServiceLoader<java.sql.Driver> sl = ServiceLoader.load(java.sql.Driver.class);
        for (java.sql.Driver driver : sl) {
            if (!(driver instanceof Driver)) continue;
            return;
        }
        Assert.fail((String)"org.apache.drill.jdbc.Driver not found using ServiceLoader");
    }

    @Test
    public void testConnect() throws Exception {
        Class.forName("org.apache.drill.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:drill:zk=local");
        connection.close();
    }

    @Test
    public void testPrepare() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").withConnection(new Function<Connection, Void>(){

            public Void apply(Connection connection) {
                try {
                    PreparedStatement statement = connection.prepareStatement("select * from donuts");
                    statement.close();
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testSelectJson() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").sql("select * from donuts").returns(EXPECTED);
    }

    @Test
    public void testSelectEmployees() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select * from employees").returns("_MAP={deptId=31, lastName=Rafferty}\n_MAP={deptId=33, lastName=Jones}\n_MAP={deptId=33, lastName=Steinberg}\n_MAP={deptId=34, lastName=Robinson}\n_MAP={deptId=34, lastName=Smith}\n_MAP={lastName=John}\n");
    }

    @Test
    public void testSelectEmpView() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select * from emp").returns("DEPTID=31; LASTNAME=Rafferty\nDEPTID=33; LASTNAME=Jones\nDEPTID=33; LASTNAME=Steinberg\nDEPTID=34; LASTNAME=Robinson\nDEPTID=34; LASTNAME=Smith\nDEPTID=null; LASTNAME=John\n");
    }

    @Test
    public void testSelectDept() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select * from departments").returns("_MAP={deptId=31, name=Sales}\n_MAP={deptId=33, name=Engineering}\n_MAP={deptId=34, name=Clerical}\n_MAP={deptId=35, name=Marketing}\n");
    }

    @Test
    public void testProjectConstant() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").sql("select 1 + 3 as c from donuts").returns("C=4\nC=4\nC=4\nC=4\nC=4\n");
    }

    @Test
    public void testProject() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").sql("select _MAP['ppu'] as ppu from donuts").returns("PPU=0.55\nPPU=0.69\nPPU=0.55\nPPU=0.69\nPPU=1.0\n");
    }

    @Test
    public void testProjectOnSubquery() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").sql("select d['ppu'] as ppu from (\n select _MAP as d from donuts)").returns("PPU=0.55\nPPU=0.69\nPPU=0.55\nPPU=0.69\nPPU=1.0\n");
    }

    @Test
    public void testProjectPlan() throws Exception {
        LogicalPlan plan = JdbcAssert.withModel(MODEL, "DONUTS").sql("select _MAP['ppu'] as ppu from donuts").logicalPlan();
        PlanProperties planProperties = plan.getProperties();
        Assert.assertEquals((Object)"optiq", (Object)planProperties.generator.type);
        Assert.assertEquals((Object)"na", (Object)planProperties.generator.info);
        Assert.assertEquals((long)1L, (long)planProperties.version);
        Assert.assertEquals((Object)PlanProperties.PlanType.APACHE_DRILL_LOGICAL, (Object)planProperties.type);
        Map seConfigs = plan.getStorageEngines();
        StoragePluginConfig config = (StoragePluginConfig)seConfigs.get("donuts-json");
        config = (StoragePluginConfig)seConfigs.get("queue");
        Scan scan = JdbcDataTest.findOnlyOperator(plan, Scan.class);
        Assert.assertEquals((Object)"donuts-json", (Object)scan.getStorageEngine());
        Project project = JdbcDataTest.findOnlyOperator(plan, Project.class);
        Assert.assertEquals((long)1L, (long)project.getSelections().size());
        Assert.assertEquals(Scan.class, project.getInput().getClass());
        Store store = JdbcDataTest.findOnlyOperator(plan, Store.class);
        Assert.assertEquals((Object)"queue", (Object)store.getStorageEngine());
        Assert.assertEquals((Object)"output sink", (Object)store.getMemo());
        Assert.assertEquals(Project.class, store.getInput().getClass());
    }

    @Test
    public void testProjectFilterSubquery() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").sql("select d['name'] as name, d['xx'] as xx from (\n select _MAP as d from donuts)\nwhere cast(d['ppu'] as double) > 0.6").returns("NAME=Raised; XX=null\nNAME=Filled; XX=null\nNAME=Apple Fritter; XX=null\n");
    }

    private static <T extends LogicalOperator> Iterable<T> findOperator(LogicalPlan plan, final Class<T> operatorClazz) {
        return Iterables.filter((Iterable)plan.getSortedOperators(), (Predicate)new Predicate<LogicalOperator>(){

            public boolean apply(LogicalOperator input) {
                return input.getClass().equals(operatorClazz);
            }
        });
    }

    private static <T extends LogicalOperator> T findOnlyOperator(LogicalPlan plan, Class<T> operatorClazz) {
        return (T)((LogicalOperator)Iterables.getOnlyElement(JdbcDataTest.findOperator(plan, operatorClazz)));
    }

    @Test
    public void testProjectFilterSubqueryPlan() throws Exception {
        LogicalPlan plan = JdbcAssert.withModel(MODEL, "DONUTS").sql("select d['name'] as name, d['xx'] as xx from (\n select _MAP['donuts'] as d from donuts)\nwhere cast(d['ppu'] as double) > 0.6").logicalPlan();
        PlanProperties planProperties = plan.getProperties();
        Assert.assertEquals((Object)"optiq", (Object)planProperties.generator.type);
        Assert.assertEquals((Object)"na", (Object)planProperties.generator.info);
        Assert.assertEquals((long)1L, (long)planProperties.version);
        Assert.assertEquals((Object)PlanProperties.PlanType.APACHE_DRILL_LOGICAL, (Object)planProperties.type);
        Map seConfigs = plan.getStorageEngines();
        StoragePluginConfig config = (StoragePluginConfig)seConfigs.get("donuts-json");
        config = (StoragePluginConfig)seConfigs.get("queue");
        Scan scan = JdbcDataTest.findOnlyOperator(plan, Scan.class);
        Assert.assertEquals((Object)"donuts-json", (Object)scan.getStorageEngine());
        Filter filter = JdbcDataTest.findOnlyOperator(plan, Filter.class);
        Assert.assertTrue((boolean)(filter.getInput() instanceof Scan));
        Project[] projects = (Project[])Iterables.toArray(JdbcDataTest.findOperator(plan, Project.class), Project.class);
        Assert.assertEquals((long)2L, (long)projects.length);
        Assert.assertEquals((long)1L, (long)projects[0].getSelections().size());
        Assert.assertEquals(Filter.class, projects[0].getInput().getClass());
        Assert.assertEquals((long)2L, (long)projects[1].getSelections().size());
        Assert.assertEquals(Project.class, projects[1].getInput().getClass());
        Store store = JdbcDataTest.findOnlyOperator(plan, Store.class);
        Assert.assertEquals((Object)"queue", (Object)store.getStorageEngine());
        Assert.assertEquals((Object)"output sink", (Object)store.getMemo());
        Assert.assertEquals(Project.class, store.getInput().getClass());
    }

    @Test
    @Ignore
    public void testProjectNestedFieldSugared() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").sql("select donuts.ppu from donuts").returns("C=4\nC=4\nC=4\nC=4\nC=4\n");
    }

    @Test
    public void testFilterConstantFalse() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").sql("select * from donuts where 3 > 4").returns("");
    }

    @Test
    public void testFilterConstant() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").sql("select * from donuts where 3 < 4").returns(EXPECTED);
    }

    @Ignore
    @Test
    public void testValues() throws Exception {
        JdbcAssert.withModel(MODEL, "DONUTS").sql("values (1)").returns("EXPR$0=1\n");
    }

    @Test
    public void testJoin() throws Exception {
        Join join = JdbcAssert.withModel(MODEL, "HR").sql("select * from emp join dept on emp.deptId = dept.deptId").returnsUnordered("DEPTID=31; LASTNAME=Rafferty; DEPTID0=31; NAME=Sales", "DEPTID=33; LASTNAME=Jones; DEPTID0=33; NAME=Engineering", "DEPTID=33; LASTNAME=Steinberg; DEPTID0=33; NAME=Engineering", "DEPTID=34; LASTNAME=Robinson; DEPTID0=34; NAME=Clerical", "DEPTID=34; LASTNAME=Smith; DEPTID0=34; NAME=Clerical").planContains(Join.class);
        Assert.assertEquals((Object)JoinRelType.INNER, (Object)join.getJoinType());
    }

    @Test
    public void testLeftJoin() throws Exception {
        Join join = JdbcAssert.withModel(MODEL, "HR").sql("select * from emp left join dept on emp.deptId = dept.deptId").returnsUnordered("DEPTID=31; LASTNAME=Rafferty; DEPTID0=31; NAME=Sales", "DEPTID=33; LASTNAME=Jones; DEPTID0=33; NAME=Engineering", "DEPTID=33; LASTNAME=Steinberg; DEPTID0=33; NAME=Engineering", "DEPTID=34; LASTNAME=Robinson; DEPTID0=34; NAME=Clerical", "DEPTID=34; LASTNAME=Smith; DEPTID0=34; NAME=Clerical", "DEPTID=null; LASTNAME=John; DEPTID0=null; NAME=null").planContains(Join.class);
        Assert.assertEquals((Object)JoinRelType.LEFT, (Object)join.getJoinType());
    }

    @Test
    @Ignore
    public void testRightJoin() throws Exception {
        Join join = JdbcAssert.withModel(MODEL, "HR").sql("select * from emp right join dept on emp.deptId = dept.deptId").returnsUnordered("xx").planContains(Join.class);
        Assert.assertEquals((Object)JoinRelType.LEFT, (Object)join.getJoinType());
    }

    @Test
    public void testFullJoin() throws Exception {
        Join join = JdbcAssert.withModel(MODEL, "HR").sql("select * from emp full join dept on emp.deptId = dept.deptId").returnsUnordered("DEPTID=31; LASTNAME=Rafferty; DEPTID0=31; NAME=Sales", "DEPTID=33; LASTNAME=Jones; DEPTID0=33; NAME=Engineering", "DEPTID=33; LASTNAME=Steinberg; DEPTID0=33; NAME=Engineering", "DEPTID=34; LASTNAME=Robinson; DEPTID0=34; NAME=Clerical", "DEPTID=34; LASTNAME=Smith; DEPTID0=34; NAME=Clerical", "DEPTID=null; LASTNAME=John; DEPTID0=null; NAME=null", "DEPTID=null; LASTNAME=null; DEPTID0=35; NAME=Marketing").planContains(Join.class);
        Assert.assertEquals((Object)JoinRelType.FULL, (Object)join.getJoinType());
    }

    @Test
    public void testJoinOnSubquery() throws Exception {
        Join join = JdbcAssert.withModel(MODEL, "HR").sql("select * from (\nselect deptId, lastname, 'x' as name from emp) as e\n join dept on e.deptId = dept.deptId").returnsUnordered("DEPTID=31; LASTNAME=Rafferty; NAME=x; DEPTID0=31; NAME0=Sales", "DEPTID=33; LASTNAME=Jones; NAME=x; DEPTID0=33; NAME0=Engineering", "DEPTID=33; LASTNAME=Steinberg; NAME=x; DEPTID0=33; NAME0=Engineering", "DEPTID=34; LASTNAME=Robinson; NAME=x; DEPTID0=34; NAME0=Clerical", "DEPTID=34; LASTNAME=Smith; NAME=x; DEPTID0=34; NAME0=Clerical").planContains(Join.class);
        Assert.assertEquals((Object)JoinRelType.INNER, (Object)join.getJoinType());
    }

    @Test
    @Ignore
    public void testFoodMart() throws Exception {
        JdbcAssert.withModel(MODEL, "FOODMART").sql("select * from product_class where cast(_map['product_class_id'] as integer) < 3").returnsUnordered("_MAP={product_category=Seafood, product_class_id=2, product_department=Seafood, product_family=Food, product_subcategory=Shellfish}", "_MAP={product_category=Specialty, product_class_id=1, product_department=Produce, product_family=Food, product_subcategory=Nuts}");
    }

    @Test
    public void testUnionAll() throws Exception {
        Union union = JdbcAssert.withModel(MODEL, "HR").sql("select deptId from dept\nunion all\nselect deptId from emp").returnsUnordered("DEPTID=31", "DEPTID=33", "DEPTID=34", "DEPTID=35", "DEPTID=null").planContains(Union.class);
        Assert.assertFalse((boolean)union.isDistinct());
    }

    @Test
    public void testUnion() throws Exception {
        Union union = JdbcAssert.withModel(MODEL, "HR").sql("select deptId from dept\nunion\nselect deptId from emp").returnsUnordered("DEPTID=31", "DEPTID=33", "DEPTID=34", "DEPTID=35", "DEPTID=null").planContains(Union.class);
        Assert.assertTrue((boolean)union.isDistinct());
    }

    @Test
    public void testOrderByDescNullsFirst() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select * from emp order by deptId desc nulls first").returns("DEPTID=null; LASTNAME=John\nDEPTID=34; LASTNAME=Robinson\nDEPTID=34; LASTNAME=Smith\nDEPTID=33; LASTNAME=Jones\nDEPTID=33; LASTNAME=Steinberg\nDEPTID=31; LASTNAME=Rafferty\n").planContains(Order.class);
    }

    @Test
    public void testOrderByDescNullsLast() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select * from emp order by deptId desc nulls last").returns("DEPTID=34; LASTNAME=Robinson\nDEPTID=34; LASTNAME=Smith\nDEPTID=33; LASTNAME=Jones\nDEPTID=33; LASTNAME=Steinberg\nDEPTID=31; LASTNAME=Rafferty\nDEPTID=null; LASTNAME=John\n").planContains(Order.class);
    }

    @Test
    @Ignore
    public void testOrderByDesc() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select * from emp order by deptId desc").returns("DEPTID=null; LASTNAME=John\nDEPTID=34; LASTNAME=Robinson\nDEPTID=34; LASTNAME=Smith\nDEPTID=33; LASTNAME=Jones\nDEPTID=33; LASTNAME=Steinberg\nDEPTID=31; LASTNAME=Rafferty\n").planContains(Order.class);
    }

    @Test
    public void testOrderBy() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select * from emp order by deptId").returns("DEPTID=31; LASTNAME=Rafferty\nDEPTID=33; LASTNAME=Jones\nDEPTID=33; LASTNAME=Steinberg\nDEPTID=34; LASTNAME=Robinson\nDEPTID=34; LASTNAME=Smith\nDEPTID=null; LASTNAME=John\n").planContains(Order.class);
    }

    @Test
    public void testLimit() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select LASTNAME from emp limit 2").returns("LASTNAME=Rafferty\nLASTNAME=Jones").planContains(Limit.class);
    }

    @Test
    public void testLimitOrderBy() throws Exception {
        JdbcAssert.TestDataConnection tdc = JdbcAssert.withModel(MODEL, "HR").sql("select LASTNAME from emp order by LASTNAME limit 2").returns("LASTNAME=John\nLASTNAME=Jones");
        tdc.planContains(Limit.class);
        tdc.planContains(Order.class);
    }

    @Test
    public void testOrderByWithOffset() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select LASTNAME from emp order by LASTNAME asc offset 3").returns("LASTNAME=Robinson\nLASTNAME=Smith\nLASTNAME=Steinberg").planContains(Limit.class);
    }

    @Test
    public void testOrderByWithOffsetAndFetch() throws Exception {
        JdbcAssert.withModel(MODEL, "HR").sql("select LASTNAME from emp order by LASTNAME asc offset 3 fetch next 2 rows only").returns("LASTNAME=Robinson\nLASTNAME=Smith").planContains(Limit.class);
    }
}

