/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.apache.drill.exec.client.InvalidConnectionInfoException;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.jdbc.test.JdbcAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcConnectTriesTestEmbeddedBits
extends JdbcTestBase {
    public static Driver testDrillDriver;

    @BeforeClass
    public static void testSetUp() throws Exception {
        testDrillDriver = new Driver();
    }

    @Test
    public void testDirectConnectionConnectTriesEqualsDrillbitCount() throws SQLException {
        Connection connection = null;
        try {
            connection = testDrillDriver.connect("jdbc:drill:drillbit=127.0.0.1:5000,127.0.0.1:5001;tries=2", JdbcAssert.getDefaultProperties());
            TestCase.fail();
        }
        catch (SQLException ex) {
            Assert.assertNull(connection);
            Assert.assertTrue((boolean)(ex.getCause() instanceof RpcException));
            Assert.assertTrue((boolean)(ex.getCause().getCause() instanceof ExecutionException));
        }
    }

    @Test
    public void testDirectConnectionConnectTriesGreaterThanDrillbitCount() throws SQLException {
        Connection connection = null;
        try {
            connection = testDrillDriver.connect("jdbc:drill:drillbit=127.0.0.1:5000,127.0.0.1:5001;tries=5", JdbcAssert.getDefaultProperties());
            TestCase.fail();
        }
        catch (SQLException ex) {
            Assert.assertNull(connection);
            Assert.assertTrue((boolean)(ex.getCause() instanceof RpcException));
            Assert.assertTrue((boolean)(ex.getCause().getCause() instanceof ExecutionException));
        }
    }

    @Test
    public void testDirectConnectionConnectTriesLessThanDrillbitCount() throws SQLException {
        Connection connection = null;
        try {
            connection = testDrillDriver.connect("jdbc:drill:drillbit=127.0.0.1:5000,127.0.0.1:5001;tries=1", JdbcAssert.getDefaultProperties());
            TestCase.fail();
        }
        catch (SQLException ex) {
            Assert.assertNull(connection);
            Assert.assertTrue((boolean)(ex.getCause() instanceof RpcException));
            Assert.assertTrue((boolean)(ex.getCause().getCause() instanceof ExecutionException));
        }
    }

    @Test
    public void testDirectConnectionInvalidConnectTries() throws SQLException {
        Connection connection = null;
        try {
            connection = testDrillDriver.connect("jdbc:drill:drillbit=127.0.0.1:5000,127.0.0.1:5001;tries=abc", JdbcAssert.getDefaultProperties());
            TestCase.fail();
        }
        catch (SQLException ex) {
            Assert.assertNull(connection);
            Assert.assertTrue((boolean)(ex.getCause() instanceof InvalidConnectionInfoException));
        }
    }

    @Test
    public void testDirectConnectionZeroConnectTries() throws SQLException {
        Connection connection = null;
        try {
            connection = testDrillDriver.connect("jdbc:drill:drillbit=127.0.0.1:5000,127.0.0.1:5001;tries=0", JdbcAssert.getDefaultProperties());
            TestCase.fail();
        }
        catch (SQLException ex) {
            Assert.assertNull(connection);
            Assert.assertTrue((boolean)(ex.getCause() instanceof RpcException));
            Assert.assertTrue((boolean)(ex.getCause().getCause() instanceof ExecutionException));
        }
    }

    @Test
    public void testDirectConnectionNegativeConnectTries() throws SQLException {
        Connection connection = null;
        try {
            connection = testDrillDriver.connect("jdbc:drill:drillbit=127.0.0.1:5000,127.0.0.1:5001;tries=-5", JdbcAssert.getDefaultProperties());
            TestCase.fail();
        }
        catch (SQLException ex) {
            Assert.assertNull(connection);
            Assert.assertTrue((boolean)(ex.getCause() instanceof RpcException));
            Assert.assertTrue((boolean)(ex.getCause().getCause() instanceof ExecutionException));
        }
    }

    @Test
    public void testZKSuccessfulConnectionZeroConnectTries() throws SQLException {
        Connection connection = testDrillDriver.connect("jdbc:drill:zk=local;tries=0", JdbcAssert.getDefaultProperties());
        junit.framework.Assert.assertNotNull((Object)connection);
        connection.close();
    }

    @Test
    public void testZKSuccessfulConnectionNegativeConnectTries() throws SQLException {
        Connection connection = testDrillDriver.connect("jdbc:drill:zk=local;tries=-1", JdbcAssert.getDefaultProperties());
        junit.framework.Assert.assertNotNull((Object)connection);
        connection.close();
    }

    @Test
    public void testZKSuccessfulConnectionGreaterThanConnectTries() throws SQLException {
        Connection connection = testDrillDriver.connect("jdbc:drill:zk=local;tries=7", JdbcAssert.getDefaultProperties());
        junit.framework.Assert.assertNotNull((Object)connection);
        connection.close();
    }

    @Test
    public void testZKConnectionInvalidConnectTries() throws SQLException {
        Connection connection = null;
        try {
            connection = testDrillDriver.connect("jdbc:drill:zk=local;tries=abc", JdbcAssert.getDefaultProperties());
            TestCase.fail();
        }
        catch (SQLException ex) {
            Assert.assertNull(connection);
            Assert.assertTrue((boolean)(ex.getCause() instanceof InvalidConnectionInfoException));
        }
    }
}

