/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.drill.jdbc.Driver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Drill2288GetColumnsMetadataWhenNoRowsTest {
    private static Connection connection;

    @BeforeClass
    public static void setUpConnection() throws SQLException {
        connection = new Driver().connect("jdbc:drill:zk=local", null);
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
    }

    @Test
    public void testEmptyJsonFileDoesntSuppressNetSchema1() throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet results = stmt.executeQuery("SELECT a, b, c, * FROM cp.`empty.json`");
        ResultSetMetaData metadata = results.getMetaData();
        Assert.assertThat((String)"ResultSetMetaData.getColumnCount() should have been > 0", (Object)metadata.getColumnCount(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0)));
        Assert.assertThat((String)"Unexpected non-empty results.  Test rot?", (Object)false, (Matcher)CoreMatchers.equalTo((Object)results.next()));
    }

    @Test
    public void testEmptyJsonFileDoesntSuppressNetSchema2() throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet results = stmt.executeQuery("SELECT a FROM cp.`empty.json`");
        ResultSetMetaData metadata = results.getMetaData();
        Assert.assertThat((String)"ResultSetMetaData.getColumnCount() should have been 1", (Object)metadata.getColumnCount(), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((String)"Unexpected non-empty results.  Test rot?", (Object)false, (Matcher)CoreMatchers.equalTo((Object)results.next()));
    }

    @Test
    public void testInfoSchemaTablesZeroRowsBy_TABLE_SCHEMA_works() throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet results = stmt.executeQuery("SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA = ''");
        ResultSetMetaData metadata = results.getMetaData();
        Assert.assertThat((String)"ResultSetMetaData.getColumnCount() should have been > 0", (Object)metadata.getColumnCount(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0)));
        Assert.assertThat((String)"Unexpected non-empty results.  Test rot?", (Object)false, (Matcher)CoreMatchers.equalTo((Object)results.next()));
    }

    @Test
    public void testInfoSchemaTablesZeroRowsBy_TABLE_CATALOG_works() throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet results = stmt.executeQuery("SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_CATALOG = ''");
        ResultSetMetaData metadata = results.getMetaData();
        Assert.assertThat((String)"ResultSetMetaData.getColumnCount() should have been > 0", (Object)metadata.getColumnCount(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0)));
        Assert.assertThat((String)"Unexpected non-empty results.  Test rot?", (Object)false, (Matcher)CoreMatchers.equalTo((Object)results.next()));
    }

    @Test
    public void testInfoSchemaTablesZeroRowsBy_TABLE_NAME_works() throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet results = stmt.executeQuery("SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_NAME = ''");
        ResultSetMetaData metadata = results.getMetaData();
        Assert.assertThat((String)"ResultSetMetaData.getColumnCount() should have been > 0", (Object)metadata.getColumnCount(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0)));
        Assert.assertThat((String)"Unexpected non-empty results.  Test rot?", (Object)false, (Matcher)CoreMatchers.equalTo((Object)results.next()));
    }

    @Test
    public void testInfoSchemaTablesZeroRowsByLimitWorks() throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet results = stmt.executeQuery("SELECT * FROM INFORMATION_SCHEMA.`TABLES` LIMIT 0");
        ResultSetMetaData metadata = results.getMetaData();
        Assert.assertThat((String)"ResultSetMetaData.getColumnCount() should have been > 0", (Object)metadata.getColumnCount(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0)));
        Assert.assertThat((String)"Unexpected non-empty results.  Test rot?", (Object)false, (Matcher)CoreMatchers.equalTo((Object)results.next()));
    }

    @Test
    public void testInfoSchemaTablesZeroRowsByWhereFalseWorks() throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet results = stmt.executeQuery("SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE FALSE");
        ResultSetMetaData metadata = results.getMetaData();
        Assert.assertThat((String)"ResultSetMetaData.getColumnCount() should have been > 0", (Object)metadata.getColumnCount(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0)));
        Assert.assertThat((String)"Unexpected non-empty results.  Test rot?", (Object)false, (Matcher)CoreMatchers.equalTo((Object)results.next()));
    }

    @Test
    public void testGetTablesZeroRowsByTableSchemaOrNameWorks() throws Exception {
        DatabaseMetaData dbMetadata = connection.getMetaData();
        ResultSet results = dbMetadata.getTables("NoSuchCatalog", "NoSuchSchema", "NoSuchTable", new String[0]);
        ResultSetMetaData metadata = results.getMetaData();
        Assert.assertThat((String)"ResultSetMetaData.getColumnCount() should have been > 0", (Object)metadata.getColumnCount(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)0)));
        Assert.assertThat((String)"Unexpected non-empty results.  Test rot?", (Object)false, (Matcher)CoreMatchers.equalTo((Object)results.next()));
    }
}

