/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.proxy;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.drill.jdbc.proxy.ProxySetupSQLException;
import org.apache.drill.test.DrillTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TracingProxyDriverClassLoadingTest
extends DrillTest {
    @Ignore(value="except when run in own JVM (so Drill Driver not already loaded)")
    @Test
    public void testClassLoading() throws SQLException, ClassNotFoundException {
        try {
            DriverManager.getDriver("jdbc:drill:zk=local");
            throw new IllegalStateException("Drill driver seems loaded already; can't test loading.");
        }
        catch (SQLException e) {
            Assert.assertThat((String)"Not expected messsage.  (Did JDK change?)", (Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"No suitable driver"));
            try {
                DriverManager.getConnection("jdbc:drill:zk=local", null);
                throw new IllegalStateException("Drill driver seems loaded already; can't test loading.");
            }
            catch (SQLException e2) {
                Assert.assertThat((String)"Not expected messsage.  (Did JDK change?)", (Object)e2.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"No suitable driver found for jdbc:drill:zk=local"));
                try {
                    DriverManager.getDriver("jdbc:proxy::jdbc:drill:zk=local");
                    throw new IllegalStateException("Proxy driver seems loaded already; can't test loading.");
                }
                catch (SQLException e3) {
                    Assert.assertThat((String)"Not expected messsage.  (Did JDK change?)", (Object)e3.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"No suitable driver"));
                    try {
                        DriverManager.getConnection("jdbc:proxy::jdbc:drill:zk=local", null);
                        throw new IllegalStateException("Proxy driver seems loaded already; can't test loading.");
                    }
                    catch (SQLException e4) {
                        Assert.assertThat((String)"Not expected messsage.  (Did JDK change?)", (Object)e4.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"No suitable driver found for jdbc:proxy::jdbc:drill:zk=local"));
                        Class.forName("org.apache.drill.jdbc.proxy.TracingProxyDriver");
                        try {
                            DriverManager.getConnection("jdbc:proxy::jdbc:drill:zk=local", null);
                            throw new IllegalStateException("Drill driver seems loaded already; can't test loading.");
                        }
                        catch (ProxySetupSQLException e5) {
                            Assert.assertThat((String)"Not expected messsage.  (Was it just modified?)", (Object)e5.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Error getting driver from DriverManager for proxied URL \"jdbc:drill:zk=local\" (from proxy driver URL \"jdbc:proxy::jdbc:drill:zk=local\" (after third colon)): java.sql.SQLException: No suitable driver"));
                            Driver driver = DriverManager.getDriver("jdbc:proxy:org.apache.drill.jdbc.Driver:jdbc:drill:zk=local");
                            Assert.assertThat((Object)driver.acceptsURL("jdbc:proxy::jdbc:drill:zk=local"), (Matcher)CoreMatchers.equalTo((Object)true));
                            Assert.assertThat((Object)driver.acceptsURL("jdbc:drill:zk=local"), (Matcher)CoreMatchers.equalTo((Object)false));
                            Connection proxyConnection = DriverManager.getConnection("jdbc:proxy::jdbc:drill:zk=local", null);
                            Assert.assertThat((Object)proxyConnection, (Matcher)CoreMatchers.notNullValue());
                            DatabaseMetaData dbMetaData = proxyConnection.getMetaData();
                            Assert.assertThat((Object)dbMetaData, (Matcher)CoreMatchers.instanceOf(DatabaseMetaData.class));
                            return;
                        }
                    }
                }
            }
        }
    }
}

