/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ResultSetGetMethodConversionsTest
extends JdbcTestBase {
    private static Connection connection;
    private static ResultSet testDataRow;
    private static ResultSet testDataRowWithNulls;

    @BeforeClass
    public static void setUpConnectionAndMetadataToCheck() throws SQLException {
        connection = new Driver().connect("jdbc:drill:zk=local", null);
        Statement stmt = connection.createStatement();
        testDataRow = stmt.executeQuery("SELECT  \n\n  TRUE                             AS  C_BOOLEAN_TRUE, \n  CAST(  3 AS INTEGER            ) AS  C_INTEGER_3, \n  CAST(  4 AS BIGINT             ) AS  C_BIGINT_4, \n  CAST(  6.6 AS DOUBLE PRECISION ) AS `C_DOUBLE_PREC._6.6`, \n  CAST(  7.7 AS FLOAT            ) AS `C_FLOAT_7.7`, \n  CAST( 10.10 AS DECIMAL         ) AS `C_DECIMAL_10.10`, \n  CAST( 10.5  AS DECIMAL         ) AS `C_DECIMAL_10.5`, \n  CAST( 11.11 AS DECIMAL(9,2)    ) AS `C_DECIMAL(9,2)_11.11`, \n  CAST( 12.12 AS DECIMAL(18,2)   ) AS `C_DECIMAL(18,2)_12.12`, \n  CAST( 13.13 AS DECIMAL(28,2)   ) AS `C_DECIMAL(28,2)_13.13`, \n  CAST( 14.14 AS DECIMAL(38,2)   ) AS `C_DECIMAL(38,2)_14.14`, \n  '' \nFROM INFORMATION_SCHEMA.CATALOGS \nLIMIT 1 ");
        Assert.assertTrue((boolean)testDataRow.next());
        Statement stmtForNulls = connection.createStatement();
        testDataRowWithNulls = stmtForNulls.executeQuery("SELECT  \n\n  CAST(null as boolean)                  AS  C_BOOLEAN_TRUE, \n  CAST(  null AS INTEGER            ) AS  C_INTEGER_3, \n  CAST(  null AS BIGINT             ) AS  C_BIGINT_4, \n  CAST(  null AS DOUBLE PRECISION ) AS `C_DOUBLE_PREC._6.6`, \n  CAST(  null AS FLOAT            ) AS `C_FLOAT_7.7`, \n  CAST( null AS DECIMAL         ) AS `C_DECIMAL_10.10`, \n  CAST( null  AS DECIMAL         ) AS `C_DECIMAL_10.5`, \n  CAST( null AS DECIMAL(9,2)    ) AS `C_DECIMAL(9,2)_11.11`, \n  CAST( null AS DECIMAL(18,2)   ) AS `C_DECIMAL(18,2)_12.12`, \n  CAST( null AS DECIMAL(28,2)   ) AS `C_DECIMAL(28,2)_13.13`, \n  CAST( null AS DECIMAL(38,2)   ) AS `C_DECIMAL(38,2)_14.14`, \n  '' \nFROM (VALUES(1))");
        Assert.assertTrue((boolean)testDataRowWithNulls.next());
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_getByte_handles_TINYINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getByte("C_TINYINT_1"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getByte_handles_SMALLINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getByte("C_SMALLINT_2"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_getByte_handles_INTEGER() throws SQLException {
        Assert.assertThat((Object)testDataRow.getByte("C_INTEGER_3"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_getByte_handles_BIGINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getByte("C_BIGINT_4"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getByte_handles_REAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getByte("C_REAL_5.5"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_getByte_handles_DOUBLE() throws SQLException {
        Assert.assertThat((Object)testDataRow.getByte("C_DOUBLE_PREC._6.6"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_getByte_handles_FLOAT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getByte("C_FLOAT_7.7"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_getByte_handles_DECIMAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getByte("C_DECIMAL_10.10"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_getShort_handles_TINYINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getShort("C_TINYINT_1"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getShort_handles_SMALLINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getShort("C_SMALLINT_2"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_getShort_handles_INTEGER() throws SQLException {
        Assert.assertThat((Object)testDataRow.getShort("C_INTEGER_3"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_getShort_handles_BIGINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getShort("C_BIGINT_4"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getShort_handles_REAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getShort("C_REAL_5.5"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_getShort_handles_DOUBLE() throws SQLException {
        Assert.assertThat((Object)testDataRow.getShort("C_DOUBLE_PREC._6.6"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_getShort_handles_FLOAT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getShort("C_FLOAT_7.7"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_getShort_handles_DECIMAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getShort("C_DECIMAL_10.10"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_getInt_handles_TINYINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getInt("C_TINYINT_1"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getInt_handles_SMALLINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getInt("C_SMALLINT_2"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_getInt_handles_INTEGER() throws SQLException {
        Assert.assertThat((Object)testDataRow.getInt("C_INTEGER_3"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_getInt_handles_BIGINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getInt("C_BIGINT_4"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getInt_handles_REAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getInt("C_REAL_5.5"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_getInt_handles_DOUBLE() throws SQLException {
        Assert.assertThat((Object)testDataRow.getInt("C_DOUBLE_PREC._6.6"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_getInt_handles_FLOAT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getInt("C_FLOAT_7.7"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_getInt_handles_DECIMAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getInt("C_DECIMAL_10.10"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_getLong_handles_TINYINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getLong("C_TINYINT_1"), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getLong_handles_SMALLINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getLong("C_SMALLINT_2"), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void test_getLong_handles_INTEGER() throws SQLException {
        Assert.assertThat((Object)testDataRow.getLong("C_INTEGER_3"), (Matcher)CoreMatchers.equalTo((Object)3L));
    }

    @Test
    public void test_getLong_handles_BIGINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getLong("C_BIGINT_4"), (Matcher)CoreMatchers.equalTo((Object)4L));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getLong_handles_REAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getLong("C_REAL_5.5"), (Matcher)CoreMatchers.equalTo((Object)5L));
    }

    @Test
    public void test_getLong_handles_DOUBLE() throws SQLException {
        Assert.assertThat((Object)testDataRow.getLong("C_DOUBLE_PREC._6.6"), (Matcher)CoreMatchers.equalTo((Object)6L));
    }

    @Test
    public void test_getLong_handles_FLOAT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getLong("C_FLOAT_7.7"), (Matcher)CoreMatchers.equalTo((Object)7L));
    }

    @Test
    public void test_getLong_handles_DECIMAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getLong("C_DECIMAL_10.10"), (Matcher)CoreMatchers.equalTo((Object)10L));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_getFloat_handles_TINYINT() throws SQLException {
        Assert.assertThat((Object)Float.valueOf(testDataRow.getFloat("C_TINYINT_1")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(1.0f)));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getFloat_handles_SMALLINT() throws SQLException {
        Assert.assertThat((Object)Float.valueOf(testDataRow.getFloat("C_SMALLINT_2")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(2.0f)));
    }

    @Test
    public void test_getFloat_handles_INTEGER() throws SQLException {
        Assert.assertThat((Object)Float.valueOf(testDataRow.getFloat("C_INTEGER_3")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(3.0f)));
    }

    @Test
    public void test_getFloat_handles_BIGINT() throws SQLException {
        Assert.assertThat((Object)Float.valueOf(testDataRow.getFloat("C_BIGINT_4")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(4.0f)));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getFloat_handles_REAL() throws SQLException {
        Assert.assertThat((Object)Float.valueOf(testDataRow.getFloat("C_REAL_5.5")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(5.5f)));
    }

    @Test
    public void test_getFloat_handles_DOUBLE() throws SQLException {
        Assert.assertThat((Object)Float.valueOf(testDataRow.getFloat("C_DOUBLE_PREC._6.6")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(6.6f)));
    }

    @Test
    public void test_getFloat_handles_FLOAT() throws SQLException {
        Assert.assertThat((Object)Float.valueOf(testDataRow.getFloat("C_FLOAT_7.7")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(7.7f)));
    }

    @Test
    public void test_getFloat_handles_DECIMAL() throws SQLException {
        Assert.assertThat((Object)Float.valueOf(testDataRow.getFloat("C_DECIMAL_10.10")), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(10.1f)));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_getDouble_handles_TINYINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getDouble("C_TINYINT_1"), (Matcher)CoreMatchers.equalTo((Object)1.0));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getDouble_handles_SMALLINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getDouble("C_SMALLINT_2"), (Matcher)CoreMatchers.equalTo((Object)2.0));
    }

    @Test
    public void test_getDouble_handles_INTEGER() throws SQLException {
        Assert.assertThat((Object)testDataRow.getDouble("C_INTEGER_3"), (Matcher)CoreMatchers.equalTo((Object)3.0));
    }

    @Test
    public void test_getDouble_handles_BIGINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getDouble("C_BIGINT_4"), (Matcher)CoreMatchers.equalTo((Object)4.0));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getDouble_handles_REAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getDouble("C_REAL_5.5"), (Matcher)CoreMatchers.equalTo((Object)5.5));
    }

    @Test
    public void test_getDouble_handles_DOUBLE() throws SQLException {
        Assert.assertThat((Object)testDataRow.getDouble("C_DOUBLE_PREC._6.6"), (Matcher)CoreMatchers.equalTo((Object)6.6));
    }

    @Test
    public void test_getDouble_handles_FLOAT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getDouble("C_FLOAT_7.7"), (Matcher)CoreMatchers.equalTo((Object)7.7f));
    }

    @Test
    public void test_getDouble_handles_DECIMAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getDouble("C_DECIMAL_10.10"), (Matcher)CoreMatchers.equalTo((Object)10.1));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_getBigDecimal_handles_TINYINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getBigDecimal("C_TINYINT_1"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal(1)));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getBigDecimal_handles_SMALLINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getBigDecimal("C_SMALLINT_2"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal(2)));
    }

    @Test
    public void test_getBigDecimal_handles_INTEGER() throws SQLException {
        Assert.assertThat((Object)testDataRow.getBigDecimal("C_INTEGER_3"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal(3)));
    }

    @Test
    public void test_getBigDecimal_handles_BIGINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getBigDecimal("C_BIGINT_4"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal(4)));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getBigDecimal_handles_REAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getBigDecimal("C_REAL_5.5"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal(5.5)));
    }

    @Test
    public void test_getBigDecimal_handles_DOUBLE() throws SQLException {
        Assert.assertThat((Object)testDataRow.getBigDecimal("C_DOUBLE_PREC._6.6"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal(6.6)));
    }

    @Test
    public void test_getBigDecimal_handles_FLOAT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getBigDecimal("C_FLOAT_7.7"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal(7.7f)));
    }

    @Test
    public void test_getBigDecimal_handles_DECIMAL_1() throws SQLException {
        Assert.assertThat((Object)testDataRow.getBigDecimal("C_DECIMAL_10.5"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal("10.5")));
    }

    @Ignore(value="TODO(DRILL-3367): unignore when DECIMAL is no longer DOUBLE")
    @Test
    public void test_getBigDecimal_handles_DECIMAL_2() throws SQLException {
        Assert.assertThat((Object)testDataRow.getBigDecimal("C_DECIMAL_10.10"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal("10.10")));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_getString_handles_TINYINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getString("C_TINYINT_1"), (Matcher)CoreMatchers.equalTo((Object)"1"));
        Assert.assertThat((Object)testDataRowWithNulls.getString("C_TINYINT_1"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getString_handles_SMALLINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getString("C_SMALLINT_2"), (Matcher)CoreMatchers.equalTo((Object)"2"));
        Assert.assertThat((Object)testDataRowWithNulls.getString("C_SMALLINT_2"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void test_getString_handles_INTEGER() throws SQLException {
        Assert.assertThat((Object)testDataRow.getString("C_INTEGER_3"), (Matcher)CoreMatchers.equalTo((Object)"3"));
        Assert.assertThat((Object)testDataRowWithNulls.getString("C_INTEGER_3"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void test_getString_handles_BIGINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getString("C_BIGINT_4"), (Matcher)CoreMatchers.equalTo((Object)"4"));
        Assert.assertThat((Object)testDataRowWithNulls.getString("C_BIGINT_4"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getString_handles_REAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getString("C_REAL_5.5"), (Matcher)CoreMatchers.equalTo((Object)"5.5????"));
        Assert.assertThat((Object)testDataRowWithNulls.getString("C_REAL_5.5"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void test_getString_handles_DOUBLE() throws SQLException {
        Assert.assertThat((Object)testDataRow.getString("C_DOUBLE_PREC._6.6"), (Matcher)CoreMatchers.equalTo((Object)"6.6"));
        Assert.assertThat((Object)testDataRowWithNulls.getString("C_DOUBLE_PREC._6.6"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void test_getString_handles_FLOAT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getString("C_FLOAT_7.7"), (Matcher)CoreMatchers.equalTo((Object)"7.7"));
        Assert.assertThat((Object)testDataRowWithNulls.getString("C_FLOAT_7.7"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void test_getString_handles_DECIMAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getString("C_DECIMAL_10.10"), (Matcher)CoreMatchers.equalTo((Object)"10.1"));
        Assert.assertThat((Object)testDataRowWithNulls.getString("C_DECIMAL_10.10"), (Matcher)CoreMatchers.equalTo(null));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_getObject_handles_TINYINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getObject("C_TINYINT_1"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_getObject_handles_SMALLINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getObject("C_SMALLINT_2"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_getObject_handles_INTEGER() throws SQLException {
        Assert.assertThat((Object)testDataRow.getObject("C_INTEGER_3"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_getObject_handles_BIGINT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getObject("C_BIGINT_4"), (Matcher)CoreMatchers.equalTo((Object)4L));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_getObject_handles_REAL() throws SQLException {
        Assert.assertThat((Object)testDataRow.getObject("C_REAL_5.5"), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(5.5f)));
    }

    @Test
    public void test_getObject_handles_DOUBLE() throws SQLException {
        Assert.assertThat((Object)testDataRow.getObject("C_DOUBLE_PREC._6.6"), (Matcher)CoreMatchers.equalTo((Object)6.6));
    }

    @Test
    public void test_getObject_handles_FLOAT() throws SQLException {
        Assert.assertThat((Object)testDataRow.getObject("C_FLOAT_7.7"), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(7.7f)));
    }

    @Ignore(value="TODO(DRILL-3367): unignore when DECIMAL is no longer DOUBLE")
    @Test
    public void test_getObject_handles_DECIMAL_1() throws SQLException {
        Assert.assertThat((Object)testDataRow.getObject("C_DECIMAL_10.5"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal("10.5")));
    }

    @Ignore(value="TODO(DRILL-3367): unignore when DECIMAL is no longer DOUBLE")
    @Test
    public void test_getObject_handles_DECIMAL_2() throws SQLException {
        Assert.assertThat((Object)testDataRow.getObject("C_DECIMAL_10.10"), (Matcher)CoreMatchers.equalTo((Object)new BigDecimal("10.10")));
    }
}

