/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.jdbc.test.JdbcAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class DatabaseMetaDataGetColumnsTest
extends JdbcTestBase {
    private static final String VIEW_SCHEMA = "dfs_test.tmp";
    private static final String VIEW_NAME = DatabaseMetaDataGetColumnsTest.class.getSimpleName() + "_View";
    protected static Connection connection;
    protected static DatabaseMetaData dbMetadata;
    protected static ResultSetMetaData rowsMetadata;
    private static ResultSet mdrOptBOOLEAN;
    private static ResultSet mdrReqTINYINT;
    private static ResultSet mdrOptSMALLINT;
    private static ResultSet mdrReqINTEGER;
    private static ResultSet mdrOptBIGINT;
    private static ResultSet mdrOptREAL;
    private static ResultSet mdrOptFLOAT;
    private static ResultSet mdrReqDOUBLE;
    private static ResultSet mdrReqDECIMAL_5_3;
    private static ResultSet mdrReqVARCHAR_10;
    private static ResultSet mdrOptVARCHAR;
    private static ResultSet mdrReqCHAR_5;
    private static ResultSet mdrOptVARBINARY_16;
    private static ResultSet mdrOptBINARY_1048576;
    private static ResultSet mdrReqDATE;
    private static ResultSet mdrReqTIME;
    private static ResultSet mdrOptTIME_7;
    private static ResultSet mdrOptTIMESTAMP;
    private static ResultSet mdrReqINTERVAL_Y;
    private static ResultSet mdrReqINTERVAL_3Y_Mo;
    private static ResultSet mdrReqINTERVAL_Mo;
    private static ResultSet mdrReqINTERVAL_D;
    private static ResultSet mdrReqINTERVAL_4D_H;
    private static ResultSet mdrReqINTERVAL_3D_Mi;
    private static ResultSet mdrReqINTERVAL_2D_S5;
    private static ResultSet mdrReqINTERVAL_H;
    private static ResultSet mdrReqINTERVAL_1H_Mi;
    private static ResultSet mdrReqINTERVAL_3H_S1;
    private static ResultSet mdrReqINTERVAL_Mi;
    private static ResultSet mdrReqINTERVAL_5Mi_S;
    private static ResultSet mdrReqINTERVAL_S;
    private static ResultSet mdrReqINTERVAL_3S;
    private static ResultSet mdrReqINTERVAL_3S1;
    private static ResultSet mdrReqARRAY;
    private static ResultSet mdrReqMAP;
    private static ResultSet mdrUnkSTRUCT;
    private static ResultSet mdrUnkUnion;

    private static ResultSet setUpRow(String schemaName, String tableOrViewName, String columnName) throws SQLException {
        System.out.println("(Setting up row for " + tableOrViewName + "." + columnName + ".)");
        Assert.assertNotNull((String)"dbMetadata is null; must be set before calling setUpRow(...)", (Object)dbMetadata);
        ResultSet testRow = dbMetadata.getColumns("DRILL", schemaName, tableOrViewName, columnName);
        Assert.assertTrue((String)("Test setup error:  No row for column DRILL . `" + schemaName + "` . `" + tableOrViewName + "` . `" + columnName + "`"), (boolean)testRow.next());
        return testRow;
    }

    @BeforeClass
    public static void setUpConnection() throws Exception {
        connection = new Driver().connect("jdbc:drill:zk=local", JdbcAssert.getDefaultProperties());
        dbMetadata = connection.getMetaData();
        DatabaseMetaDataGetColumnsTest.setUpMetadataToCheck();
    }

    protected static void setUpMetadataToCheck() throws Exception {
        Statement stmt = connection.createStatement();
        ResultSet util = stmt.executeQuery("USE dfs_test.tmp");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error setting schema for test: " + util.getString(2)), (boolean)util.getBoolean(1));
        util = stmt.executeQuery("CREATE OR REPLACE VIEW " + VIEW_NAME + " AS SELECT \n  CAST( NULL    AS BOOLEAN            ) AS mdrOptBOOLEAN,        \n  \n  CAST(    1    AS INT            ) AS mdrReqTINYINT,        \n  CAST( NULL    AS INT           ) AS mdrOptSMALLINT,       \n  CAST(    2    AS INTEGER            ) AS mdrReqINTEGER,        \n  CAST( NULL    AS BIGINT             ) AS mdrOptBIGINT,         \n  \n  CAST( NULL    AS FLOAT               ) AS mdrOptREAL,           \n  CAST( NULL    AS FLOAT              ) AS mdrOptFLOAT,          \n  CAST(  3.3    AS DOUBLE             ) AS mdrReqDOUBLE,         \n  \n  CAST(  4.4    AS DECIMAL(5,3)       ) AS mdrReqDECIMAL_5_3,    \n  \n  CAST( 'Hi'    AS VARCHAR(10)        ) AS mdrReqVARCHAR_10,     \n  CAST( NULL    AS VARCHAR            ) AS mdrOptVARCHAR,        \n  CAST( '55'    AS CHAR(5)            ) AS mdrReqCHAR_5,         \n  CAST( NULL    AS VARBINARY(16)      ) AS mdrOptVARBINARY_16,   \n  CAST( NULL    AS VARBINARY(1048576) ) AS mdrOptBINARY_1048576, \n  CAST( NULL    AS BINARY(8)          ) AS mdrOptBINARY_8,       \n  \n                   DATE '2015-01-01'    AS mdrReqDATE,           \n                   TIME '23:59:59'      AS mdrReqTIME,           \n  CAST( NULL    AS TIME(7)            ) AS mdrOptTIME_7,         \n  CAST( NULL    AS TIMESTAMP          ) AS mdrOptTIMESTAMP,      \n  INTERVAL '1'     YEAR                 AS mdrReqINTERVAL_Y,     \n  INTERVAL '1-2'   YEAR(3) TO MONTH     AS mdrReqINTERVAL_3Y_Mo, \n  INTERVAL '2'     MONTH                AS mdrReqINTERVAL_Mo,    \n  INTERVAL '3'     DAY                  AS mdrReqINTERVAL_D,     \n  INTERVAL '3 4'   DAY(4) TO HOUR       AS mdrReqINTERVAL_4D_H,  \n  INTERVAL '3 4:5' DAY(3) TO MINUTE     AS mdrReqINTERVAL_3D_Mi, \n  INTERVAL '3 4:5:6' DAY(2) TO SECOND(5) AS mdrReqINTERVAL_2D_S5, \n  INTERVAL '4'     HOUR                 AS mdrReqINTERVAL_H,     \n  INTERVAL '4:5'   HOUR(1) TO MINUTE    AS mdrReqINTERVAL_1H_Mi, \n  INTERVAL '4:5:6' HOUR(3) TO SECOND(1) AS mdrReqINTERVAL_3H_S1, \n  INTERVAL '5'     MINUTE               AS mdrReqINTERVAL_Mi,    \n  INTERVAL '5:6'   MINUTE(5) TO SECOND  AS mdrReqINTERVAL_5Mi_S, \n  INTERVAL '6'     SECOND               AS mdrReqINTERVAL_S,     \n  INTERVAL '6'     SECOND(3)            AS mdrReqINTERVAL_3S,    \n  INTERVAL '6'     SECOND(3, 1)         AS mdrReqINTERVAL_3S1,   \n  '' \nFROM INFORMATION_SCHEMA.COLUMNS \nLIMIT 1 ");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error creating temporary test-columns view " + VIEW_NAME + ": " + util.getString(2)), (boolean)util.getBoolean(1));
        mdrOptBOOLEAN = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrOptBOOLEAN");
        mdrReqINTEGER = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTEGER");
        mdrOptBIGINT = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrOptBIGINT");
        mdrOptFLOAT = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrOptFLOAT");
        mdrReqDOUBLE = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqDOUBLE");
        mdrReqDECIMAL_5_3 = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqDECIMAL_5_3");
        mdrReqVARCHAR_10 = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqVARCHAR_10");
        mdrOptVARCHAR = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrOptVARCHAR");
        mdrReqCHAR_5 = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqCHAR_5");
        mdrOptVARBINARY_16 = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrOptVARBINARY_16");
        mdrOptBINARY_1048576 = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrOptBINARY_1048576");
        mdrReqDATE = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqDATE");
        mdrReqTIME = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqTIME");
        mdrOptTIME_7 = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrOptTIME_7");
        mdrOptTIMESTAMP = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrOptTIMESTAMP");
        mdrReqINTERVAL_Y = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_Y");
        mdrReqINTERVAL_3Y_Mo = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_3Y_Mo");
        mdrReqINTERVAL_Mo = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_Mo");
        mdrReqINTERVAL_D = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_D");
        mdrReqINTERVAL_4D_H = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_4D_H");
        mdrReqINTERVAL_3D_Mi = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_3D_Mi");
        mdrReqINTERVAL_2D_S5 = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_2D_S5");
        mdrReqINTERVAL_H = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_H");
        mdrReqINTERVAL_1H_Mi = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_1H_Mi");
        mdrReqINTERVAL_3H_S1 = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_3H_S1");
        mdrReqINTERVAL_Mi = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_Mi");
        mdrReqINTERVAL_5Mi_S = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_5Mi_S");
        mdrReqINTERVAL_S = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_S");
        mdrReqINTERVAL_3S = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_3S");
        mdrReqINTERVAL_3S1 = DatabaseMetaDataGetColumnsTest.setUpRow(VIEW_SCHEMA, VIEW_NAME, "mdrReqINTERVAL_3S1");
        ResultSet allColumns = dbMetadata.getColumns(null, null, "%", "%");
        rowsMetadata = allColumns.getMetaData();
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        ResultSet util = connection.createStatement().executeQuery("DROP VIEW " + VIEW_NAME + "");
        Assert.assertTrue((boolean)util.next());
        Assert.assertTrue((String)("Error dropping temporary test-columns view " + VIEW_NAME + ": " + util.getString(2)), (boolean)util.getBoolean(1));
        connection.close();
    }

    private Integer getIntOrNull(ResultSet row, String columnName) throws SQLException {
        int value = row.getInt(columnName);
        return row.wasNull() ? null : new Integer(value);
    }

    @Test
    public void testMetadataHasRightNumberOfColumns() throws SQLException {
        Assert.assertThat((String)"column count", (Object)rowsMetadata.getColumnCount(), (Matcher)CoreMatchers.equalTo((Object)24));
    }

    @Test
    public void test_TABLE_CAT_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(1), (Matcher)CoreMatchers.equalTo((Object)"TABLE_CAT"));
    }

    @Test
    public void test_TABLE_CAT_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("TABLE_CAT"), (Matcher)CoreMatchers.equalTo((Object)"DRILL"));
    }

    @Test
    public void test_TABLE_CAT_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(1), (Matcher)CoreMatchers.equalTo((Object)"TABLE_CAT"));
    }

    @Test
    public void test_TABLE_CAT_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(1), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_TABLE_CAT_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(1), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_TABLE_CAT_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(1), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_TABLE_CAT_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(1), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_TABLE_SCHEM_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(2), (Matcher)CoreMatchers.equalTo((Object)"TABLE_SCHEM"));
    }

    @Test
    public void test_TABLE_SCHEM_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("TABLE_SCHEM"), (Matcher)CoreMatchers.equalTo((Object)VIEW_SCHEMA));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_TABLE_SCHEM_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)mdrReqARRAY.getString("TABLE_SCHEM"), (Matcher)CoreMatchers.equalTo((Object)"hive_test.default"));
    }

    @Test
    public void test_TABLE_SCHEM_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(2), (Matcher)CoreMatchers.equalTo((Object)"TABLE_SCHEM"));
    }

    @Test
    public void test_TABLE_SCHEM_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(2), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_TABLE_SCHEM_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(2), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_TABLE_SCHEM_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(2), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_TABLE_SCHEM_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(2), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_TABLE_NAME_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(3), (Matcher)CoreMatchers.equalTo((Object)"TABLE_NAME"));
    }

    @Test
    public void test_TABLE_NAME_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("TABLE_NAME"), (Matcher)CoreMatchers.equalTo((Object)VIEW_NAME));
    }

    @Test
    public void test_TABLE_NAME_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(3), (Matcher)CoreMatchers.equalTo((Object)"TABLE_NAME"));
    }

    @Test
    public void test_TABLE_NAME_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(3), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_TABLE_NAME_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(3), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_TABLE_NAME_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(3), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_TABLE_NAME_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(3), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_COLUMN_NAME_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(4), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_NAME"));
    }

    @Test
    public void test_COLUMN_NAME_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("COLUMN_NAME"), (Matcher)CoreMatchers.equalTo((Object)"mdrOptBOOLEAN"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_COLUMN_NAME_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)mdrReqARRAY.getString("COLUMN_NAME"), (Matcher)CoreMatchers.equalTo((Object)"listtype"));
    }

    @Test
    public void test_COLUMN_NAME_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(4), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_NAME"));
    }

    @Test
    public void test_COLUMN_NAME_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(4), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_COLUMN_NAME_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(4), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_COLUMN_NAME_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(4), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_COLUMN_NAME_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(4), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DATA_TYPE_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(5), (Matcher)CoreMatchers.equalTo((Object)"DATA_TYPE"));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)16));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqTINYINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)-6));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptSMALLINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqINTEGER() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptBIGINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)-5));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptREAL() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptFLOAT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqDOUBLE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptVARCHAR() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqCHAR_5() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)-3));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptBINARY_1048576CHECK() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_1048576, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)-3));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqDATE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)91));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqTIME() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)92));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)92));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)93));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)1111));
    }

    @Test
    public void test_DATA_TYPE_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)1111));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATA_TYPE_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)2003));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATA_TYPE_hasRightValue_tbdMAP() throws SQLException {
        Assert.assertThat((String)"java.sql.Types.* type code", (Object)this.getIntOrNull(mdrReqMAP, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)1111));
        Assert.assertThat((String)"java.sql.Types.* type code", (Object)this.getIntOrNull(mdrReqMAP, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)2000));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATA_TYPE_hasRightValue_tbdSTRUCT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)2002));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DATA_TYPE_hasRightValue_tbdUnion() throws SQLException {
        Assert.assertThat((String)"java.sql.Types.* type code", (Object)this.getIntOrNull(mdrUnkUnion, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)1111));
        Assert.assertThat((String)"java.sql.Types.* type code", (Object)this.getIntOrNull(mdrUnkUnion, "DATA_TYPE"), (Matcher)CoreMatchers.equalTo((Object)2000));
    }

    @Test
    public void test_DATA_TYPE_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(5), (Matcher)CoreMatchers.equalTo((Object)"DATA_TYPE"));
    }

    @Test
    public void test_DATA_TYPE_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(5), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_DATA_TYPE_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(5), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_DATA_TYPE_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(5), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_DATA_TYPE_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(5), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_TYPE_NAME_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(6), (Matcher)CoreMatchers.equalTo((Object)"TYPE_NAME"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"BOOLEAN"));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqTINYINT() throws SQLException {
        Assert.assertThat((Object)mdrReqTINYINT.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"TINYINT"));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptSMALLINT() throws SQLException {
        Assert.assertThat((Object)mdrOptSMALLINT.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"SMALLINT"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqINTEGER() throws SQLException {
        Assert.assertThat((Object)mdrReqINTEGER.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptBIGINT() throws SQLException {
        Assert.assertThat((Object)mdrOptBIGINT.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"BIGINT"));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptREAL() throws SQLException {
        Assert.assertThat((Object)mdrOptREAL.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"REAL"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptFLOAT() throws SQLException {
        Assert.assertThat((Object)mdrOptFLOAT.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"FLOAT"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqDOUBLE() throws SQLException {
        Assert.assertThat((Object)mdrReqDOUBLE.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"DOUBLE"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)mdrReqDECIMAL_5_3.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"DECIMAL"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        Assert.assertThat((Object)mdrReqVARCHAR_10.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptVARCHAR() throws SQLException {
        Assert.assertThat((Object)mdrOptVARCHAR.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqCHAR_5() throws SQLException {
        Assert.assertThat((Object)mdrReqCHAR_5.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        Assert.assertThat((Object)mdrOptVARBINARY_16.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"BINARY VARYING"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptBINARY_1048576CHECK() throws SQLException {
        Assert.assertThat((Object)mdrOptBINARY_1048576.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"BINARY VARYING"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqDATE() throws SQLException {
        Assert.assertThat((Object)mdrReqDATE.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"DATE"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqTIME() throws SQLException {
        Assert.assertThat((Object)mdrReqTIME.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"TIME"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((Object)mdrOptTIME_7.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"TIME"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        Assert.assertThat((Object)mdrOptTIMESTAMP.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"TIMESTAMP"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        Assert.assertThat((Object)mdrReqINTERVAL_Y.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL"));
    }

    @Test
    public void test_TYPE_NAME_hasRightValue_mdrReqINTERVAL_H_S3() throws SQLException {
        Assert.assertThat((Object)mdrReqINTERVAL_3H_S1.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"INTERVAL"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_TYPE_NAME_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)mdrReqARRAY.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"ARRAY"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_TYPE_NAME_hasRightValue_tbdMAP() throws SQLException {
        Assert.assertThat((Object)mdrReqMAP.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"MAP"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_TYPE_NAME_hasRightValue_tbdSTRUCT() throws SQLException {
        Assert.assertThat((Object)mdrUnkSTRUCT.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"STRUCT"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_TYPE_NAME_hasRightValue_tbdUnion() throws SQLException {
        Assert.assertThat((Object)mdrUnkUnion.getString("TYPE_NAME"), (Matcher)CoreMatchers.equalTo((Object)"OTHER"));
        Assert.fail((String)"Expected value is not resolved yet.");
    }

    @Test
    public void test_TYPE_NAME_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(6), (Matcher)CoreMatchers.equalTo((Object)"TYPE_NAME"));
    }

    @Test
    public void test_TYPE_NAME_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(6), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_TYPE_NAME_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(6), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_TYPE_NAME_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(6), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_TYPE_NAME_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(6), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_COLUMN_SIZE_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(7), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_SIZE"));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqTINYINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptSMALLINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)16));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTEGER() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)32));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptBIGINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)64));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptREAL() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)24));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptFLOAT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)24));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqDOUBLE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)53));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptVARCHAR() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)65536));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqCHAR_5() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)16));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_1048576, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)0x100000));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqDATE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqTIME() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Ignore(value="TODO(DRILL-3225): unignore when datetime precision is implemented")
    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)16));
    }

    @Test
    public void test_COLUMN_SIZE_hasINTERIMValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((String)"When datetime precision is implemented, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrOptTIME_7, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)19));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_3Y_Mo() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3Y_Mo, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_Mo() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Mo, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_D() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_D, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_4D_H() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_4D_H, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_3D_Mi() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3D_Mi, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Ignore(value="TODO(DRILL-3244): unignore when fractional secs. prec. is right")
    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_2D_S5() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_2D_S5, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)20));
    }

    public void test_COLUMN_SIZE_hasINTERIMValue_mdrReqINTERVAL_2D_S5() throws SQLException {
        Assert.assertThat((String)"When DRILL-3244 fixed, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_2D_S5, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)17));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_3H() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_H, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_4H_Mi() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_1H_Mi, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Ignore(value="TODO(DRILL-3244): unignore when fractional secs. prec. is right")
    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)14));
    }

    @Test
    public void test_COLUMN_SIZE_hasINTERIMValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        Assert.assertThat((String)"When DRILL-3244 fixed, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)16));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_Mi() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Mi, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_5Mi_S() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_5Mi_S, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)18));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_S() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_S, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_3S() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3S, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)13));
    }

    @Ignore(value="TODO(DRILL-3244): unignore when fractional secs. prec. is right")
    @Test
    public void test_COLUMN_SIZE_hasRightValue_mdrReqINTERVAL_3S1() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3S1, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Test
    public void test_COLUMN_SIZE_hasINTERIMValue_mdrReqINTERVAL_3S1() throws SQLException {
        Assert.assertThat((String)"When DRILL-3244 fixed, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_3S1, "COLUMN_SIZE"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_COLUMN_SIZE_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "COLUMN_SIZE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_COLUMN_SIZE_hasRightValue_tbdMAP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "COLUMN_SIZE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_COLUMN_SIZE_hasRightValue_tbdSTRUCT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "COLUMN_SIZE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_COLUMN_SIZE_hasRightValue_tbdUnion() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "COLUMN_SIZE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_COLUMN_SIZE_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(7), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_SIZE"));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(7), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(7), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(7), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_COLUMN_SIZE_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(7), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_BUFFER_LENGTH_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(8), (Matcher)CoreMatchers.equalTo((Object)"BUFFER_LENGTH"));
    }

    @Test
    public void test_BUFFER_LENGTH_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(8), (Matcher)CoreMatchers.equalTo((Object)"BUFFER_LENGTH"));
    }

    @Test
    public void test_DECIMAL_DIGITS_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(9), (Matcher)CoreMatchers.equalTo((Object)"DECIMAL_DIGITS"));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqTINYINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptSMALLINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTEGER() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptBIGINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptREAL() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptFLOAT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqDOUBLE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)15));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptVARCHAR() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqCHAR_5() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptBINARY_1048576CHECK() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_1048576, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqDATE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqTIME() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-3225): unignore when datetime precision is implemented")
    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasINTERIMValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((String)"When datetime precision is implemented, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrOptTIME_7, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-3225): unignore when datetime precision is implemented")
    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        Assert.assertThat((String)"When datetime precision is implemented, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_Y, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_3Y_Mo() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3Y_Mo, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_Mo() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Mo, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_D() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_D, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_4D_H() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_4D_H, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_3D_Mi() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3D_Mi, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Ignore(value="TODO(DRILL-3244): unignore when fractional secs. prec. is right")
    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_2D_S5() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_2D_S5, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasINTERIMValue_mdrReqINTERVAL_2D_S5() throws SQLException {
        Assert.assertThat((String)"When DRILL-3244 fixed, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_2D_S5, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_3H() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_H, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_1H_Mi() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_1H_Mi, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Ignore(value="TODO(DRILL-3244): unignore when fractional secs. prec. is right")
    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasINTERIMValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        Assert.assertThat((String)"When DRILL-3244 fixed, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_Mi() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Mi, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_5Mi_S() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_5Mi_S, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_S() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_S, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_3S() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3S, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasINTERIMValue_mdrReqINTERVAL_3S() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3S, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Ignore(value="TODO(DRILL-3244): unignore when fractional secs. prec. is right")
    @Test
    public void test_DECIMAL_DIGITS_hasRightValue_mdrReqINTERVAL_3S1() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3S, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasINTERIMValue_mdrReqINTERVAL_3S1() throws SQLException {
        Assert.assertThat((String)"When DRILL-3244 fixed, un-ignore above method and purge this.", (Object)this.getIntOrNull(mdrReqINTERVAL_3S, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DECIMAL_DIGITS_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DECIMAL_DIGITS_hasRightValue_tbdMAP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DECIMAL_DIGITS_hasRightValue_tbdSTRUCT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_DECIMAL_DIGITS_hasRightValue_tbdUnion() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "DECIMAL_DIGITS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_DECIMAL_DIGITS_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(9), (Matcher)CoreMatchers.equalTo((Object)"DECIMAL_DIGITS"));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(9), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(9), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(9), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_DECIMAL_DIGITS_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(9), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NUM_PREC_RADIX_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(10), (Matcher)CoreMatchers.equalTo((Object)"NUM_PREC_RADIX"));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqTINYINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptSMALLINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqINTEGER() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptBIGINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptREAL() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptFLOAT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqDOUBLE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptVARCHAR() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqCHAR_5() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptBINARY_1048576CHECK() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_1048576, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqDATE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqTIME() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.equalTo((Object)10));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUM_PREC_RADIX_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUM_PREC_RADIX_hasRightValue_tbdMAP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUM_PREC_RADIX_hasRightValue_tbdSTRUCT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NUM_PREC_RADIX_hasRightValue_tbdUnion() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "NUM_PREC_RADIX"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_NUM_PREC_RADIX_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(10), (Matcher)CoreMatchers.equalTo((Object)"NUM_PREC_RADIX"));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(10), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(10), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(10), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_NUM_PREC_RADIX_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(10), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NULLABLE_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(11), (Matcher)CoreMatchers.equalTo((Object)"NULLABLE"));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_NULLABLE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptBOOLEAN, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_NULLABLE_hasRightValue_mdrReqTINYINT() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqTINYINT, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_NULLABLE_hasRightValue_mdrOptSMALLINT() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptSMALLINT, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrOptBIGINT() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptBIGINT, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_NULLABLE_hasRightValue_mdrOptREAL() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptREAL, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrOptFLOAT() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptFLOAT, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrReqDOUBLE() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqDOUBLE, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrReqINTEGER() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqINTEGER, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqVARCHAR_10, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrOptVARCHAR() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptVARCHAR, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrReqCHAR_5() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqCHAR_5, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptVARBINARY_16, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrOptBINARY_1048576() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptBINARY_1048576, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrReqDATE() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqDATE, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrReqTIME() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqTIME, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptTIME_7, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrOptTIMESTAMP, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqINTERVAL_Y, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_NULLABLE_hasRightValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NULLABLE_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NULLABLE_hasRightValue_tbdMAP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NULLABLE_hasRightValue_tbdSTRUCT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_NULLABLE_hasRightValue_tbdUnion() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrUnkUnion, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrUnkUnion, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)this.getIntOrNull(mdrUnkUnion, "NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void test_NULLABLE_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(11), (Matcher)CoreMatchers.equalTo((Object)"NULLABLE"));
    }

    @Test
    public void test_NULLABLE_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(11), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_NULLABLE_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(11), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_NULLABLE_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(11), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_NULLABLE_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(11), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_REMARKS_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(12), (Matcher)CoreMatchers.equalTo((Object)"REMARKS"));
    }

    @Test
    public void test_REMARKS_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("REMARKS"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_REMARKS_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(12), (Matcher)CoreMatchers.equalTo((Object)"REMARKS"));
    }

    @Test
    public void test_REMARKS_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(12), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_REMARKS_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(12), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_REMARKS_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(12), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Test
    public void test_REMARKS_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(12), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_COLUMN_DEF_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(13), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_DEF"));
    }

    @Test
    public void test_COLUMN_DEF_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("COLUMN_DEF"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_COLUMN_DEF_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(13), (Matcher)CoreMatchers.equalTo((Object)"COLUMN_DEF"));
    }

    @Test
    public void test_COLUMN_DEF_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(13), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_COLUMN_DEF_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(13), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_COLUMN_DEF_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(13), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Test
    public void test_COLUMN_DEF_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(13), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_SQL_DATA_TYPE_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(14), (Matcher)CoreMatchers.equalTo((Object)"SQL_DATA_TYPE"));
    }

    @Test
    public void test_SQL_DATA_TYPE_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(14), (Matcher)CoreMatchers.equalTo((Object)"SQL_DATA_TYPE"));
    }

    @Test
    public void test_SQL_DATA_TYPE_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(14), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_SQL_DATA_TYPE_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(14), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_SQL_DATA_TYPE_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(14), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_SQL_DATETIME_SUB_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(15), (Matcher)CoreMatchers.equalTo((Object)"SQL_DATETIME_SUB"));
    }

    @Test
    public void test_SQL_DATETIME_SUB_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(15), (Matcher)CoreMatchers.equalTo((Object)"SQL_DATETIME_SUB"));
    }

    @Test
    public void test_SQL_DATETIME_SUB_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(15), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_SQL_DATETIME_SUB_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(15), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_SQL_DATETIME_SUB_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(15), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(16), (Matcher)CoreMatchers.equalTo((Object)"CHAR_OCTET_LENGTH"));
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqTINYINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrOptSMALLINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqINTEGER() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrOptBIGINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrOptFLOAT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqDOUBLE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDECIMAL_5_3, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqVARCHAR_10, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)40));
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrOptVARCHAR() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARCHAR, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)262144));
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqCHAR_5() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqCHAR_5, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.equalTo((Object)20));
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptVARBINARY_16, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrOptBINARY_1048576CHECK() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBINARY_1048576, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqDATE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDATE, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqTIME() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTIME, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIME_7, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptTIMESTAMP, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_Y, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTERVAL_3H_S1, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHAR_OCTET_LENGTH_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHAR_OCTET_LENGTH_hasRightValue_tbdMAP() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqMAP, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHAR_OCTET_LENGTH_hasRightValue_tbdSTRUCT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkSTRUCT, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_CHAR_OCTET_LENGTH_hasRightValue_tbdUnion() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrUnkUnion, "CHAR_OCTET_LENGTH"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(16), (Matcher)CoreMatchers.equalTo((Object)"CHAR_OCTET_LENGTH"));
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(16), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(16), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(16), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_CHAR_OCTET_LENGTH_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(16), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_ORDINAL_POSITION_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(17), (Matcher)CoreMatchers.equalTo((Object)"ORDINAL_POSITION"));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBOOLEAN, "ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrReqTINYINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqTINYINT, "ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptSMALLINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptSMALLINT, "ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrReqINTEGER() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqINTEGER, "ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptBIGINT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptBIGINT, "ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptREAL() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptREAL, "ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)6));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrOptFLOAT() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrOptFLOAT, "ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)7));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightValue_mdrReqDOUBLE() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqDOUBLE, "ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)8));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_ORDINAL_POSITION_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)this.getIntOrNull(mdrReqARRAY, "ORDINAL_POSITION"), (Matcher)CoreMatchers.equalTo((Object)14));
    }

    @Test
    public void test_ORDINAL_POSITION_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(17), (Matcher)CoreMatchers.equalTo((Object)"ORDINAL_POSITION"));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(17), (Matcher)CoreMatchers.equalTo((Object)"INTEGER"));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(17), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(17), (Matcher)CoreMatchers.equalTo((Object)Integer.class.getName()));
    }

    @Test
    public void test_ORDINAL_POSITION_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(17), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_IS_NULLABLE_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(18), (Matcher)CoreMatchers.equalTo((Object)"IS_NULLABLE"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when TINYINT is implemented")
    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqTINYINT() throws SQLException {
        Assert.assertThat((Object)mdrReqTINYINT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Ignore(value="TODO(DRILL-2470): unignore when SMALLINT is implemented")
    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptSMALLINT() throws SQLException {
        Assert.assertThat((Object)mdrOptSMALLINT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqINTEGER() throws SQLException {
        Assert.assertThat((Object)mdrReqINTEGER.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptBIGINT() throws SQLException {
        Assert.assertThat((Object)mdrOptBIGINT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Ignore(value="TODO(DRILL-2683): unignore when REAL is implemented")
    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptREAL() throws SQLException {
        Assert.assertThat((Object)mdrOptREAL.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptFLOAT() throws SQLException {
        Assert.assertThat((Object)mdrOptFLOAT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqDOUBLE() throws SQLException {
        Assert.assertThat((Object)mdrReqDOUBLE.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqDECIMAL_5_3() throws SQLException {
        Assert.assertThat((Object)mdrReqDECIMAL_5_3.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqVARCHAR_10() throws SQLException {
        Assert.assertThat((Object)mdrReqVARCHAR_10.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptVARCHAR() throws SQLException {
        Assert.assertThat((Object)mdrOptVARCHAR.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqCHAR_5() throws SQLException {
        Assert.assertThat((Object)mdrReqCHAR_5.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptVARBINARY_16() throws SQLException {
        Assert.assertThat((Object)mdrOptVARBINARY_16.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptBINARY_1048576CHECK() throws SQLException {
        Assert.assertThat((Object)mdrOptBINARY_1048576.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqDATE() throws SQLException {
        Assert.assertThat((Object)mdrReqDATE.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqTIME() throws SQLException {
        Assert.assertThat((Object)mdrReqTIME.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptTIME_7() throws SQLException {
        Assert.assertThat((Object)mdrOptTIME_7.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrOptTIMESTAMP() throws SQLException {
        Assert.assertThat((Object)mdrOptTIMESTAMP.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqINTERVAL_Y() throws SQLException {
        Assert.assertThat((Object)mdrReqINTERVAL_Y.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightValue_mdrReqINTERVAL_3H_S1() throws SQLException {
        Assert.assertThat((Object)mdrReqINTERVAL_3H_S1.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_IS_NULLABLE_hasRightValue_tdbARRAY() throws SQLException {
        Assert.assertThat((Object)mdrReqARRAY.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
        Assert.assertThat((Object)mdrReqARRAY.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
        Assert.assertThat((Object)mdrReqARRAY.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_IS_NULLABLE_hasRightValue_tbdMAP() throws SQLException {
        Assert.assertThat((Object)mdrReqMAP.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
        Assert.assertThat((Object)mdrReqMAP.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
        Assert.assertThat((Object)mdrReqMAP.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_IS_NULLABLE_hasRightValue_tbdSTRUCT() throws SQLException {
        Assert.assertThat((Object)mdrUnkSTRUCT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
        Assert.assertThat((Object)mdrUnkSTRUCT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
        Assert.assertThat((Object)mdrUnkSTRUCT.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    @Ignore(value="TODO(DRILL-3253): unignore when we have all-types test storage plugin")
    public void test_IS_NULLABLE_hasRightValue_tbdUnion() throws SQLException {
        Assert.assertThat((Object)mdrUnkUnion.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"YES"));
        Assert.assertThat((Object)mdrUnkUnion.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)"NO"));
        Assert.assertThat((Object)mdrUnkUnion.getString("IS_NULLABLE"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void test_IS_NULLABLE_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(18), (Matcher)CoreMatchers.equalTo((Object)"IS_NULLABLE"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(18), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_IS_NULLABLE_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(18), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_IS_NULLABLE_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(18), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Ignore(value="until resolved:  any requirement on nullability (DRILL-2420?)")
    @Test
    public void test_IS_NULLABLE_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(18), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_SCOPE_CATALOG_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(19), (Matcher)CoreMatchers.equalTo((Object)"SCOPE_CATALOG"));
    }

    @Test
    public void test_SCOPE_CATALOG_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        String value = mdrOptBOOLEAN.getString("SCOPE_SCHEMA");
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_SCOPE_CATALOG_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(19), (Matcher)CoreMatchers.equalTo((Object)"SCOPE_CATALOG"));
    }

    @Test
    public void test_SCOPE_CATALOG_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(19), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_SCOPE_CATALOG_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(19), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_SCOPE_CATALOG_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(19), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Test
    public void test_SCOPE_CATALOG_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(19), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_SCOPE_SCHEMA_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(20), (Matcher)CoreMatchers.equalTo((Object)"SCOPE_SCHEMA"));
    }

    @Test
    public void test_SCOPE_SCHEMA_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        String value = mdrOptBOOLEAN.getString("SCOPE_SCHEMA");
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_SCOPE_SCHEMA_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(20), (Matcher)CoreMatchers.equalTo((Object)"SCOPE_SCHEMA"));
    }

    @Test
    public void test_SCOPE_SCHEMA_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(20), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_SCOPE_SCHEMA_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(20), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_SCOPE_SCHEMA_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(20), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Test
    public void test_SCOPE_SCHEMA_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(20), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_SCOPE_TABLE_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(21), (Matcher)CoreMatchers.equalTo((Object)"SCOPE_TABLE"));
    }

    @Test
    public void test_SCOPE_TABLE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        String value = mdrOptBOOLEAN.getString("SCOPE_TABLE");
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_SCOPE_TABLE_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(21), (Matcher)CoreMatchers.equalTo((Object)"SCOPE_TABLE"));
    }

    @Test
    public void test_SCOPE_TABLE_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(21), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_SCOPE_TABLE_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(21), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_SCOPE_TABLE_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(21), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Test
    public void test_SCOPE_TABLE_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(21), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_SOURCE_DATA_TYPE_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(22), (Matcher)CoreMatchers.equalTo((Object)"SOURCE_DATA_TYPE"));
    }

    @Test
    public void test_SOURCE_DATA_TYPE_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("SOURCE_DATA_TYPE"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_SOURCE_DATA_TYPE_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(22), (Matcher)CoreMatchers.equalTo((Object)"SOURCE_DATA_TYPE"));
    }

    @Test
    public void test_SOURCE_DATA_TYPE_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(22), (Matcher)CoreMatchers.equalTo((Object)"SMALLINT"));
    }

    @Test
    public void test_SOURCE_DATA_TYPE_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(22), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void test_SOURCE_DATA_TYPE_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(22), (Matcher)CoreMatchers.equalTo((Object)Short.class.getName()));
    }

    @Test
    public void test_SOURCE_DATA_TYPE_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(22), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void test_IS_AUTOINCREMENT_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(23), (Matcher)CoreMatchers.equalTo((Object)"IS_AUTOINCREMENT"));
    }

    @Test
    public void test_IS_AUTOINCREMENT_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("IS_AUTOINCREMENT"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void test_IS_AUTOINCREMENT_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(23), (Matcher)CoreMatchers.equalTo((Object)"IS_AUTOINCREMENT"));
    }

    @Test
    public void test_IS_AUTOINCREMENT_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(23), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_IS_AUTOINCREMENT_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(23), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_IS_AUTOINCREMENT_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(23), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Test
    public void test_IS_AUTOINCREMENT_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(23), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void test_IS_GENERATEDCOLUMN_isAtRightPosition() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnLabel(24), (Matcher)CoreMatchers.equalTo((Object)"IS_GENERATEDCOLUMN"));
    }

    @Test
    public void test_IS_GENERATEDCOLUMN_hasRightValue_mdrOptBOOLEAN() throws SQLException {
        Assert.assertThat((Object)mdrOptBOOLEAN.getString("IS_GENERATEDCOLUMN"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void test_IS_GENERATEDCOLUMN_hasSameNameAndLabel() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnName(24), (Matcher)CoreMatchers.equalTo((Object)"IS_GENERATEDCOLUMN"));
    }

    @Test
    public void test_IS_GENERATEDCOLUMN_hasRightTypeString() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnTypeName(24), (Matcher)CoreMatchers.equalTo((Object)"CHARACTER VARYING"));
    }

    @Test
    public void test_IS_GENERATEDCOLUMN_hasRightTypeCode() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnType(24), (Matcher)CoreMatchers.equalTo((Object)12));
    }

    @Test
    public void test_IS_GENERATEDCOLUMN_hasRightClass() throws SQLException {
        Assert.assertThat((Object)rowsMetadata.getColumnClassName(24), (Matcher)CoreMatchers.equalTo((Object)String.class.getName()));
    }

    @Test
    public void test_IS_GENERATEDCOLUMN_hasRightNullability() throws SQLException {
        Assert.assertThat((String)"ResultSetMetaData.column...Null... nullability code:", (Object)rowsMetadata.isNullable(24), (Matcher)CoreMatchers.equalTo((Object)0));
    }
}

