/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.holders.NullableBigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBitHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDateHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableTinyIntHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt4Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableUInt8Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class ComplexCopier {
    public static void copy(FieldReader input, FieldWriter output) {
        ComplexCopier.writeValue(input, output);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void writeValue(FieldReader reader, FieldWriter writer) {
        TypeProtos.DataMode m4 = reader.getType().getMode();
        TypeProtos.MinorType mt = reader.getType().getMinorType();
        switch (m4) {
            case OPTIONAL: 
            case REQUIRED: {
                switch (mt) {
                    case LIST: {
                        writer.startList();
                        while (reader.next()) {
                            ComplexCopier.writeValue(reader.reader(), ComplexCopier.getListWriterForReader(reader.reader(), writer));
                        }
                        writer.endList();
                        break;
                    }
                    case MAP: {
                        writer.start();
                        if (reader.isSet()) {
                            for (String name : reader) {
                                FieldReader childReader = reader.reader(name);
                                if (!childReader.isSet()) continue;
                                ComplexCopier.writeValue(childReader, ComplexCopier.getMapWriterForReader(childReader, writer, name));
                            }
                        }
                        writer.end();
                        break;
                    }
                    case DICT: {
                        FieldWriter wr = writer;
                        wr.start();
                        if (reader.isSet()) {
                            while (reader.next()) {
                                wr.startKeyValuePair();
                                FieldReader keyReader = reader.reader("key");
                                FieldReader valueReader = reader.reader("value");
                                ComplexCopier.writeValue(keyReader, ComplexCopier.getMapWriterForReader(keyReader, writer, "key"));
                                ComplexCopier.writeValue(valueReader, ComplexCopier.getMapWriterForReader(valueReader, writer, "value"));
                                wr.endKeyValuePair();
                            }
                        }
                        wr.end();
                        break;
                    }
                    case TINYINT: {
                        if (!reader.isSet()) return;
                        NullableTinyIntHolder tinyIntHolder = new NullableTinyIntHolder();
                        reader.read(tinyIntHolder);
                        if (tinyIntHolder.isSet != 1) return;
                        writer.writeTinyInt(tinyIntHolder.value);
                        break;
                    }
                    case UINT1: {
                        if (!reader.isSet()) return;
                        NullableUInt1Holder uInt1Holder = new NullableUInt1Holder();
                        reader.read(uInt1Holder);
                        if (uInt1Holder.isSet != 1) return;
                        writer.writeUInt1(uInt1Holder.value);
                        break;
                    }
                    case UINT2: {
                        if (!reader.isSet()) return;
                        NullableUInt2Holder uInt2Holder = new NullableUInt2Holder();
                        reader.read(uInt2Holder);
                        if (uInt2Holder.isSet != 1) return;
                        writer.writeUInt2(uInt2Holder.value);
                        break;
                    }
                    case SMALLINT: {
                        if (!reader.isSet()) return;
                        NullableSmallIntHolder smallIntHolder = new NullableSmallIntHolder();
                        reader.read(smallIntHolder);
                        if (smallIntHolder.isSet != 1) return;
                        writer.writeSmallInt(smallIntHolder.value);
                        break;
                    }
                    case INT: {
                        if (!reader.isSet()) return;
                        NullableIntHolder intHolder = new NullableIntHolder();
                        reader.read(intHolder);
                        if (intHolder.isSet != 1) return;
                        writer.writeInt(intHolder.value);
                        break;
                    }
                    case UINT4: {
                        if (!reader.isSet()) return;
                        NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
                        reader.read(uInt4Holder);
                        if (uInt4Holder.isSet != 1) return;
                        writer.writeUInt4(uInt4Holder.value);
                        break;
                    }
                    case FLOAT4: {
                        if (!reader.isSet()) return;
                        NullableFloat4Holder float4Holder = new NullableFloat4Holder();
                        reader.read(float4Holder);
                        if (float4Holder.isSet != 1) return;
                        writer.writeFloat4(float4Holder.value);
                        break;
                    }
                    case TIME: {
                        if (!reader.isSet()) return;
                        NullableTimeHolder timeHolder = new NullableTimeHolder();
                        reader.read(timeHolder);
                        if (timeHolder.isSet != 1) return;
                        writer.writeTime(timeHolder.value);
                        break;
                    }
                    case INTERVALYEAR: {
                        if (!reader.isSet()) return;
                        NullableIntervalYearHolder intervalYearHolder = new NullableIntervalYearHolder();
                        reader.read(intervalYearHolder);
                        if (intervalYearHolder.isSet != 1) return;
                        writer.writeIntervalYear(intervalYearHolder.value);
                        break;
                    }
                    case BIGINT: {
                        if (!reader.isSet()) return;
                        NullableBigIntHolder bigIntHolder = new NullableBigIntHolder();
                        reader.read(bigIntHolder);
                        if (bigIntHolder.isSet != 1) return;
                        writer.writeBigInt(bigIntHolder.value);
                        break;
                    }
                    case UINT8: {
                        if (!reader.isSet()) return;
                        NullableUInt8Holder uInt8Holder = new NullableUInt8Holder();
                        reader.read(uInt8Holder);
                        if (uInt8Holder.isSet != 1) return;
                        writer.writeUInt8(uInt8Holder.value);
                        break;
                    }
                    case FLOAT8: {
                        if (!reader.isSet()) return;
                        NullableFloat8Holder float8Holder = new NullableFloat8Holder();
                        reader.read(float8Holder);
                        if (float8Holder.isSet != 1) return;
                        writer.writeFloat8(float8Holder.value);
                        break;
                    }
                    case DATE: {
                        if (!reader.isSet()) return;
                        NullableDateHolder dateHolder = new NullableDateHolder();
                        reader.read(dateHolder);
                        if (dateHolder.isSet != 1) return;
                        writer.writeDate(dateHolder.value);
                        break;
                    }
                    case TIMESTAMP: {
                        if (!reader.isSet()) return;
                        NullableTimeStampHolder timeStampHolder = new NullableTimeStampHolder();
                        reader.read(timeStampHolder);
                        if (timeStampHolder.isSet != 1) return;
                        writer.writeTimeStamp(timeStampHolder.value);
                        break;
                    }
                    case INTERVALDAY: {
                        if (!reader.isSet()) return;
                        NullableIntervalDayHolder intervalDayHolder = new NullableIntervalDayHolder();
                        reader.read(intervalDayHolder);
                        if (intervalDayHolder.isSet != 1) return;
                        writer.writeIntervalDay(intervalDayHolder.days, intervalDayHolder.milliseconds);
                        break;
                    }
                    case INTERVAL: {
                        if (!reader.isSet()) return;
                        NullableIntervalHolder intervalHolder = new NullableIntervalHolder();
                        reader.read(intervalHolder);
                        if (intervalHolder.isSet != 1) return;
                        writer.writeInterval(intervalHolder.months, intervalHolder.days, intervalHolder.milliseconds);
                        break;
                    }
                    case VARBINARY: {
                        if (!reader.isSet()) return;
                        NullableVarBinaryHolder varBinaryHolder = new NullableVarBinaryHolder();
                        reader.read(varBinaryHolder);
                        if (varBinaryHolder.isSet != 1) return;
                        writer.writeVarBinary(varBinaryHolder.start, varBinaryHolder.end, varBinaryHolder.buffer);
                        break;
                    }
                    case VARCHAR: {
                        if (!reader.isSet()) return;
                        NullableVarCharHolder varCharHolder = new NullableVarCharHolder();
                        reader.read(varCharHolder);
                        if (varCharHolder.isSet != 1) return;
                        writer.writeVarChar(varCharHolder.start, varCharHolder.end, varCharHolder.buffer);
                        break;
                    }
                    case VAR16CHAR: {
                        if (!reader.isSet()) return;
                        NullableVar16CharHolder var16CharHolder = new NullableVar16CharHolder();
                        reader.read(var16CharHolder);
                        if (var16CharHolder.isSet != 1) return;
                        writer.writeVar16Char(var16CharHolder.start, var16CharHolder.end, var16CharHolder.buffer);
                        break;
                    }
                    case VARDECIMAL: {
                        if (!reader.isSet()) return;
                        NullableVarDecimalHolder varDecimalHolder = new NullableVarDecimalHolder();
                        reader.read(varDecimalHolder);
                        if (varDecimalHolder.isSet != 1) return;
                        writer.writeVarDecimal(varDecimalHolder.start, varDecimalHolder.end, varDecimalHolder.buffer, varDecimalHolder.precision, varDecimalHolder.scale);
                        break;
                    }
                    case BIT: {
                        if (!reader.isSet()) return;
                        NullableBitHolder bitHolder = new NullableBitHolder();
                        reader.read(bitHolder);
                        if (bitHolder.isSet != 1) return;
                        writer.writeBit(bitHolder.value);
                    }
                }
                return;
            }
        }
    }

    public static FieldWriter getMapWriterForType(TypeProtos.MajorType type, BaseWriter.MapWriter writer, String name) {
        switch (type.getMinorType()) {
            case TINYINT: {
                return (FieldWriter)writer.tinyInt(name);
            }
            case UINT1: {
                return (FieldWriter)writer.uInt1(name);
            }
            case UINT2: {
                return (FieldWriter)writer.uInt2(name);
            }
            case SMALLINT: {
                return (FieldWriter)writer.smallInt(name);
            }
            case INT: {
                return (FieldWriter)writer.integer(name);
            }
            case UINT4: {
                return (FieldWriter)writer.uInt4(name);
            }
            case FLOAT4: {
                return (FieldWriter)writer.float4(name);
            }
            case TIME: {
                return (FieldWriter)writer.time(name);
            }
            case INTERVALYEAR: {
                return (FieldWriter)writer.intervalYear(name);
            }
            case BIGINT: {
                return (FieldWriter)writer.bigInt(name);
            }
            case UINT8: {
                return (FieldWriter)writer.uInt8(name);
            }
            case FLOAT8: {
                return (FieldWriter)writer.float8(name);
            }
            case DATE: {
                return (FieldWriter)writer.date(name);
            }
            case TIMESTAMP: {
                return (FieldWriter)writer.timeStamp(name);
            }
            case INTERVALDAY: {
                return (FieldWriter)writer.intervalDay(name);
            }
            case INTERVAL: {
                return (FieldWriter)writer.interval(name);
            }
            case VARBINARY: {
                return (FieldWriter)writer.varBinary(name);
            }
            case VARCHAR: {
                return (FieldWriter)writer.varChar(name);
            }
            case VAR16CHAR: {
                return (FieldWriter)writer.var16Char(name);
            }
            case VARDECIMAL: {
                return (FieldWriter)writer.varDecimal(name, type.getPrecision(), type.getScale());
            }
            case BIT: {
                return (FieldWriter)writer.bit(name);
            }
            case MAP: {
                return (FieldWriter)writer.map(name);
            }
            case DICT: {
                return (FieldWriter)writer.dict(name);
            }
            case LIST: {
                return (FieldWriter)writer.list(name);
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] type is not supported.", type.toString()));
    }

    public static FieldWriter getListWriterForType(TypeProtos.MajorType type, BaseWriter.ListWriter writer) {
        switch (type.getMinorType()) {
            case TINYINT: {
                return (FieldWriter)writer.tinyInt();
            }
            case UINT1: {
                return (FieldWriter)writer.uInt1();
            }
            case UINT2: {
                return (FieldWriter)writer.uInt2();
            }
            case SMALLINT: {
                return (FieldWriter)writer.smallInt();
            }
            case INT: {
                return (FieldWriter)writer.integer();
            }
            case UINT4: {
                return (FieldWriter)writer.uInt4();
            }
            case FLOAT4: {
                return (FieldWriter)writer.float4();
            }
            case TIME: {
                return (FieldWriter)writer.time();
            }
            case INTERVALYEAR: {
                return (FieldWriter)writer.intervalYear();
            }
            case BIGINT: {
                return (FieldWriter)writer.bigInt();
            }
            case UINT8: {
                return (FieldWriter)writer.uInt8();
            }
            case FLOAT8: {
                return (FieldWriter)writer.float8();
            }
            case DATE: {
                return (FieldWriter)writer.date();
            }
            case TIMESTAMP: {
                return (FieldWriter)writer.timeStamp();
            }
            case INTERVALDAY: {
                return (FieldWriter)writer.intervalDay();
            }
            case INTERVAL: {
                return (FieldWriter)writer.interval();
            }
            case VARBINARY: {
                return (FieldWriter)writer.varBinary();
            }
            case VARCHAR: {
                return (FieldWriter)writer.varChar();
            }
            case VAR16CHAR: {
                return (FieldWriter)writer.var16Char();
            }
            case VARDECIMAL: {
                return (FieldWriter)writer.varDecimal(type.getPrecision(), type.getScale());
            }
            case BIT: {
                return (FieldWriter)writer.bit();
            }
            case MAP: {
                return (FieldWriter)writer.map();
            }
            case LIST: {
                return (FieldWriter)writer.list();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] type is not supported.", type.toString()));
    }

    private static FieldWriter getMapWriterForReader(FieldReader reader, BaseWriter.MapWriter writer, String name) {
        return ComplexCopier.getMapWriterForType(reader.getType(), writer, name);
    }

    private static FieldWriter getListWriterForReader(FieldReader reader, BaseWriter.ListWriter writer) {
        return ComplexCopier.getListWriterForType(reader.getType(), writer);
    }
}

