/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.server;

import oadd.io.netty.util.internal.OutOfDirectMemoryError;
import oadd.org.apache.drill.common.CatastrophicFailure;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;

public final class FailureUtils {
    private static volatile boolean unrecoverableFailure;
    public static final int EXIT_CODE_HEAP_OOM = -1;
    public static final int EXIT_CODE_JAVA_ERROR = -2;
    public static final String DIRECT_MEMORY_OOM_MESSAGE = "Direct buffer memory";

    private FailureUtils() {
    }

    public static boolean isDirectMemoryOOM(Throwable e) {
        if (e instanceof OutOfDirectMemoryError || e instanceof OutOfMemoryException) {
            return true;
        }
        return e instanceof OutOfMemoryError && DIRECT_MEMORY_OOM_MESSAGE.equals(e.getMessage());
    }

    public static boolean isHeapOOM(Throwable e) {
        return e instanceof OutOfMemoryError && !DIRECT_MEMORY_OOM_MESSAGE.equals(e.getMessage());
    }

    public static void unrecoverableFailure(Throwable e, String message, int exitCode) {
        unrecoverableFailure = true;
        CatastrophicFailure.exit(e, message, exitCode);
    }

    public static boolean hadUnrecoverableFailure() {
        return unrecoverableFailure;
    }
}

