/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.security;

import java.io.InputStream;
import java.util.Properties;
import oadd.com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;

public class SecurityConfiguration
extends Configuration {
    public SecurityConfiguration() {
        this.updateGroupMapping();
    }

    private void updateGroupMapping() {
        String originalClassName = this.get("hadoop.security.group.mapping");
        String profilePrefix = System.getProperty("drill.security.namespacePrefix");
        if (originalClassName != null && !Strings.isNullOrEmpty(profilePrefix) && !originalClassName.startsWith(profilePrefix)) {
            this.set("hadoop.security.group.mapping", profilePrefix + originalClassName);
        }
    }

    static {
        Properties prop = new Properties();
        try {
            InputStream inputStream = SecurityConfiguration.class.getClassLoader().getResourceAsStream("profile.props");
            prop.load(inputStream);
            System.setProperty("drill.security.namespacePrefix", prop.getProperty("package.namespace.prefix").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

