/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.coord.zk;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import oadd.com.google.common.base.Function;
import oadd.com.google.common.base.Preconditions;
import oadd.com.google.common.base.Strings;
import oadd.com.google.common.collect.Iterables;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import oadd.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import oadd.org.apache.curator.framework.api.WatchPathable;
import oadd.org.apache.curator.framework.recipes.cache.ChildData;
import oadd.org.apache.curator.framework.recipes.cache.PathChildrenCache;
import oadd.org.apache.drill.common.collections.ImmutableEntry;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.coord.zk.PathUtils;
import oadd.org.apache.drill.exec.exception.VersionMismatchException;
import oadd.org.apache.drill.exec.store.sys.store.DataChangeVersion;
import oadd.org.apache.jute.BinaryInputArchive;
import oadd.org.apache.zookeeper.CreateMode;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperClient.class);
    private final CuratorFramework curator;
    private final String root;
    private final PathChildrenCache cache;
    private final CreateMode mode;
    private final int MAX_DATA_LENGTH = BinaryInputArchive.maxBuffer;

    public ZookeeperClient(CuratorFramework curator, String root, CreateMode mode) {
        this.curator = Preconditions.checkNotNull(curator, "curator is required");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(root), "root path is required");
        Preconditions.checkArgument(root.charAt(0) == '/', "root path must be absolute");
        this.root = root;
        this.mode = Preconditions.checkNotNull(mode, "mode is required");
        this.cache = new PathChildrenCache(curator, root, true);
    }

    public void start() throws Exception {
        this.curator.newNamespaceAwareEnsurePath(this.root).ensure(this.curator.getZookeeperClient());
        this.getCache().start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
    }

    public PathChildrenCache getCache() {
        return this.cache;
    }

    public String getRoot() {
        return this.root;
    }

    public CreateMode getMode() {
        return this.mode;
    }

    public boolean hasPath(String path) {
        return this.hasPath(path, false, null);
    }

    public boolean hasPath(String path, boolean consistent) {
        return this.hasPath(path, consistent, null);
    }

    public boolean hasPath(String path, boolean consistent, DataChangeVersion version) {
        Preconditions.checkNotNull(path, "path is required");
        String target = PathUtils.join(this.root, path);
        try {
            if (consistent) {
                Stat stat = (Stat)this.curator.checkExists().forPath(target);
                if (version != null && stat != null) {
                    version.setVersion(stat.getVersion());
                }
                return stat != null;
            }
            return this.getCache().getCurrentData(target) != null;
        }
        catch (Exception e) {
            throw new DrillRuntimeException("error while checking path on zookeeper", e);
        }
    }

    public byte[] get(String path) {
        return this.get(path, false);
    }

    public byte[] get(String path, boolean consistent) {
        return this.get(path, consistent, null);
    }

    public byte[] get(String path, DataChangeVersion version) {
        return this.get(path, true, version);
    }

    public byte[] get(String path, boolean consistent, DataChangeVersion version) {
        Preconditions.checkNotNull(path, "path is required");
        String target = PathUtils.join(this.root, path);
        if (consistent) {
            try {
                if (version != null) {
                    Stat stat = new Stat();
                    byte[] bytes = (byte[])((WatchPathable)this.curator.getData().storingStatIn(stat)).forPath(target);
                    version.setVersion(stat.getVersion());
                    return bytes;
                }
                return (byte[])this.curator.getData().forPath(target);
            }
            catch (Exception ex) {
                throw new DrillRuntimeException(String.format("error retrieving value for [%s]", path), ex);
            }
        }
        ChildData data = this.getCache().getCurrentData(target);
        if (data != null) {
            return data.getData();
        }
        return null;
    }

    public void create(String path) {
        Preconditions.checkNotNull(path, "path is required");
        String target = PathUtils.join(this.root, path);
        try {
            ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(this.mode)).forPath(target);
            this.getCache().rebuildNode(target);
        }
        catch (Exception e) {
            throw new DrillRuntimeException("unable to put ", e);
        }
    }

    public void put(String path, byte[] data) {
        this.put(path, data, null);
    }

    public void put(String path, byte[] data, DataChangeVersion version) {
        Preconditions.checkNotNull(path, "path is required");
        Preconditions.checkNotNull(data, "data is required");
        if (data.length > this.MAX_DATA_LENGTH) {
            throw new IllegalArgumentException(String.format("Can't put this data. Data size %d bytes is bigger than jute.maxbuffer %d", data.length, this.MAX_DATA_LENGTH));
        }
        String target = PathUtils.join(this.root, path);
        try {
            boolean hasNode = this.hasPath(path, true);
            if (!hasNode) {
                try {
                    ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(this.mode)).forPath(target, data);
                }
                catch (KeeperException.NodeExistsException e) {
                    hasNode = true;
                }
            }
            if (hasNode) {
                if (version != null) {
                    try {
                        ((BackgroundPathAndBytesable)this.curator.setData().withVersion(version.getVersion())).forPath(target, data);
                    }
                    catch (KeeperException.BadVersionException e) {
                        throw new VersionMismatchException("Unable to put data. Version mismatch is detected.", version.getVersion(), e);
                    }
                } else {
                    this.curator.setData().forPath(target, data);
                }
            }
            this.getCache().rebuildNode(target);
        }
        catch (VersionMismatchException e) {
            throw e;
        }
        catch (Exception e) {
            logger.info("Data size to persist is: {} bytes, client jute.maxbuffer value is: {}. Make sure that the client jute.maxbuffer value corresponds to the zookeeper server value.", (Object)data.length, (Object)this.MAX_DATA_LENGTH);
            throw new DrillRuntimeException("unable to put ", e);
        }
    }

    public byte[] putIfAbsent(String path, byte[] data) {
        Preconditions.checkNotNull(path, "path is required");
        Preconditions.checkNotNull(data, "data is required");
        if (data.length > this.MAX_DATA_LENGTH) {
            throw new IllegalArgumentException(String.format("Can't put this data. Data size %d bytes is bigger than jute.maxbuffer %d", data.length, this.MAX_DATA_LENGTH));
        }
        String target = PathUtils.join(this.root, path);
        try {
            try {
                ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(this.mode)).forPath(target, data);
                this.getCache().rebuildNode(target);
                return null;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                return (byte[])this.curator.getData().forPath(target);
            }
        }
        catch (Exception e) {
            logger.info("Data size to persist is: {} bytes, client jute.maxbuffer value is: {}. Make sure that the client jute.maxbuffer value corresponds to the zookeeper server value.", (Object)data.length, (Object)this.MAX_DATA_LENGTH);
            throw new DrillRuntimeException("unable to put ", e);
        }
    }

    public void delete(String path) {
        Preconditions.checkNotNull(path, "path is required");
        String target = PathUtils.join(this.root, path);
        try {
            this.curator.delete().forPath(target);
            this.getCache().rebuildNode(target);
        }
        catch (Exception e) {
            throw new DrillRuntimeException(String.format("unable to delete node at %s", target), e);
        }
    }

    public Iterator<Map.Entry<String, byte[]>> entries() {
        final String prefix = PathUtils.join(this.root, "/");
        return Iterables.transform(this.getCache().getCurrentData(), new Function<ChildData, Map.Entry<String, byte[]>>(){

            @Override
            @Nullable
            public Map.Entry<String, byte[]> apply(ChildData data) {
                String key = data.getPath().replace(prefix, "");
                return new ImmutableEntry<String, byte[]>(key, data.getData());
            }
        }).iterator();
    }

    @Override
    public void close() throws Exception {
        this.getCache().close();
    }
}

