/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.net.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubnetUtils {
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})";
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern CIDR_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})");
    private static final int NBITS = 32;
    private static final String PARSE_FAIL = "Could not parse [%s]";
    private final int netmask;
    private final int address;
    private final int network;
    private final int broadcast;
    private boolean inclusiveHostCount;

    private static int matchAddress(Matcher matcher) {
        int addr = 0;
        for (int i = 1; i <= 4; ++i) {
            int n = SubnetUtils.rangeCheck(Integer.parseInt(matcher.group(i)), 0, 255);
            addr |= (n & 0xFF) << 8 * (4 - i);
        }
        return addr;
    }

    private static int rangeCheck(int value, int begin, int end) {
        if (value >= begin && value <= end) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] not in range [" + begin + "," + end + "]");
    }

    private static int toInteger(String address) {
        Matcher matcher = ADDRESS_PATTERN.matcher(address);
        if (matcher.matches()) {
            return SubnetUtils.matchAddress(matcher);
        }
        throw new IllegalArgumentException(String.format(PARSE_FAIL, address));
    }

    public SubnetUtils(String cidrNotation) {
        Matcher matcher = CIDR_PATTERN.matcher(cidrNotation);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format(PARSE_FAIL, cidrNotation));
        }
        this.address = SubnetUtils.matchAddress(matcher);
        int trailingZeroes = 32 - SubnetUtils.rangeCheck(Integer.parseInt(matcher.group(5)), 0, 32);
        this.netmask = (int)(0xFFFFFFFFL << trailingZeroes);
        this.network = this.address & this.netmask;
        this.broadcast = this.network | ~this.netmask;
    }

    public SubnetUtils(String address, String mask) {
        this.address = SubnetUtils.toInteger(address);
        this.netmask = SubnetUtils.toInteger(mask);
        if ((this.netmask & -this.netmask) - 1 != ~this.netmask) {
            throw new IllegalArgumentException(String.format(PARSE_FAIL, mask));
        }
        this.network = this.address & this.netmask;
        this.broadcast = this.network | ~this.netmask;
    }

    public final SubnetInfo getInfo() {
        return new SubnetInfo();
    }

    public SubnetUtils getNext() {
        return new SubnetUtils(this.getInfo().getNextAddress(), this.getInfo().getNetmask());
    }

    public SubnetUtils getPrevious() {
        return new SubnetUtils(this.getInfo().getPreviousAddress(), this.getInfo().getNetmask());
    }

    public boolean isInclusiveHostCount() {
        return this.inclusiveHostCount;
    }

    public void setInclusiveHostCount(boolean inclusiveHostCount) {
        this.inclusiveHostCount = inclusiveHostCount;
    }

    public final class SubnetInfo {
        private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;

        private SubnetInfo() {
        }

        public int asInteger(String address) {
            return SubnetUtils.toInteger(address);
        }

        private long broadcastLong() {
            return (long)SubnetUtils.this.broadcast & 0xFFFFFFFFL;
        }

        private String format(int[] octets) {
            int last = octets.length - 1;
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (true) {
                builder.append(octets[i]);
                if (i == last) {
                    return builder.toString();
                }
                builder.append('.');
                ++i;
            }
        }

        public String getAddress() {
            return this.format(this.toArray(SubnetUtils.this.address));
        }

        @Deprecated
        public int getAddressCount() {
            long countLong = this.getAddressCountLong();
            if (countLong > Integer.MAX_VALUE) {
                throw new RuntimeException("Count is larger than an integer: " + countLong);
            }
            return (int)countLong;
        }

        public long getAddressCountLong() {
            long b = this.broadcastLong();
            long n = this.networkLong();
            long count = b - n + (long)(SubnetUtils.this.isInclusiveHostCount() ? 1 : -1);
            return count < 0L ? 0L : count;
        }

        public String[] getAllAddresses() {
            int ct = this.getAddressCount();
            String[] addresses = new String[ct];
            if (ct == 0) {
                return addresses;
            }
            int add = this.low();
            int j = 0;
            while (add <= this.high()) {
                addresses[j] = this.format(this.toArray(add));
                ++add;
                ++j;
            }
            return addresses;
        }

        public String getBroadcastAddress() {
            return this.format(this.toArray(SubnetUtils.this.broadcast));
        }

        public String getCidrSignature() {
            return this.format(this.toArray(SubnetUtils.this.address)) + "/" + Integer.bitCount(SubnetUtils.this.netmask);
        }

        public String getHighAddress() {
            return this.format(this.toArray(this.high()));
        }

        public String getLowAddress() {
            return this.format(this.toArray(this.low()));
        }

        public String getNetmask() {
            return this.format(this.toArray(SubnetUtils.this.netmask));
        }

        public String getNetworkAddress() {
            return this.format(this.toArray(SubnetUtils.this.network));
        }

        public String getNextAddress() {
            return this.format(this.toArray(SubnetUtils.this.address + 1));
        }

        public String getPreviousAddress() {
            return this.format(this.toArray(SubnetUtils.this.address - 1));
        }

        private int high() {
            return SubnetUtils.this.isInclusiveHostCount() ? SubnetUtils.this.broadcast : (this.broadcastLong() - this.networkLong() > 1L ? SubnetUtils.this.broadcast - 1 : 0);
        }

        public boolean isInRange(int address) {
            if (address == 0) {
                return false;
            }
            long addLong = (long)address & 0xFFFFFFFFL;
            long lowLong = (long)this.low() & 0xFFFFFFFFL;
            long highLong = (long)this.high() & 0xFFFFFFFFL;
            return addLong >= lowLong && addLong <= highLong;
        }

        public boolean isInRange(String address) {
            return this.isInRange(SubnetUtils.toInteger(address));
        }

        private int low() {
            return SubnetUtils.this.isInclusiveHostCount() ? SubnetUtils.this.network : (this.broadcastLong() - this.networkLong() > 1L ? SubnetUtils.this.network + 1 : 0);
        }

        private long networkLong() {
            return (long)SubnetUtils.this.network & 0xFFFFFFFFL;
        }

        private int[] toArray(int val) {
            int[] ret = new int[4];
            for (int j = 3; j >= 0; --j) {
                int n = j;
                ret[n] = ret[n] | val >>> 8 * (3 - j) & 0xFF;
            }
            return ret;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("CIDR Signature:\t[").append(this.getCidrSignature()).append("]\n").append("  Netmask: [").append(this.getNetmask()).append("]\n").append("  Network: [").append(this.getNetworkAddress()).append("]\n").append("  Broadcast: [").append(this.getBroadcastAddress()).append("]\n").append("  First address: [").append(this.getLowAddress()).append("]\n").append("  Last address: [").append(this.getHighAddress()).append("]\n").append("  Address Count: [").append(this.getAddressCountLong()).append("]\n");
            return buf.toString();
        }
    }
}

