/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.impl.io;

import java.util.concurrent.atomic.AtomicReference;
import oadd.io.jsonwebtoken.impl.io.InstanceLocator;
import oadd.io.jsonwebtoken.io.Deserializer;
import oadd.io.jsonwebtoken.lang.Assert;
import oadd.io.jsonwebtoken.lang.Classes;

public class RuntimeClasspathDeserializerLocator<T>
implements InstanceLocator<Deserializer<T>> {
    private static final AtomicReference<Deserializer> DESERIALIZER = new AtomicReference();

    @Override
    public Deserializer<T> getInstance() {
        Deserializer deserializer = DESERIALIZER.get();
        if (deserializer == null) {
            deserializer = this.locate();
            Assert.state(deserializer != null, "locate() cannot return null.");
            if (!this.compareAndSet(deserializer)) {
                deserializer = DESERIALIZER.get();
            }
        }
        Assert.state(deserializer != null, "deserializer cannot be null.");
        return deserializer;
    }

    protected Deserializer<T> locate() {
        if (this.isAvailable("oadd.io.jsonwebtoken.io.JacksonDeserializer")) {
            return (Deserializer)Classes.newInstance("oadd.io.jsonwebtoken.io.JacksonDeserializer");
        }
        if (this.isAvailable("oadd.io.jsonwebtoken.io.OrgJsonDeserializer")) {
            return (Deserializer)Classes.newInstance("oadd.io.jsonwebtoken.io.OrgJsonDeserializer");
        }
        throw new IllegalStateException("Unable to discover any JSON Deserializer implementations on the classpath.");
    }

    protected boolean compareAndSet(Deserializer<T> d) {
        return DESERIALIZER.compareAndSet(null, d);
    }

    protected boolean isAvailable(String fqcn) {
        return Classes.isAvailable(fqcn);
    }
}

