/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import org.bouncycastle.jsse.provider.ReflectionUtil;

public class IDNUtil {
    public static final int ALLOW_UNASSIGNED = ReflectionUtil.getStaticIntOrDefault("java.net.IDN", "ALLOW_UNASSIGNED", 1);
    public static final int USE_STD3_ASCII_RULES = ReflectionUtil.getStaticIntOrDefault("java.net.IDN", "USE_STD3_ASCII_RULES", 2);
    public static final Method toASCIIMethod = ReflectionUtil.getMethod("java.net.IDN", "toASCII", String.class, Integer.TYPE);
    public static final Method toUnicodeMethod = ReflectionUtil.getMethod("java.net.IDN", "toUnicode", String.class, Integer.TYPE);
    private static final String IDN_CLASSNAME = "java.net.IDN";
    private static final int MAX_LABEL_LENGTH = 63;

    public static String toASCII(String input, int flag) {
        if (null != toASCIIMethod) {
            return (String)ReflectionUtil.invokeMethod(null, toASCIIMethod, input, flag);
        }
        if (IDNUtil.isRoot(input)) {
            return ".";
        }
        StringBuilder result = new StringBuilder();
        int len = input.length();
        int pos = 0;
        while (pos < len) {
            int sepPos = IDNUtil.findSeparator(input, pos);
            String label = input.substring(pos, sepPos);
            String asciiLabel = IDNUtil.toAsciiLabel(label, flag);
            result.append(asciiLabel);
            if (sepPos < input.length()) {
                result.append('.');
            }
            pos = sepPos + 1;
        }
        return result.toString();
    }

    public static String toUnicode(String input, int flag) {
        if (null != toUnicodeMethod) {
            return (String)ReflectionUtil.invokeMethod(null, toUnicodeMethod, input, flag);
        }
        if (IDNUtil.isRoot(input)) {
            return ".";
        }
        StringBuilder result = new StringBuilder();
        int len = input.length();
        int pos = 0;
        while (pos < len) {
            int sepPos = IDNUtil.findSeparator(input, pos);
            String label = input.substring(pos, sepPos);
            String unicodeLabel = IDNUtil.toUnicodeLabel(label, flag);
            result.append(unicodeLabel);
            if (sepPos < input.length()) {
                result.append('.');
            }
            pos = sepPos + 1;
        }
        return result.toString();
    }

    private static int findSeparator(String s2, int pos) {
        while (pos < s2.length() && !IDNUtil.isSeparator(s2.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private static boolean isAllAscii(CharSequence s2) {
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c < '\u0080') continue;
            return false;
        }
        return true;
    }

    private static boolean hasAnyNonLDHAscii(CharSequence s2) {
        for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            if (!('\u0000' <= ch && ch <= ',' || '.' <= ch && ch <= '/' || ':' <= ch && ch <= '@' || '[' <= ch && ch <= '`') && ('{' > ch || ch > '\u007f')) continue;
            return true;
        }
        return false;
    }

    private static boolean isRoot(String s2) {
        return s2.length() == 1 && IDNUtil.isSeparator(s2.charAt(0));
    }

    private static boolean isSeparator(char c) {
        switch (c) {
            case '.': 
            case '\u3002': 
            case '\uff0e': 
            case '\uff61': {
                return true;
            }
        }
        return false;
    }

    private static String toAsciiLabel(String s2, int flag) {
        boolean useSTD3ASCIIRules;
        if (s2.length() < 1) {
            throw new IllegalArgumentException("Domain name label cannot be empty");
        }
        boolean allAscii = IDNUtil.isAllAscii(s2);
        if (!allAscii) {
            throw new UnsupportedOperationException("IDN support incomplete");
        }
        boolean bl = useSTD3ASCIIRules = (flag & USE_STD3_ASCII_RULES) != 0;
        if (useSTD3ASCIIRules) {
            if (IDNUtil.hasAnyNonLDHAscii(s2)) {
                throw new IllegalArgumentException("Domain name label cannot contain non-LDH characters");
            }
            if ('-' == s2.charAt(0) || '-' == s2.charAt(s2.length() - 1)) {
                throw new IllegalArgumentException("Domain name label cannot begin or end with a hyphen");
            }
        }
        if (63 < s2.length()) {
            throw new IllegalArgumentException("Domain name label length cannot be more than 63");
        }
        return s2;
    }

    private static String toUnicodeLabel(String s2, int flag) {
        return s2;
    }
}

