/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.util;

import java.lang.reflect.Modifier;
import oadd.com.google.common.annotations.VisibleForTesting;
import oadd.javassist.ClassPool;
import oadd.javassist.CtClass;
import oadd.javassist.CtConstructor;
import oadd.javassist.CtMethod;
import oadd.javassist.CtNewMethod;
import oadd.javassist.scopedpool.ScopedClassPoolRepository;
import oadd.javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaPatcher {
    private static final Logger logger = LoggerFactory.getLogger(GuavaPatcher.class);
    private static boolean patchingAttempted;
    private static boolean patchingSuccessful;

    public static synchronized void patch() {
        if (!patchingAttempted) {
            patchingAttempted = true;
            GuavaPatcher.patchStopwatch();
            GuavaPatcher.patchCloseables();
            GuavaPatcher.patchFuturesCallback();
        }
    }

    @VisibleForTesting
    static boolean isPatchingSuccessful() {
        return patchingAttempted && patchingSuccessful;
    }

    private static void patchStopwatch() {
        try {
            ClassPool cp = GuavaPatcher.getClassPool();
            CtClass cc = cp.get("oadd.com.google.common.base.Stopwatch");
            for (CtConstructor c : cc.getConstructors()) {
                if (Modifier.isStatic(c.getModifiers())) continue;
                c.setModifiers(1);
            }
            CtMethod newMethod = CtNewMethod.make("public long elapsedMillis() { return elapsed(java.util.concurrent.TimeUnit.MILLISECONDS); }", cc);
            cc.addMethod(newMethod);
            cc.toClass();
            logger.info("Google's Stopwatch patched for old HBase Guava version.");
        }
        catch (Exception e) {
            GuavaPatcher.logUnableToPatchException(e);
        }
    }

    private static void logUnableToPatchException(Exception e) {
        patchingSuccessful = false;
        logger.warn("Unable to patch Guava classes: {}", (Object)e.getMessage());
        logger.debug("Exception:", e);
    }

    private static void patchCloseables() {
        try {
            ClassPool cp = GuavaPatcher.getClassPool();
            CtClass cc = cp.get("oadd.com.google.common.io.Closeables");
            CtMethod newMethod = CtNewMethod.make("public static void closeQuietly(java.io.Closeable closeable) { try{closeable.close();}catch(Exception e){} }", cc);
            cc.addMethod(newMethod);
            cc.toClass();
            logger.info("Google's Closeables patched for old HBase Guava version.");
        }
        catch (Exception e) {
            GuavaPatcher.logUnableToPatchException(e);
        }
    }

    private static ClassPool getClassPool() {
        ScopedClassPoolRepository classPoolRepository = ScopedClassPoolRepositoryImpl.getInstance();
        classPoolRepository.setPrune(false);
        return classPoolRepository.createScopedClassPool(GuavaPatcher.class.getClassLoader(), null);
    }

    private static void patchFuturesCallback() {
        try {
            ClassPool cp = GuavaPatcher.getClassPool();
            CtClass cc = cp.get("oadd.com.google.common.util.concurrent.Futures");
            CtMethod newMethod = CtNewMethod.make("public static void addCallback(com.google.common.util.concurrent.ListenableFuture future, com.google.common.util.concurrent.FutureCallback callback) { addCallback(future, callback, com.google.common.util.concurrent.MoreExecutors.directExecutor()); }", cc);
            cc.addMethod(newMethod);
            cc.toClass();
            logger.info("Google's Futures#addCallback patched for old Hadoop Guava version.");
        }
        catch (Exception e) {
            GuavaPatcher.logUnableToPatchException(e);
        }
    }

    static {
        patchingSuccessful = true;
    }
}

