/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.impl.compression;

import oadd.io.jsonwebtoken.CompressionCodec;
import oadd.io.jsonwebtoken.CompressionCodecResolver;
import oadd.io.jsonwebtoken.CompressionCodecs;
import oadd.io.jsonwebtoken.CompressionException;
import oadd.io.jsonwebtoken.Header;
import oadd.io.jsonwebtoken.lang.Assert;
import oadd.io.jsonwebtoken.lang.Strings;

public class DefaultCompressionCodecResolver
implements CompressionCodecResolver {
    @Override
    public CompressionCodec resolveCompressionCodec(Header header) {
        String cmpAlg = this.getAlgorithmFromHeader(header);
        boolean hasCompressionAlgorithm = Strings.hasText(cmpAlg);
        if (!hasCompressionAlgorithm) {
            return null;
        }
        if (CompressionCodecs.DEFLATE.getAlgorithmName().equalsIgnoreCase(cmpAlg)) {
            return CompressionCodecs.DEFLATE;
        }
        if (CompressionCodecs.GZIP.getAlgorithmName().equalsIgnoreCase(cmpAlg)) {
            return CompressionCodecs.GZIP;
        }
        throw new CompressionException("Unsupported compression algorithm '" + cmpAlg + "'");
    }

    private String getAlgorithmFromHeader(Header header) {
        Assert.notNull(header, "header cannot be null.");
        return header.getCompressionAlgorithm();
    }
}

