/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.datatype.joda.deser;

import java.io.IOException;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonToken;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.JsonNode;
import oadd.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import oadd.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import oadd.com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import oadd.org.joda.time.Days;
import oadd.org.joda.time.Hours;
import oadd.org.joda.time.Minutes;
import oadd.org.joda.time.Months;
import oadd.org.joda.time.Period;
import oadd.org.joda.time.ReadablePeriod;
import oadd.org.joda.time.Seconds;
import oadd.org.joda.time.Weeks;
import oadd.org.joda.time.Years;

public class PeriodDeserializer
extends JodaDeserializerBase<ReadablePeriod> {
    private static final long serialVersionUID = 1L;
    private final JacksonJodaPeriodFormat _format = FormatConfig.DEFAULT_PERIOD_FORMAT;
    private final boolean _requireFullPeriod;

    public PeriodDeserializer() {
        this(true);
    }

    public PeriodDeserializer(boolean fullPeriod) {
        super(fullPeriod ? Period.class : ReadablePeriod.class);
        this._requireFullPeriod = fullPeriod;
    }

    @Override
    public ReadablePeriod deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2 = p.currentToken();
        if (t2 == JsonToken.VALUE_STRING) {
            return this._fromString(p, ctxt, p.getText());
        }
        if (t2 == JsonToken.VALUE_NUMBER_INT) {
            return new Period(p.getLongValue());
        }
        if (t2 != JsonToken.START_OBJECT && t2 != JsonToken.FIELD_NAME) {
            return (ReadablePeriod)ctxt.handleUnexpectedToken(this.handledType(), t2, p, "expected JSON Number, String or Object", new Object[0]);
        }
        return this._fromObject(p, ctxt);
    }

    protected ReadablePeriod _fromString(JsonParser p, DeserializationContext ctxt, String value) throws IOException {
        if ((value = value.trim()).isEmpty()) {
            return (ReadablePeriod)this._fromEmptyString(p, ctxt, value);
        }
        return this._format.parsePeriod(ctxt, value);
    }

    protected ReadablePeriod _fromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        ReadablePeriod rp;
        JsonNode treeNode = (JsonNode)p.readValueAsTree();
        String periodType = treeNode.path("fieldType").path("name").asText();
        String periodName = treeNode.path("periodType").path("name").asText();
        int periodValue = treeNode.path(periodType).asInt();
        if (periodName.equals("Seconds")) {
            rp = Seconds.seconds(periodValue);
        } else if (periodName.equals("Minutes")) {
            rp = Minutes.minutes(periodValue);
        } else if (periodName.equals("Hours")) {
            rp = Hours.hours(periodValue);
        } else if (periodName.equals("Days")) {
            rp = Days.days(periodValue);
        } else if (periodName.equals("Weeks")) {
            rp = Weeks.weeks(periodValue);
        } else if (periodName.equals("Months")) {
            rp = Months.months(periodValue);
        } else if (periodName.equals("Years")) {
            rp = Years.years(periodValue);
        } else {
            ctxt.reportInputMismatch(this.handledType(), "Don't know how to deserialize %s using periodName '%s'", this.handledType().getName(), periodName);
            return null;
        }
        if (this._requireFullPeriod && !(rp instanceof Period)) {
            rp = rp.toPeriod();
        }
        return rp;
    }
}

