/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.fn;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import oadd.com.fasterxml.jackson.core.JsonGenerator;
import oadd.org.apache.drill.exec.vector.complex.fn.BasicJsonOutput;
import oadd.org.apache.drill.exec.vector.complex.fn.DateOutputFormat;
import oadd.org.apache.drill.exec.vector.complex.fn.ExtendedType;
import oadd.org.joda.time.Period;

public class ExtendedJsonOutput
extends BasicJsonOutput {
    public ExtendedJsonOutput(JsonGenerator gen) {
        super(gen, DateOutputFormat.ISO);
    }

    @Override
    public void writeBigInt(long value) throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.INTEGER.serialized);
        super.writeBigInt(value);
        this.gen.writeEndObject();
    }

    @Override
    public void writeBinary(byte[] value) throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.BINARY.serialized);
        super.writeBinary(value);
        this.gen.writeEndObject();
    }

    @Override
    public void writeDate(TemporalAccessor value) throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.DATE.serialized);
        super.writeDate(value);
        this.gen.writeEndObject();
    }

    @Override
    public void writeTime(TemporalAccessor value) throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.TIME.serialized);
        super.writeTime(((LocalTime)value).atOffset(ZoneOffset.UTC));
        this.gen.writeEndObject();
    }

    @Override
    public void writeTimestamp(TemporalAccessor value) throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.TIMESTAMP.serialized);
        super.writeTimestamp(((LocalDateTime)value).atOffset(ZoneOffset.UTC));
        this.gen.writeEndObject();
    }

    @Override
    public void writeInterval(Period value) throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.INTERVAL.serialized);
        super.writeInterval(value);
        this.gen.writeEndObject();
    }

    @Override
    public void writeBigIntNull() throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.INTEGER.serialized);
        super.writeBigIntNull();
        this.gen.writeEndObject();
    }

    @Override
    public void writeBinaryNull() throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.BINARY.serialized);
        super.writeBinaryNull();
        this.gen.writeEndObject();
    }

    @Override
    public void writeDateNull() throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.DATE.serialized);
        super.writeDateNull();
        this.gen.writeEndObject();
    }

    @Override
    public void writeTimeNull() throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.TIME.serialized);
        super.writeTimeNull();
        this.gen.writeEndObject();
    }

    @Override
    public void writeTimestampNull() throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.TIMESTAMP.serialized);
        super.writeTimestampNull();
        this.gen.writeEndObject();
    }

    @Override
    public void writeIntervalNull() throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.INTERVAL.serialized);
        super.writeIntervalNull();
        this.gen.writeEndObject();
    }

    @Override
    public void writeDecimal(BigDecimal value) throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.DECIMAL.serialized);
        super.writeDecimal(value);
        this.gen.writeEndObject();
    }

    @Override
    public void writeDecimalNull() throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(ExtendedType.DECIMAL.serialized);
        super.writeDecimalNull();
        this.gen.writeEndObject();
    }

    @Override
    public void writeTinyInt(byte value) throws IOException {
        this.writeBigInt(value);
    }

    @Override
    public void writeSmallInt(short value) throws IOException {
        this.writeBigInt(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.writeBigInt(value);
    }

    @Override
    public void writeTinyIntNull() throws IOException {
        this.writeBigIntNull();
    }

    @Override
    public void writeSmallIntNull() throws IOException {
        this.writeBigIntNull();
    }

    @Override
    public void writeIntNull() throws IOException {
        this.writeBigIntNull();
    }
}

