/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.selection;

import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;

public class SelectionVector2Builder {
    private final SelectionVector2 sv2;
    private int index;

    public SelectionVector2Builder(BufferAllocator allocator, int maxSize) {
        this.sv2 = new SelectionVector2(allocator);
        this.sv2.allocateNew(maxSize);
    }

    public void setNext(int value) {
        this.sv2.setIndex(this.index++, value);
    }

    public void set(int posn, int value) {
        this.sv2.setIndex(posn, value);
        this.index = Math.max(this.index, posn + 1);
    }

    public SelectionVector2 harvest(VectorContainer batch) {
        this.sv2.setRecordCount(this.index);
        this.sv2.setBatchActualRecordCount(batch.getRecordCount());
        return this.sv2;
    }
}

