/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.oauth;

import java.util.HashMap;
import java.util.Map;
import oadd.com.fasterxml.jackson.annotation.JacksonInject;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonIgnore;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.org.apache.drill.exec.oauth.PersistentTokenRegistry;
import oadd.org.apache.drill.exec.oauth.Tokens;
import oadd.org.apache.drill.exec.store.sys.PersistentStore;

public class PersistentTokenTable
implements Tokens {
    public final String ACCESS_TOKEN_KEY = "access_token";
    public final String REFRESH_TOKEN_KEY = "refresh_token";
    private final Map<String, String> tokens;
    private final String key;
    private final PersistentStore<PersistentTokenTable> store;

    @JsonCreator
    public PersistentTokenTable(@JsonProperty(value="tokens") Map<String, String> tokens, @JsonProperty(value="key") String key, @JacksonInject PersistentTokenRegistry.StoreProvider storeProvider) {
        this.tokens = tokens != null ? tokens : new HashMap();
        this.key = key;
        this.store = storeProvider.getStore();
    }

    @Override
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @Override
    @JsonIgnore
    public String get(String token) {
        return this.tokens.get(token);
    }

    @Override
    @JsonIgnore
    public boolean put(String token, String value, boolean replace) {
        if (replace || !this.tokens.containsKey(token)) {
            this.tokens.put(token, value);
            this.store.put(this.key, (Object)this);
            return true;
        }
        return false;
    }

    @Override
    @JsonIgnore
    public String getAccessToken() {
        return this.get("access_token");
    }

    @Override
    @JsonIgnore
    public String getRefreshToken() {
        return this.get("refresh_token");
    }

    @Override
    @JsonIgnore
    public void setAccessToken(String token) {
        if (!this.tokens.containsKey("access_token") || !token.equals(this.getAccessToken())) {
            this.put("access_token", token, true);
        }
    }

    @Override
    @JsonIgnore
    public void setRefreshToken(String token) {
        if (!this.tokens.containsKey("refresh_token") || !this.getAccessToken().equals(token)) {
            this.put("refresh_token", token, true);
        }
    }

    @Override
    @JsonIgnore
    public boolean remove(String token) {
        boolean isRemoved = this.tokens.remove(token) != null;
        this.store.put(this.key, (Object)this);
        return isRemoved;
    }

    @JsonProperty(value="tokens")
    public Map<String, String> getTokens() {
        return this.tokens;
    }
}

