/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import org.apache.drill.jdbc.DrillbitClassLoader;
import org.apache.drill.jdbc.Driver;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITTestShadedJar {
    private static final Logger logger = LoggerFactory.getLogger(ITTestShadedJar.class);
    private static DrillbitClassLoader drillbitLoader;
    private static ClassLoader rootClassLoader;
    private static int userPort;
    @ClassRule
    public static final TestWatcher testWatcher;

    private static URL getJdbcUrl() throws MalformedURLException {
        return new URL(String.format("%s../../target/drill-jdbc-all-%s.jar", ClassLoader.getSystemClassLoader().getResource("").toString(), System.getProperty("project.version")));
    }

    @Test
    public void testDatabaseVersion() throws Exception {
        URLClassLoader loader = URLClassLoader.newInstance(new URL[]{ITTestShadedJar.getJdbcUrl()});
        Class<?> clazz = loader.loadClass("org.apache.drill.jdbc.Driver");
        Driver driver = (Driver)clazz.newInstance();
        try (Connection c = driver.connect("jdbc:drill:drillbit=localhost:" + userPort, null);){
            DatabaseMetaData metadata = c.getMetaData();
            Assert.assertEquals((Object)"Apache Drill JDBC Driver", (Object)metadata.getDriverName());
            Assert.assertEquals((Object)"Apache Drill Server", (Object)metadata.getDatabaseProductName());
        }
    }

    @Test
    public void executeJdbcAllQuery() throws Exception {
        URLClassLoader loader = URLClassLoader.newInstance(new URL[]{ITTestShadedJar.getJdbcUrl()});
        Class<?> clazz = loader.loadClass("org.apache.drill.jdbc.Driver");
        Driver driver = (Driver)clazz.newInstance();
        try (Connection c = driver.connect("jdbc:drill:drillbit=localhost:" + userPort, null);){
            ITTestShadedJar.printQuery(c, "select * from cp.`types.json`");
        }
    }

    private static void printQuery(Connection c, String query) throws SQLException {
        StringBuilder sb = new StringBuilder();
        try (Statement s = c.createStatement();
             ResultSet result = s.executeQuery(query);){
            while (result.next()) {
                int columnCount = result.getMetaData().getColumnCount();
                for (int i = 1; i < columnCount + 1; ++i) {
                    sb.append(result.getObject(i));
                    sb.append('\t');
                }
                sb.append(result.getObject(1)).append('\n');
            }
        }
        logger.info(sb.toString());
    }

    private static int getClassesLoadedCount(ClassLoader classLoader) {
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            Vector classes = (Vector)f.get(classLoader);
            return classes.size();
        }
        catch (Exception e) {
            logger.error("Exception ", (Throwable)e);
            return -1;
        }
    }

    private static void printClassesLoaded(String prefix, ClassLoader classLoader) {
        StringBuilder sb = new StringBuilder();
        try {
            Field f = ClassLoader.class.getDeclaredField("classes");
            f.setAccessible(true);
            Vector classes = (Vector)f.get(classLoader);
            for (Class c : classes) {
                sb.append(prefix).append(": ").append(c.getName()).append('\n');
            }
        }
        catch (Exception e) {
            logger.error("Exception ", (Throwable)e);
        }
        logger.info(sb.toString());
    }

    private static void runWithLoader(String name, ClassLoader loader) throws Exception {
        Class<?> clazz = loader.loadClass(ITTestShadedJar.class.getName() + "$" + name);
        Object instance = clazz.getDeclaredConstructors()[0].newInstance(loader);
        clazz.getMethod("go", new Class[0]).invoke(instance, new Object[0]);
    }

    static {
        testWatcher = new TestWatcher(){

            protected void starting(Description description) {
                super.starting(description);
                try {
                    drillbitLoader = new DrillbitClassLoader();
                    drillbitLoader.loadClass("org.apache.commons.io.FileUtils");
                    rootClassLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = drillbitLoader.loadClass("org.apache.drill.test.BaseTestQuery");
                    Class<?> watcherClazz = drillbitLoader.loadClass("org.apache.drill.test.BaseDirTestWatcher");
                    this.runMethod("starting", description);
                    Object watcher = clazz.getField("dirTestWatcher").get(null);
                    Method method = watcherClazz.getDeclaredMethod("getTmpDir", new Class[0]);
                    File tmpDir = (File)method.invoke(watcher, new Object[0]);
                    System.setProperty("DRILL_CONF_DIR", tmpDir.getAbsolutePath());
                    try {
                        ITTestShadedJar.runWithLoader("DrillbitStartThread", drillbitLoader);
                    }
                    catch (Exception e) {
                        ITTestShadedJar.printClassesLoaded("root", rootClassLoader);
                        throw e;
                    }
                    DrillbitStartThread.SEM.acquire();
                    userPort = (Integer)clazz.getMethod("getUserPort", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            protected void finished(Description description) {
                super.finished(description);
                this.done();
                this.runMethod("finished", description);
            }

            protected void failed(Throwable e, Description description) {
                super.failed(e, description);
                this.done();
                this.runMethod("failed", description);
                logger.error("Check whether this test was running within 'integration-test' Maven phase");
            }

            private void done() {
                try {
                    ITTestShadedJar.runWithLoader("DrillbitStopThread", drillbitLoader);
                    DrillbitStopThread.SEM.acquire();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            private void runMethod(String name, Description description) {
                try {
                    Class<?> clazz = drillbitLoader.loadClass("org.apache.drill.test.BaseTestQuery");
                    Class<?> watcherClazz = drillbitLoader.loadClass("org.junit.rules.TestWatcher");
                    Object watcher = clazz.getField("dirTestWatcher").get(null);
                    Method method = watcherClazz.getDeclaredMethod(name, Description.class);
                    method.setAccessible(true);
                    method.invoke(watcher, description);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static class DrillbitStopThread
    extends AbstractLoaderThread {
        public static final Semaphore SEM = new Semaphore(0);

        public DrillbitStopThread(ClassLoader loader) {
            super(loader);
        }

        @Override
        protected void internalRun() throws Exception {
            Class<?> clazz = this.loader.loadClass("org.apache.drill.test.BaseTestQuery");
            clazz.getMethod("closeClient", new Class[0]).invoke(null, new Object[0]);
            SEM.release();
        }
    }

    public static class DrillbitStartThread
    extends AbstractLoaderThread {
        public static final Semaphore SEM = new Semaphore(0);

        public DrillbitStartThread(ClassLoader loader) {
            super(loader);
        }

        @Override
        protected void internalRun() throws Exception {
            Class<?> clazz = this.loader.loadClass("org.apache.drill.test.BaseTestQuery");
            clazz.getMethod("setupDefaultTestCluster", new Class[0]).invoke(null, new Object[0]);
            clazz.getMethod("testNoResult", String.class, Object[].class).invoke(null, "select * from (VALUES 1)", new Object[0]);
            SEM.release();
        }
    }

    public static abstract class AbstractLoaderThread
    extends Thread {
        private Exception ex;
        protected final ClassLoader loader;

        public AbstractLoaderThread(ClassLoader loader) {
            this.setContextClassLoader(loader);
            this.loader = loader;
        }

        @Override
        public final void run() {
            try {
                this.internalRun();
            }
            catch (Exception e) {
                this.ex = e;
            }
        }

        protected abstract void internalRun() throws Exception;

        public void go() throws Exception {
            this.start();
            this.join();
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }
}

