/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.server.quorum;

import java.io.IOException;
import oadd.org.apache.jute.Record;
import oadd.org.apache.zookeeper.common.Time;
import oadd.org.apache.zookeeper.server.quorum.FollowerBean;
import oadd.org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import oadd.org.apache.zookeeper.server.quorum.Learner;
import oadd.org.apache.zookeeper.server.quorum.QuorumPacket;
import oadd.org.apache.zookeeper.server.quorum.QuorumPeer;
import oadd.org.apache.zookeeper.server.util.SerializeUtils;
import oadd.org.apache.zookeeper.server.util.ZxidUtils;
import oadd.org.apache.zookeeper.txn.TxnHeader;

public class Follower
extends Learner {
    private long lastQueued;
    final FollowerZooKeeperServer fzk;

    Follower(QuorumPeer self, FollowerZooKeeperServer zk) {
        this.self = self;
        this.zk = zk;
        this.fzk = zk;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Follower ").append(this.sock);
        sb.append(" lastQueuedZxid:").append(this.lastQueued);
        sb.append(" pendingRevalidationCount:").append(this.pendingRevalidations.size());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void followLeader() throws InterruptedException {
        this.self.end_fle = Time.currentElapsedTime();
        long electionTimeTaken = this.self.end_fle - this.self.start_fle;
        this.self.setElectionTimeTaken(electionTimeTaken);
        LOG.info("FOLLOWING - LEADER ELECTION TOOK - {}", (Object)electionTimeTaken);
        this.self.start_fle = 0L;
        this.self.end_fle = 0L;
        this.fzk.registerJMX(new FollowerBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            QuorumPeer.QuorumServer leaderServer = this.findLeader();
            try {
                this.connectToLeader(leaderServer.addr, leaderServer.hostname);
                long newEpochZxid = this.registerWithLeader(11);
                long newEpoch = ZxidUtils.getEpochFromZxid(newEpochZxid);
                if (newEpoch < this.self.getAcceptedEpoch()) {
                    LOG.error("Proposed leader epoch " + ZxidUtils.zxidToString(newEpochZxid) + " is less than our accepted epoch " + ZxidUtils.zxidToString(this.self.getAcceptedEpoch()));
                    throw new IOException("Error: Epoch of leader is lower");
                }
                this.syncWithLeader(newEpochZxid);
                QuorumPacket qp = new QuorumPacket();
                while (this.isRunning()) {
                    this.readPacket(qp);
                    this.processPacket(qp);
                }
            }
            catch (Exception e) {
                LOG.warn("Exception when following the leader", e);
                try {
                    this.sock.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                this.pendingRevalidations.clear();
            }
            Object var10_8 = null;
            this.zk.unregisterJMX(this);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.zk.unregisterJMX(this);
            throw throwable;
        }
    }

    protected void processPacket(QuorumPacket qp) throws IOException {
        switch (qp.getType()) {
            case 5: {
                this.ping(qp);
                break;
            }
            case 2: {
                TxnHeader hdr = new TxnHeader();
                Record txn = SerializeUtils.deserializeTxn(qp.getData(), hdr);
                if (hdr.getZxid() != this.lastQueued + 1L) {
                    LOG.warn("Got zxid 0x" + Long.toHexString(hdr.getZxid()) + " expected 0x" + Long.toHexString(this.lastQueued + 1L));
                }
                this.lastQueued = hdr.getZxid();
                this.fzk.logRequest(hdr, txn);
                break;
            }
            case 4: {
                this.fzk.commit(qp.getZxid());
                break;
            }
            case 12: {
                LOG.error("Received an UPTODATE message after Follower started");
                break;
            }
            case 6: {
                this.revalidate(qp);
                break;
            }
            case 7: {
                this.fzk.sync();
                break;
            }
            default: {
                LOG.error("Invalid packet type: {} received by Observer", (Object)qp.getType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZxid() {
        try {
            FollowerZooKeeperServer followerZooKeeperServer = this.fzk;
            synchronized (followerZooKeeperServer) {
                return this.fzk.getZxid();
            }
        }
        catch (NullPointerException e) {
            LOG.warn("error getting zxid", e);
            return -1L;
        }
    }

    protected long getLastQueued() {
        return this.lastQueued;
    }

    public void shutdown() {
        LOG.info("shutdown called", new Exception("shutdown Follower"));
        super.shutdown();
    }
}

