/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import oadd.org.apache.drill.exec.expr.holders.VarDecimalHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.RepeatedVarDecimalVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class RepeatedVarDecimalWriterImpl
extends AbstractFieldWriter {
    private final RepeatedVarDecimalVector.Mutator mutator;
    final RepeatedVarDecimalVector vector;

    public RepeatedVarDecimalWriterImpl(RepeatedVarDecimalVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(VarDecimalHolder h2) {
        this.mutator.addSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableVarDecimalHolder h2) {
        this.mutator.addSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarDecimal(int start, int end, DrillBuf buffer, int scale, int precision) {
        this.mutator.addSafe(this.idx(), start, end, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void setPosition(int idx) {
        super.setPosition(idx);
        this.mutator.startNewValue(idx);
    }
}

