/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import oadd.org.apache.drill.exec.expr.holders.VarDecimalHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.NullableVarDecimalVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class NullableVarDecimalWriterImpl
extends AbstractFieldWriter {
    private final NullableVarDecimalVector.Mutator mutator;
    final NullableVarDecimalVector vector;

    public NullableVarDecimalWriterImpl(NullableVarDecimalVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(VarDecimalHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableVarDecimalHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.mutator.setNull(this.idx());
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarDecimal(int start, int end, DrillBuf buffer, int scale, int precision) {
        this.mutator.setSafe(this.idx(), 1, start, end, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeVarDecimal(BigDecimal value) {
        this.mutator.setSafe(this.idx(), value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

