/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.BitHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableBitHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableBitVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.BitReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitVector
extends BaseDataValueVector
implements FixedWidthVector {
    static final Logger logger = LoggerFactory.getLogger(BitVector.class);
    public static final int VALUE_WIDTH = 1;
    public static final int MAX_CAPACITY = MAX_BUFFER_SIZE / 1;
    public static final int MAX_COUNT = Math.min(65536, MAX_CAPACITY);
    public static final int NET_MAX_SIZE = 1 * MAX_COUNT;
    private final FieldReader reader = new BitReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int valueCount;
    private int allocationSizeInBytes = 4096;
    private int allocationMonitor = 0;

    public BitVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSize() {
        return this.getSizeFromCount(this.valueCount);
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return this.getSizeFromCount(valueCount);
    }

    private int getSizeFromCount(int valueCount) {
        return (int)Math.ceil((double)valueCount / 8.0);
    }

    @Override
    public int getValueCapacity() {
        return (int)Math.min(Integer.MAX_VALUE, (long)this.data.capacity() * 8L);
    }

    private int getByteIndex(int index) {
        return (int)Math.floor((double)index / 8.0);
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        this.allocationSizeInBytes = this.getSizeFromCount(valueCount);
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException();
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8, this.allocationSizeInBytes / 2);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (OutOfMemoryException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.valueCount = 0;
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    @Override
    public void allocateNew(int valueCount) {
        int size = this.getSizeFromCount(valueCount);
        this.allocateBytes(size);
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.zeroVector();
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize;
        for (newAllocationSize = (long)this.allocationSizeInBytes * 2L; newAllocationSize < (long)this.data.capacity(); newAllocationSize *= 2L) {
        }
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)newAllocationSize;
        DrillBuf newBuf = this.allocator.buffer(curSize);
        newBuf.setZero(0, newBuf.capacity());
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        this.data.release();
        this.data = newBuf;
        this.allocationSizeInBytes = curSize;
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        while (this.allocationSizeInBytes < newAllocationSize) {
            this.reAlloc();
        }
        return this.data;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public int getValueWidth() {
        return 1;
    }

    public void copyFrom(int inIndex, int outIndex, BitVector from) {
        this.mutator.set(outIndex, from.accessor.get(inIndex));
    }

    public void copyFromSafe(int inIndex, int outIndex, BitVector from) {
        while (outIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(inIndex, outIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFrom(fromIndex, toIndex, (BitVector)from);
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", (Object)this.field, (Object)metadata);
        int valueCount = metadata.getValueCount();
        int expectedLength = this.getSizeFromCount(valueCount);
        int actualLength = metadata.getBufferLength();
        assert (expectedLength == actualLength) : "expected and actual buffer sizes do not match";
        this.clear();
        this.data = buffer.slice(0, actualLength);
        this.data.retain();
        this.valueCount = valueCount;
    }

    @Override
    public Mutator getMutator() {
        return new Mutator();
    }

    @Override
    public Accessor getAccessor() {
        return new Accessor();
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((BitVector)to);
    }

    public void transferTo(BitVector target) {
        target.clear();
        if (target.data != null) {
            target.data.release();
        }
        target.data = this.data;
        target.data.retain(1);
        target.valueCount = this.valueCount;
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, BitVector target) {
        assert (startIndex + length <= this.valueCount);
        int firstByteIndex = this.getByteIndex(startIndex);
        int numBytesHoldingSourceBits = this.getSizeFromCount(length);
        int firstBitOffset = startIndex % 8;
        if (firstBitOffset == 0) {
            target.clear();
            if (target.data != null) {
                target.data.release();
            }
            target.data = this.data.slice(firstByteIndex, numBytesHoldingSourceBits);
            target.data.retain(1);
        } else {
            target.clear();
            target.allocateNew(length);
            byte byteIPlus1 = 0;
            for (int i = 0; i < numBytesHoldingSourceBits - 1; ++i) {
                byte byteI = this.data.getByte(firstByteIndex + i);
                byteIPlus1 = this.data.getByte(firstByteIndex + i + 1);
                target.data.setByte(i, ((byteI & 0xFF) >>> firstBitOffset) + (byteIPlus1 << 8 - firstBitOffset));
            }
            if (length % 8 != 0) {
                byte lastButOneByte = numBytesHoldingSourceBits == 1 ? this.data.getByte(firstByteIndex) : byteIPlus1;
                byte bitsFromLastButOneByte = (byte)((lastButOneByte & 0xFF) >>> firstBitOffset);
                if (8 > length + firstBitOffset) {
                    byte mask = (byte)((1 << length) - 1);
                    bitsFromLastButOneByte = (byte)(bitsFromLastButOneByte & mask);
                }
                byte lastByte = 8 - firstBitOffset >= length % 8 ? (byte)0 : this.data.getByte(firstByteIndex + numBytesHoldingSourceBits);
                target.data.setByte(numBytesHoldingSourceBits - 1, bitsFromLastButOneByte + (lastByte << 8 - firstBitOffset));
            } else {
                target.data.setByte(numBytesHoldingSourceBits - 1, ((this.data.getByte(firstByteIndex + numBytesHoldingSourceBits - 1) & 0xFF) >>> firstBitOffset) + (this.data.getByte(firstByteIndex + numBytesHoldingSourceBits) << 8 - firstBitOffset));
            }
        }
        target.getMutator().setValueCount(length);
    }

    private void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        super.clear();
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return this.getSizeFromCount(valueCount);
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        NullableBitVector dest = (NullableBitVector)nullableVector;
        dest.getMutator().fromNotNullable(this);
    }

    public class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public final void set(int index, int value) {
            int byteIndex = index >> 3;
            int bitIndex = index & 7;
            byte currentByte = BitVector.this.data.getByte(byteIndex);
            byte bitMask = (byte)(1L << bitIndex);
            currentByte = value != 0 ? (byte)(currentByte | bitMask) : (byte)(currentByte - (bitMask & currentByte));
            BitVector.this.data.setByte(byteIndex, currentByte);
        }

        public final void set(int index, BitHolder holder) {
            this.set(index, holder.value);
        }

        final void set(int index, NullableBitHolder holder) {
            this.set(index, holder.value);
        }

        public void setSafe(int index, int value) {
            while (index >= BitVector.this.getValueCapacity()) {
                BitVector.this.reAlloc();
            }
            this.set(index, value);
        }

        public void setSafe(int index, BitHolder holder) {
            while (index >= BitVector.this.getValueCapacity()) {
                BitVector.this.reAlloc();
            }
            this.set(index, holder.value);
        }

        public void setSafe(int index, NullableBitHolder holder) {
            while (index >= BitVector.this.getValueCapacity()) {
                BitVector.this.reAlloc();
            }
            this.set(index, holder.value);
        }

        @Override
        public final void setValueCount(int valueCount) {
            int currentValueCapacity = BitVector.this.getValueCapacity();
            BitVector.this.valueCount = valueCount;
            int idx = BitVector.this.getSizeFromCount(valueCount);
            while (valueCount > BitVector.this.getValueCapacity()) {
                BitVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                BitVector.this.incrementAllocationMonitor();
            } else if (BitVector.this.allocationMonitor > 0) {
                BitVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(BitVector.this.data, idx);
        }

        @Override
        public final void generateTestData(int values) {
            boolean even = true;
            for (int i = 0; i < values; ++i) {
                if (even) {
                    this.set(i, 1);
                }
                even = !even;
            }
            this.setValueCount(values);
        }
    }

    public class Accessor
    extends BaseValueVector.BaseAccessor {
        public final int get(int index) {
            int byteIndex = index >> 3;
            byte b = BitVector.this.data.getByte(byteIndex);
            int bitIndex = index & 7;
            return Long.bitCount((long)b & 1L << bitIndex);
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        @Override
        public final Boolean getObject(int index) {
            return this.get(index) != 0;
        }

        @Override
        public final int getValueCount() {
            return BitVector.this.valueCount;
        }

        public final void get(int index, BitHolder holder) {
            holder.value = this.get(index);
        }

        public final void get(int index, NullableBitHolder holder) {
            holder.isSet = 1;
            holder.value = this.get(index);
        }
    }

    private class TransferImpl
    implements TransferPair {
        BitVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new BitVector(field, allocator);
        }

        public TransferImpl(BitVector to) {
            this.to = to;
        }

        @Override
        public BitVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            BitVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            BitVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, BitVector.this);
        }
    }
}

