/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.ssl;

import java.util.Optional;
import java.util.function.BiFunction;
import oadd.org.apache.drill.exec.ssl.SSLConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SSLCredentialsProvider {
    private static final String MAPR_CREDENTIALS_PROVIDER_CLIENT = "oadd.org.apache.drill.exec.ssl.SSLCredentialsProviderMaprClient";
    private static final String MAPR_CREDENTIALS_PROVIDER_SERVER = "oadd.org.apache.drill.exec.ssl.SSLCredentialsProviderMaprServer";
    private static final Logger logger = LoggerFactory.getLogger(SSLCredentialsProvider.class);

    SSLCredentialsProvider() {
    }

    static SSLCredentialsProvider getSSLCredentialsProvider(BiFunction<String, String, String> getPropertyMethod, SSLConfig.Mode mode, boolean useMapRSSLConfig) {
        return useMapRSSLConfig ? SSLCredentialsProvider.getMaprCredentialsProvider(mode).orElseGet(() -> new SSLCredentialsProviderImpl(getPropertyMethod)) : new SSLCredentialsProviderImpl(getPropertyMethod);
    }

    private static Optional<SSLCredentialsProvider> getMaprCredentialsProvider(SSLConfig.Mode mode) {
        String maprCredentialsProviderClass = "";
        switch (mode) {
            case SERVER: {
                maprCredentialsProviderClass = MAPR_CREDENTIALS_PROVIDER_SERVER;
                break;
            }
            case CLIENT: {
                maprCredentialsProviderClass = MAPR_CREDENTIALS_PROVIDER_CLIENT;
                break;
            }
            default: {
                throw new IllegalStateException("Should never occur.");
            }
        }
        try {
            return Optional.of((SSLCredentialsProvider)Class.forName(maprCredentialsProviderClass).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            logger.warn("Trying to use MapR credentials provider on a non-MapR platform", e);
            return Optional.empty();
        }
    }

    abstract String getTrustStoreType(String var1, String var2);

    abstract String getTrustStoreLocation(String var1, String var2);

    abstract String getTrustStorePassword(String var1, String var2);

    abstract String getKeyStoreType(String var1, String var2);

    abstract String getKeyStoreLocation(String var1, String var2);

    abstract String getKeyStorePassword(String var1, String var2);

    abstract String getKeyPassword(String var1, String var2);

    private static class SSLCredentialsProviderImpl
    extends SSLCredentialsProvider {
        private final BiFunction<String, String, String> getPropertyMethod;

        private SSLCredentialsProviderImpl(BiFunction<String, String, String> getPropertyMethod) {
            this.getPropertyMethod = getPropertyMethod;
        }

        @Override
        String getTrustStoreType(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getTrustStoreLocation(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getTrustStorePassword(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getKeyStoreType(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getKeyStoreLocation(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getKeyStorePassword(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }

        @Override
        String getKeyPassword(String propertyName, String defaultValue) {
            return this.getPropertyMethod.apply(propertyName, defaultValue);
        }
    }
}

