/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc;

import oadd.com.google.protobuf.Internal;
import oadd.com.google.protobuf.MessageLite;
import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.RemoteConnection;
import oadd.org.apache.drill.exec.rpc.RpcCheckedFuture;
import oadd.org.apache.drill.exec.rpc.RpcCommand;
import oadd.org.apache.drill.exec.rpc.RpcConnectionHandler;
import oadd.org.apache.drill.exec.rpc.RpcException;
import oadd.org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.shaded.guava.com.google.common.util.concurrent.SettableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FutureBitCommand<T extends MessageLite, C extends RemoteConnection, E extends Internal.EnumLite, M extends MessageLite>
implements RpcCommand<T, C, E, M> {
    static final Logger logger = LoggerFactory.getLogger(FutureBitCommand.class);
    protected final SettableFuture<T> settableFuture = SettableFuture.create();
    private final RpcCheckedFuture<T> parentFuture = new RpcCheckedFuture<T>(this.settableFuture);
    private final RpcOutcomeListener<T> outcomeListener = new DeferredRpcOutcome();

    public abstract void doRpcCall(RpcOutcomeListener<T> var1, C var2);

    @Override
    public void connectionAvailable(C connection) {
        this.doRpcCall(this.outcomeListener, connection);
    }

    @Override
    public void connectionSucceeded(C connection) {
        this.connectionAvailable(connection);
    }

    public DrillRpcFuture<T> getFuture() {
        return this.parentFuture;
    }

    @Override
    public RpcOutcomeListener<T> getOutcomeListener() {
        return this.outcomeListener;
    }

    @Override
    public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t2) {
        this.settableFuture.setException(RpcException.mapException(String.format("Command failed while establishing connection.  Failure type %s.", new Object[]{type}), t2));
    }

    private class DeferredRpcOutcome
    implements RpcOutcomeListener<T> {
        private DeferredRpcOutcome() {
        }

        @Override
        public void failed(RpcException ex) {
            FutureBitCommand.this.settableFuture.setException(ex);
        }

        @Override
        public void success(T value, ByteBuf buf) {
            FutureBitCommand.this.parentFuture.setBuffer(buf);
            FutureBitCommand.this.settableFuture.set(value);
        }

        @Override
        public void interrupted(InterruptedException e) {
            logger.warn("Interrupted while running the command", e);
            this.failed(new RpcException(e));
        }
    }
}

