/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.DictBuilder;
import oadd.org.apache.drill.exec.record.metadata.MapColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.RepeatedListBuilder;
import oadd.org.apache.drill.exec.record.metadata.SchemaBuilder;
import oadd.org.apache.drill.exec.record.metadata.SchemaContainer;
import oadd.org.apache.drill.exec.record.metadata.TupleBuilder;
import oadd.org.apache.drill.exec.record.metadata.UnionBuilder;

public class MapBuilder
implements SchemaContainer {
    private final SchemaContainer parent;
    private final TupleBuilder tupleBuilder = new TupleBuilder();
    private final String memberName;
    private final TypeProtos.DataMode mode;

    public MapBuilder(String memberName, TypeProtos.DataMode mode) {
        this(null, memberName, mode);
    }

    public MapBuilder(SchemaContainer parent, String memberName, TypeProtos.DataMode mode) {
        this.parent = parent;
        this.memberName = memberName;
        this.mode = mode;
    }

    @Override
    public void addColumn(ColumnMetadata column) {
        this.tupleBuilder.addColumn(column);
    }

    public MapBuilder add(String name, TypeProtos.MajorType type) {
        return this.add(MaterializedField.create(name, type));
    }

    public MapBuilder add(MaterializedField col) {
        this.tupleBuilder.add(col);
        return this;
    }

    public MapBuilder add(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        this.tupleBuilder.add(name, type, mode);
        return this;
    }

    public MapBuilder add(String name, TypeProtos.MinorType type) {
        this.tupleBuilder.add(name, type);
        return this;
    }

    public MapBuilder add(String name, TypeProtos.MinorType type, int width) {
        this.tupleBuilder.add(name, type, width);
        return this;
    }

    public MapBuilder add(String name, TypeProtos.MinorType type, int precision, int scale) {
        return this.addDecimal(name, type, TypeProtos.DataMode.REQUIRED, precision, scale);
    }

    public MapBuilder addNullable(String name, TypeProtos.MinorType type) {
        this.tupleBuilder.addNullable(name, type);
        return this;
    }

    public MapBuilder addNullable(String name, TypeProtos.MinorType type, int width) {
        this.tupleBuilder.addNullable(name, type, width);
        return this;
    }

    public MapBuilder addNullable(String name, TypeProtos.MinorType type, int precision, int scale) {
        return this.addDecimal(name, type, TypeProtos.DataMode.OPTIONAL, precision, scale);
    }

    public MapBuilder addArray(String name, TypeProtos.MinorType type) {
        this.tupleBuilder.addArray(name, type);
        return this;
    }

    public MapBuilder addArray(String name, TypeProtos.MinorType type, int dims) {
        this.tupleBuilder.addArray(name, type, dims);
        return this;
    }

    public MapBuilder addArray(String name, TypeProtos.MinorType type, int precision, int scale) {
        return this.addDecimal(name, type, TypeProtos.DataMode.REPEATED, precision, scale);
    }

    public MapBuilder addDecimal(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, int precision, int scale) {
        this.tupleBuilder.addDecimal(name, type, mode, precision, scale);
        return this;
    }

    public MapBuilder addMap(String name) {
        return this.tupleBuilder.addMap(this, name);
    }

    public MapBuilder addMapArray(String name) {
        return this.tupleBuilder.addMapArray(this, name);
    }

    public UnionBuilder addUnion(String name) {
        return this.tupleBuilder.addUnion(this, name);
    }

    public UnionBuilder addList(String name) {
        return this.tupleBuilder.addList(this, name);
    }

    public RepeatedListBuilder addRepeatedList(String name) {
        return this.tupleBuilder.addRepeatedList(this, name);
    }

    public DictBuilder addDict(String name, TypeProtos.MinorType keyType) {
        return this.tupleBuilder.addDict(this, name).key(keyType);
    }

    public DictBuilder addDict(String name, TypeProtos.MajorType keyType) {
        return this.tupleBuilder.addDict(this, name).key(keyType);
    }

    public DictBuilder addDictArray(String name, TypeProtos.MinorType keyType) {
        return this.tupleBuilder.addDictArray(this, name).key(keyType);
    }

    public DictBuilder addDictArray(String name, TypeProtos.MajorType keyType) {
        return this.tupleBuilder.addDictArray(this, name).key(keyType);
    }

    public MapColumnMetadata buildColumn() {
        return new MapColumnMetadata(this.memberName, this.mode, this.tupleBuilder.schema());
    }

    public void build() {
        if (this.parent != null) {
            this.parent.addColumn(this.buildColumn());
        }
    }

    public SchemaBuilder resumeSchema() {
        this.build();
        return (SchemaBuilder)this.parent;
    }

    public MapBuilder resumeMap() {
        this.build();
        return (MapBuilder)this.parent;
    }

    public RepeatedListBuilder resumeList() {
        this.build();
        return (RepeatedListBuilder)this.parent;
    }

    public UnionBuilder resumeUnion() {
        this.build();
        return (UnionBuilder)this.parent;
    }

    public DictBuilder resumeDict() {
        this.build();
        return (DictBuilder)this.parent;
    }
}

