/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.expr;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedFieldExpr;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.fn.FuncHolder;
import oadd.org.apache.drill.common.expression.fn.FunctionReplacementUtils;
import oadd.org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.ComparisonPredicate;
import oadd.org.apache.drill.exec.expr.DrillSimpleFunc;
import oadd.org.apache.drill.exec.expr.IsPredicate;
import oadd.org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import oadd.org.apache.drill.exec.expr.fn.interpreter.InterpreterEvaluator;
import oadd.org.apache.drill.exec.expr.holders.BigIntHolder;
import oadd.org.apache.drill.exec.expr.holders.Float4Holder;
import oadd.org.apache.drill.exec.expr.holders.Float8Holder;
import oadd.org.apache.drill.exec.expr.holders.IntHolder;
import oadd.org.apache.drill.exec.expr.holders.TimeStampHolder;
import oadd.org.apache.drill.exec.expr.holders.ValueHolder;
import oadd.org.apache.drill.exec.vector.ValueHolderHelper;
import oadd.org.apache.drill.metastore.ColumnStatistics;
import oadd.org.apache.drill.metastore.ColumnStatisticsImpl;
import oadd.org.apache.drill.metastore.ColumnStatisticsKind;
import oadd.org.apache.drill.metastore.StatisticsKind;

public class StatisticsProvider<T extends Comparable<T>>
extends AbstractExprVisitor<ColumnStatistics, Void, RuntimeException> {
    private final Map<SchemaPath, ColumnStatistics> columnStatMap;
    private final long rowCount;
    private static final Map<TypeProtos.MinorType, Set<TypeProtos.MinorType>> CAST_FUNC = new EnumMap<TypeProtos.MinorType, Set<TypeProtos.MinorType>>(TypeProtos.MinorType.class);

    public StatisticsProvider(Map<SchemaPath, ColumnStatistics> columnStatMap, long rowCount) {
        this.columnStatMap = columnStatMap;
        this.rowCount = rowCount;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public ColumnStatisticsImpl visitUnknown(LogicalExpression e, Void value) {
        return null;
    }

    @Override
    public ColumnStatistics visitTypedFieldExpr(TypedFieldExpr typedFieldExpr, Void value) {
        ColumnStatistics columnStatistics = this.columnStatMap.get(typedFieldExpr.getPath().getUnIndexed());
        if (columnStatistics != null) {
            return columnStatistics;
        }
        if (typedFieldExpr.getMajorType().equals(Types.OPTIONAL_INT)) {
            MinMaxStatistics<Object> statistics = new MinMaxStatistics<Object>(null, null, Integer::compareTo);
            statistics.setNullsCount(this.rowCount);
            return statistics;
        }
        return null;
    }

    @Override
    public ColumnStatistics<Integer> visitIntConstant(ValueExpressions.IntExpression expr, Void value) {
        int exprValue = expr.getInt();
        return new MinMaxStatistics<Integer>(exprValue, exprValue, Integer::compareTo);
    }

    @Override
    public ColumnStatistics<Boolean> visitBooleanConstant(ValueExpressions.BooleanExpression expr, Void value) {
        boolean exprValue = expr.getBoolean();
        return new MinMaxStatistics<Boolean>(exprValue, exprValue, Boolean::compareTo);
    }

    @Override
    public ColumnStatistics<Long> visitLongConstant(ValueExpressions.LongExpression expr, Void value) {
        long exprValue = expr.getLong();
        return new MinMaxStatistics<Long>(exprValue, exprValue, Long::compareTo);
    }

    @Override
    public ColumnStatistics<Float> visitFloatConstant(ValueExpressions.FloatExpression expr, Void value) {
        float exprValue = expr.getFloat();
        return new MinMaxStatistics<Float>(Float.valueOf(exprValue), Float.valueOf(exprValue), Float::compareTo);
    }

    @Override
    public ColumnStatistics<Double> visitDoubleConstant(ValueExpressions.DoubleExpression expr, Void value) {
        double exprValue = expr.getDouble();
        return new MinMaxStatistics<Double>(exprValue, exprValue, Double::compareTo);
    }

    @Override
    public ColumnStatistics<Long> visitDateConstant(ValueExpressions.DateExpression expr, Void value) {
        long exprValue = expr.getDate();
        return new MinMaxStatistics<Long>(exprValue, exprValue, Long::compareTo);
    }

    @Override
    public ColumnStatistics<Long> visitTimeStampConstant(ValueExpressions.TimeStampExpression tsExpr, Void value) {
        long exprValue = tsExpr.getTimeStamp();
        return new MinMaxStatistics<Long>(exprValue, exprValue, Long::compareTo);
    }

    @Override
    public ColumnStatistics<Integer> visitTimeConstant(ValueExpressions.TimeExpression timeExpr, Void value) {
        int exprValue = timeExpr.getTime();
        return new MinMaxStatistics<Integer>(exprValue, exprValue, Integer::compareTo);
    }

    @Override
    public ColumnStatistics<String> visitQuotedStringConstant(ValueExpressions.QuotedString quotedString, Void value) {
        String binary = quotedString.getString();
        return new MinMaxStatistics<String>(binary, binary, Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    @Override
    public ColumnStatistics<BigInteger> visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, Void value) {
        BigInteger unscaled = decExpr.getBigDecimal().unscaledValue();
        return new MinMaxStatistics<BigInteger>(unscaled, unscaled, Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    @Override
    public ColumnStatistics visitFunctionHolderExpression(FunctionHolderExpression holderExpr, Void value) {
        ColumnStatistics stat;
        FuncHolder funcHolder = holderExpr.getHolder();
        if (!(funcHolder instanceof DrillSimpleFuncHolder)) {
            return null;
        }
        String funcName = ((DrillSimpleFuncHolder)funcHolder).getRegisteredNames()[0];
        if (FunctionReplacementUtils.isCastFunction(funcName) && !IsPredicate.isNullOrEmpty(stat = ((LogicalExpression)holderExpr.args.get(0)).accept(this, null))) {
            return this.evalCastFunc(holderExpr, stat);
        }
        return null;
    }

    private ColumnStatistics<T> evalCastFunc(FunctionHolderExpression holderExpr, ColumnStatistics<T> input) {
        try {
            MinMaxStatistics<Number> statistics;
            ValueHolder maxHolder;
            ValueHolder minHolder;
            DrillSimpleFuncHolder funcHolder = (DrillSimpleFuncHolder)holderExpr.getHolder();
            DrillSimpleFunc interpreter = funcHolder.createInterpreter();
            TypeProtos.MinorType srcType = ((LogicalExpression)holderExpr.args.get(0)).getMajorType().getMinorType();
            TypeProtos.MinorType destType = holderExpr.getMajorType().getMinorType();
            if (srcType.equals(destType)) {
                return input;
            }
            if (!CAST_FUNC.containsKey(srcType) || !CAST_FUNC.get(srcType).contains(destType)) {
                return null;
            }
            switch (srcType) {
                case INT: {
                    minHolder = ValueHolderHelper.getIntHolder((Integer)ComparisonPredicate.getMinValue(input));
                    maxHolder = ValueHolderHelper.getIntHolder((Integer)ComparisonPredicate.getMaxValue(input));
                    break;
                }
                case BIGINT: {
                    minHolder = ValueHolderHelper.getBigIntHolder((Long)ComparisonPredicate.getMinValue(input));
                    maxHolder = ValueHolderHelper.getBigIntHolder((Long)ComparisonPredicate.getMaxValue(input));
                    break;
                }
                case FLOAT4: {
                    minHolder = ValueHolderHelper.getFloat4Holder(((Float)ComparisonPredicate.getMinValue(input)).floatValue());
                    maxHolder = ValueHolderHelper.getFloat4Holder(((Float)ComparisonPredicate.getMaxValue(input)).floatValue());
                    break;
                }
                case FLOAT8: {
                    minHolder = ValueHolderHelper.getFloat8Holder((Double)ComparisonPredicate.getMinValue(input));
                    maxHolder = ValueHolderHelper.getFloat8Holder((Double)ComparisonPredicate.getMaxValue(input));
                    break;
                }
                case DATE: {
                    minHolder = ValueHolderHelper.getDateHolder((Long)ComparisonPredicate.getMinValue(input));
                    maxHolder = ValueHolderHelper.getDateHolder((Long)ComparisonPredicate.getMaxValue(input));
                    break;
                }
                default: {
                    return null;
                }
            }
            Object[] args1 = new ValueHolder[]{minHolder};
            Object[] args2 = new ValueHolder[]{maxHolder};
            ValueHolder minFuncHolder = InterpreterEvaluator.evaluateFunction((DrillSimpleFunc)interpreter, (Object[])args1, (String)holderExpr.getName());
            ValueHolder maxFuncHolder = InterpreterEvaluator.evaluateFunction((DrillSimpleFunc)interpreter, (Object[])args2, (String)holderExpr.getName());
            switch (destType) {
                case INT: {
                    statistics = new MinMaxStatistics<Integer>(((IntHolder)minFuncHolder).value, ((IntHolder)maxFuncHolder).value, Integer::compareTo);
                    break;
                }
                case BIGINT: {
                    statistics = new MinMaxStatistics<Long>(((BigIntHolder)minFuncHolder).value, ((BigIntHolder)maxFuncHolder).value, Long::compareTo);
                    break;
                }
                case FLOAT4: {
                    statistics = new MinMaxStatistics<Float>(Float.valueOf(((Float4Holder)minFuncHolder).value), Float.valueOf(((Float4Holder)maxFuncHolder).value), Float::compareTo);
                    break;
                }
                case FLOAT8: {
                    statistics = new MinMaxStatistics<Double>(((Float8Holder)minFuncHolder).value, ((Float8Holder)maxFuncHolder).value, Double::compareTo);
                    break;
                }
                case TIMESTAMP: {
                    statistics = new MinMaxStatistics<Long>(((TimeStampHolder)minFuncHolder).value, ((TimeStampHolder)maxFuncHolder).value, Long::compareTo);
                    break;
                }
                default: {
                    return null;
                }
            }
            statistics.setNullsCount((Long)input.getStatistic(ColumnStatisticsKind.NULLS_COUNT));
            return statistics;
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Error in evaluating function of " + holderExpr.getName());
        }
    }

    static {
        EnumSet<TypeProtos.MinorType> float4Types = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.FLOAT4, float4Types);
        float4Types.add(TypeProtos.MinorType.FLOAT8);
        float4Types.add(TypeProtos.MinorType.INT);
        float4Types.add(TypeProtos.MinorType.BIGINT);
        EnumSet<TypeProtos.MinorType> float8Types = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.FLOAT8, float8Types);
        float8Types.add(TypeProtos.MinorType.FLOAT4);
        float8Types.add(TypeProtos.MinorType.INT);
        float8Types.add(TypeProtos.MinorType.BIGINT);
        EnumSet<TypeProtos.MinorType> intTypes = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.INT, intTypes);
        intTypes.add(TypeProtos.MinorType.FLOAT4);
        intTypes.add(TypeProtos.MinorType.FLOAT8);
        intTypes.add(TypeProtos.MinorType.BIGINT);
        EnumSet<TypeProtos.MinorType> bigIntTypes = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.BIGINT, bigIntTypes);
        bigIntTypes.add(TypeProtos.MinorType.INT);
        bigIntTypes.add(TypeProtos.MinorType.FLOAT4);
        bigIntTypes.add(TypeProtos.MinorType.FLOAT8);
        EnumSet<TypeProtos.MinorType> dateTypes = EnumSet.noneOf(TypeProtos.MinorType.class);
        CAST_FUNC.put(TypeProtos.MinorType.DATE, dateTypes);
        dateTypes.add(TypeProtos.MinorType.TIMESTAMP);
    }

    public static class MinMaxStatistics<V>
    implements ColumnStatistics<V> {
        private final V minVal;
        private final V maxVal;
        private final Comparator<V> valueComparator;
        private long nullsCount;

        public MinMaxStatistics(V minVal, V maxVal, Comparator<V> valueComparator) {
            this.minVal = minVal;
            this.maxVal = maxVal;
            this.valueComparator = valueComparator;
        }

        @Override
        public Object getStatistic(StatisticsKind statisticsKind) {
            switch (statisticsKind.getName()) {
                case "minValue": {
                    return this.minVal;
                }
                case "maxValue": {
                    return this.maxVal;
                }
                case "nullsCount": {
                    return this.nullsCount;
                }
            }
            return null;
        }

        @Override
        public boolean containsStatistic(StatisticsKind statisticsKind) {
            switch (statisticsKind.getName()) {
                case "minValue": 
                case "maxValue": 
                case "nullsCount": {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean containsExactStatistics(StatisticsKind statisticsKind) {
            return true;
        }

        @Override
        public Comparator<V> getValueComparator() {
            return this.valueComparator;
        }

        @Override
        public ColumnStatistics<V> cloneWithStats(ColumnStatistics statistics) {
            throw new UnsupportedOperationException("MinMaxStatistics does not support cloneWithStats");
        }

        void setNullsCount(long nullsCount) {
            this.nullsCount = nullsCount;
        }
    }
}

