/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.framework.recipes.shared;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import oadd.com.google.common.base.Function;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.WatcherRemoveCuratorFramework;
import oadd.org.apache.curator.framework.api.BackgroundCallback;
import oadd.org.apache.curator.framework.api.BackgroundPathAndBytesable;
import oadd.org.apache.curator.framework.api.BackgroundPathable;
import oadd.org.apache.curator.framework.api.CuratorEvent;
import oadd.org.apache.curator.framework.api.CuratorWatcher;
import oadd.org.apache.curator.framework.api.ErrorListenerPathable;
import oadd.org.apache.curator.framework.api.Pathable;
import oadd.org.apache.curator.framework.api.WatchPathable;
import oadd.org.apache.curator.framework.listen.ListenerContainer;
import oadd.org.apache.curator.framework.recipes.shared.SharedValueListener;
import oadd.org.apache.curator.framework.recipes.shared.SharedValueReader;
import oadd.org.apache.curator.framework.recipes.shared.VersionedValue;
import oadd.org.apache.curator.framework.state.ConnectionState;
import oadd.org.apache.curator.framework.state.ConnectionStateListener;
import oadd.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.curator.shaded.com.google.common.base.Preconditions;
import oadd.org.apache.curator.utils.PathUtils;
import oadd.org.apache.curator.utils.ThreadUtils;
import oadd.org.apache.zookeeper.KeeperException;
import oadd.org.apache.zookeeper.WatchedEvent;
import oadd.org.apache.zookeeper.Watcher;
import oadd.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedValue
implements Closeable,
SharedValueReader {
    private static final int UNINITIALIZED_VERSION = -1;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ListenerContainer<SharedValueListener> listeners = new ListenerContainer();
    private final WatcherRemoveCuratorFramework client;
    private final String path;
    private final byte[] seedValue;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicReference<VersionedValue<byte[]>> currentValue;
    private final CuratorWatcher watcher;
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            SharedValue.this.notifyListenerOfStateChanged(newState);
            if (newState.isConnected()) {
                try {
                    SharedValue.this.readValueAndNotifyListenersInBackground();
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    SharedValue.this.log.error("Could not read value after reconnect", e);
                }
            }
        }
    };
    private final BackgroundCallback upadateAndNotifyListenerCallback = new BackgroundCallback(){

        @Override
        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            if (event.getResultCode() == KeeperException.Code.OK.intValue()) {
                SharedValue.this.updateValue(event.getStat().getVersion(), event.getData());
                SharedValue.this.notifyListeners();
            }
        }
    };

    public SharedValue(CuratorFramework client, String path, byte[] seedValue) {
        this.client = client.newWatcherRemoveCuratorFramework();
        this.path = PathUtils.validatePath(path);
        this.seedValue = Arrays.copyOf(seedValue, seedValue.length);
        this.watcher = new SharedValueCuratorWatcher();
        this.currentValue = new AtomicReference<VersionedValue<byte[]>>(new VersionedValue<byte[]>(-1, Arrays.copyOf(seedValue, seedValue.length)));
    }

    @VisibleForTesting
    protected SharedValue(WatcherRemoveCuratorFramework client, String path, byte[] seedValue, CuratorWatcher watcher) {
        this.client = client;
        this.path = PathUtils.validatePath(path);
        this.seedValue = Arrays.copyOf(seedValue, seedValue.length);
        this.watcher = watcher;
        this.currentValue = new AtomicReference<VersionedValue<byte[]>>(new VersionedValue<byte[]>(-1, Arrays.copyOf(seedValue, seedValue.length)));
    }

    @Override
    public byte[] getValue() {
        VersionedValue<byte[]> localCopy = this.currentValue.get();
        return Arrays.copyOf(localCopy.getValue(), localCopy.getValue().length);
    }

    @Override
    public VersionedValue<byte[]> getVersionedValue() {
        VersionedValue<byte[]> localCopy = this.currentValue.get();
        return new VersionedValue<byte[]>(localCopy.getVersion(), Arrays.copyOf(localCopy.getValue(), localCopy.getValue().length));
    }

    public void setValue(byte[] newValue) throws Exception {
        Preconditions.checkState(this.state.get() == State.STARTED, "not started");
        Stat result = (Stat)this.client.setData().forPath(this.path, newValue);
        this.updateValue(result.getVersion(), Arrays.copyOf(newValue, newValue.length));
    }

    @Deprecated
    public boolean trySetValue(byte[] newValue) throws Exception {
        return this.trySetValue(this.currentValue.get(), newValue);
    }

    public boolean trySetValue(VersionedValue<byte[]> previous, byte[] newValue) throws Exception {
        Preconditions.checkState(this.state.get() == State.STARTED, "not started");
        VersionedValue<byte[]> current = this.currentValue.get();
        if (previous.getVersion() != current.getVersion() || !Arrays.equals(previous.getValue(), current.getValue())) {
            return false;
        }
        try {
            Stat result = (Stat)((BackgroundPathAndBytesable)this.client.setData().withVersion(previous.getVersion())).forPath(this.path, newValue);
            this.updateValue(result.getVersion(), Arrays.copyOf(newValue, newValue.length));
            return true;
        }
        catch (KeeperException.BadVersionException badVersionException) {
            this.readValue();
            return false;
        }
    }

    private void updateValue(int version, byte[] bytes) {
        VersionedValue<byte[]> current;
        do {
            if ((current = this.currentValue.get()).getVersion() < version) continue;
            return;
        } while (!this.currentValue.compareAndSet(current, new VersionedValue<byte[]>(version, bytes)));
    }

    @Override
    public ListenerContainer<SharedValueListener> getListenable() {
        return this.listeners;
    }

    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        try {
            this.client.create().creatingParentContainersIfNeeded().forPath(this.path, this.seedValue);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        this.readValue();
    }

    @Override
    public void close() throws IOException {
        this.state.set(State.CLOSED);
        this.client.removeWatchers();
        this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
        this.listeners.clear();
    }

    private void readValue() throws Exception {
        Stat localStat = new Stat();
        byte[] bytes = (byte[])((Pathable)((WatchPathable)this.client.getData().storingStatIn(localStat)).usingWatcher(this.watcher)).forPath(this.path);
        this.updateValue(localStat.getVersion(), bytes);
    }

    private void readValueAndNotifyListenersInBackground() throws Exception {
        ((ErrorListenerPathable)((BackgroundPathable)this.client.getData().usingWatcher(this.watcher)).inBackground(this.upadateAndNotifyListenerCallback)).forPath(this.path);
    }

    private void notifyListeners() {
        final byte[] localValue = this.getValue();
        this.listeners.forEach(new Function<SharedValueListener, Void>(){

            @Override
            public Void apply(SharedValueListener listener) {
                try {
                    listener.valueHasChanged(SharedValue.this, localValue);
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    SharedValue.this.log.error("From SharedValue listener", e);
                }
                return null;
            }
        });
    }

    private void notifyListenerOfStateChanged(final ConnectionState newState) {
        this.listeners.forEach(new Function<SharedValueListener, Void>(){

            @Override
            public Void apply(SharedValueListener listener) {
                listener.stateChanged(SharedValue.this.client, newState);
                return null;
            }
        });
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }

    private class SharedValueCuratorWatcher
    implements CuratorWatcher {
        private SharedValueCuratorWatcher() {
        }

        @Override
        public void process(WatchedEvent event) throws Exception {
            if (SharedValue.this.state.get() == State.STARTED && event.getType() != Watcher.Event.EventType.None) {
                SharedValue.this.readValueAndNotifyListenersInBackground();
            }
        }
    }
}

