/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator.framework.recipes.queue;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import oadd.org.apache.curator.framework.CuratorFramework;
import oadd.org.apache.curator.framework.listen.ListenerContainer;
import oadd.org.apache.curator.framework.recipes.queue.DistributedQueue;
import oadd.org.apache.curator.framework.recipes.queue.ErrorMode;
import oadd.org.apache.curator.framework.recipes.queue.MultiItem;
import oadd.org.apache.curator.framework.recipes.queue.QueueBase;
import oadd.org.apache.curator.framework.recipes.queue.QueueConsumer;
import oadd.org.apache.curator.framework.recipes.queue.QueuePutListener;
import oadd.org.apache.curator.framework.recipes.queue.QueueSerializer;
import oadd.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import oadd.org.apache.curator.shaded.com.google.common.base.Preconditions;

public class DistributedDelayQueue<T>
implements Closeable,
QueueBase<T> {
    private final DistributedQueue<T> queue;
    private static final char SEPARATOR = '|';

    DistributedDelayQueue(CuratorFramework client, QueueConsumer<T> consumer, QueueSerializer<T> serializer, String queuePath, ThreadFactory threadFactory, Executor executor, int minItemsBeforeRefresh, String lockPath, int maxItems, boolean putInBackground, int finalFlushMs) {
        Preconditions.checkArgument(minItemsBeforeRefresh >= 0, "minItemsBeforeRefresh cannot be negative");
        this.queue = new DistributedQueue<T>(client, consumer, serializer, queuePath, threadFactory, executor, minItemsBeforeRefresh, true, lockPath, maxItems, putInBackground, finalFlushMs){

            @Override
            protected long getDelay(String itemNode) {
                return this.getDelay(itemNode, System.currentTimeMillis());
            }

            private long getDelay(String itemNode, long sortTime) {
                long epoch = DistributedDelayQueue.getEpoch(itemNode);
                return epoch - sortTime;
            }

            @Override
            protected void sortChildren(List<String> children) {
                final long sortTime = System.currentTimeMillis();
                Collections.sort(children, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        long diff = this.getDelay(o1, sortTime) - this.getDelay(o2, sortTime);
                        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
                    }
                });
            }
        };
    }

    @Override
    public void start() throws Exception {
        this.queue.start();
    }

    @Override
    public void close() throws IOException {
        this.queue.close();
    }

    public void put(T item, long delayUntilEpoch) throws Exception {
        this.put(item, delayUntilEpoch, 0, null);
    }

    public boolean put(T item, long delayUntilEpoch, int maxWait, TimeUnit unit) throws Exception {
        Preconditions.checkArgument(delayUntilEpoch > 0L, "delayUntilEpoch cannot be negative");
        this.queue.checkState();
        return this.queue.internalPut(item, null, this.queue.makeItemPath() + DistributedDelayQueue.epochToString(delayUntilEpoch), maxWait, unit);
    }

    public void putMulti(MultiItem<T> items, long delayUntilEpoch) throws Exception {
        this.putMulti(items, delayUntilEpoch, 0, null);
    }

    public boolean putMulti(MultiItem<T> items, long delayUntilEpoch, int maxWait, TimeUnit unit) throws Exception {
        Preconditions.checkArgument(delayUntilEpoch > 0L, "delayUntilEpoch cannot be negative");
        this.queue.checkState();
        return this.queue.internalPut(null, items, this.queue.makeItemPath() + DistributedDelayQueue.epochToString(delayUntilEpoch), maxWait, unit);
    }

    @Override
    public void setErrorMode(ErrorMode newErrorMode) {
        this.queue.setErrorMode(newErrorMode);
    }

    @Override
    public boolean flushPuts(long waitTime, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.flushPuts(waitTime, timeUnit);
    }

    @Override
    public ListenerContainer<QueuePutListener<T>> getPutListenerContainer() {
        return this.queue.getPutListenerContainer();
    }

    @Override
    public int getLastMessageCount() {
        return this.queue.getLastMessageCount();
    }

    @VisibleForTesting
    static String epochToString(long epoch) {
        return '|' + String.format("%08X", epoch) + '|';
    }

    private static long getEpoch(String itemNode) {
        int index1;
        int index2 = itemNode.lastIndexOf(124);
        int n = index1 = index2 > 0 ? itemNode.lastIndexOf(124, index2 - 1) : -1;
        if (index1 > 0 && index2 > index1 + 1) {
            try {
                String epochStr = itemNode.substring(index1 + 1, index2);
                return Long.parseLong(epochStr, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }
}

