/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.dbcp2.cpdsadapter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oadd.org.apache.commons.dbcp2.DelegatingPreparedStatement;
import oadd.org.apache.commons.dbcp2.PStmtKey;
import oadd.org.apache.commons.dbcp2.Utils;
import oadd.org.apache.commons.dbcp2.cpdsadapter.PooledConnectionImpl;
import oadd.org.apache.commons.pool2.KeyedObjectPool;
import oadd.org.apache.commons.pool2.KeyedPooledObjectFactory;
import oadd.org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import oadd.org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

public class DriverAdapterCPDS
implements ConnectionPoolDataSource,
Referenceable,
Serializable,
ObjectFactory {
    private static final String KEY_USER = "user";
    private static final String KEY_PASSWORD = "password";
    private static final long serialVersionUID = -4820523787212147844L;
    private static final String GET_CONNECTION_CALLED = "A PooledConnection was already requested from this source, further initialization is not allowed.";
    private String description;
    private String url;
    private String userName;
    private char[] userPassword;
    private String driver;
    private int loginTimeout;
    private transient PrintWriter logWriter;
    private boolean poolPreparedStatements;
    private int maxIdle = 10;
    private long timeBetweenEvictionRunsMillis = -1L;
    private int numTestsPerEvictionRun = -1;
    private int minEvictableIdleTimeMillis = -1;
    private int maxPreparedStatements = -1;
    private volatile boolean getConnectionCalled;
    private Properties connectionProperties;
    private boolean accessToUnderlyingConnectionAllowed;

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.getUser(), this.getPassword());
    }

    @Override
    public PooledConnection getPooledConnection(String pooledUserName, String pooledUserPassword) throws SQLException {
        this.getConnectionCalled = true;
        PooledConnectionImpl pooledConnection = null;
        try {
            if (this.connectionProperties != null) {
                this.update(this.connectionProperties, KEY_USER, pooledUserName);
                this.update(this.connectionProperties, KEY_PASSWORD, pooledUserPassword);
                pooledConnection = new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), this.connectionProperties));
            } else {
                pooledConnection = new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), pooledUserName, pooledUserPassword));
            }
            pooledConnection.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        }
        catch (ClassCircularityError e) {
            pooledConnection = this.connectionProperties != null ? new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), this.connectionProperties)) : new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), pooledUserName, pooledUserPassword));
            pooledConnection.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        }
        GenericKeyedObjectPool stmtPool = null;
        if (this.isPoolPreparedStatements()) {
            GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
            config.setMaxTotalPerKey(Integer.MAX_VALUE);
            config.setBlockWhenExhausted(false);
            config.setMaxWaitMillis(0L);
            config.setMaxIdlePerKey(this.getMaxIdle());
            if (this.getMaxPreparedStatements() <= 0) {
                config.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
                config.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
                config.setMinEvictableIdleTimeMillis((long)this.getMinEvictableIdleTimeMillis());
            } else {
                config.setMaxTotal(this.getMaxPreparedStatements());
                config.setTimeBetweenEvictionRunsMillis(-1L);
                config.setNumTestsPerEvictionRun(0);
                config.setMinEvictableIdleTimeMillis(0L);
            }
            stmtPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)pooledConnection, config);
            pooledConnection.setStatementPool((KeyedObjectPool<PStmtKey, DelegatingPreparedStatement>)stmtPool);
        }
        return pooledConnection;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reference getReference() throws NamingException {
        String factory = this.getClass().getName();
        Reference ref = new Reference(this.getClass().getName(), factory, null);
        ref.add(new StringRefAddr("description", this.getDescription()));
        ref.add(new StringRefAddr("driver", this.getDriver()));
        ref.add(new StringRefAddr("loginTimeout", String.valueOf(this.getLoginTimeout())));
        ref.add(new StringRefAddr(KEY_PASSWORD, this.getPassword()));
        ref.add(new StringRefAddr(KEY_USER, this.getUser()));
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("poolPreparedStatements", String.valueOf(this.isPoolPreparedStatements())));
        ref.add(new StringRefAddr("maxIdle", String.valueOf(this.getMaxIdle())));
        ref.add(new StringRefAddr("timeBetweenEvictionRunsMillis", String.valueOf(this.getTimeBetweenEvictionRunsMillis())));
        ref.add(new StringRefAddr("numTestsPerEvictionRun", String.valueOf(this.getNumTestsPerEvictionRun())));
        ref.add(new StringRefAddr("minEvictableIdleTimeMillis", String.valueOf(this.getMinEvictableIdleTimeMillis())));
        ref.add(new StringRefAddr("maxPreparedStatements", String.valueOf(this.getMaxPreparedStatements())));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable<?, ?> env) throws Exception {
        Reference ref;
        DriverAdapterCPDS cpds = null;
        if (refObj instanceof Reference && (ref = (Reference)refObj).getClassName().equals(this.getClass().getName())) {
            RefAddr ra = ref.get("description");
            if (ra != null && ra.getContent() != null) {
                this.setDescription(ra.getContent().toString());
            }
            if ((ra = ref.get("driver")) != null && ra.getContent() != null) {
                this.setDriver(ra.getContent().toString());
            }
            if ((ra = ref.get("url")) != null && ra.getContent() != null) {
                this.setUrl(ra.getContent().toString());
            }
            if ((ra = ref.get(KEY_USER)) != null && ra.getContent() != null) {
                this.setUser(ra.getContent().toString());
            }
            if ((ra = ref.get(KEY_PASSWORD)) != null && ra.getContent() != null) {
                this.setPassword(ra.getContent().toString());
            }
            if ((ra = ref.get("poolPreparedStatements")) != null && ra.getContent() != null) {
                this.setPoolPreparedStatements(Boolean.valueOf(ra.getContent().toString()));
            }
            if ((ra = ref.get("maxIdle")) != null && ra.getContent() != null) {
                this.setMaxIdle(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("timeBetweenEvictionRunsMillis")) != null && ra.getContent() != null) {
                this.setTimeBetweenEvictionRunsMillis(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("numTestsPerEvictionRun")) != null && ra.getContent() != null) {
                this.setNumTestsPerEvictionRun(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("minEvictableIdleTimeMillis")) != null && ra.getContent() != null) {
                this.setMinEvictableIdleTimeMillis(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("maxPreparedStatements")) != null && ra.getContent() != null) {
                this.setMaxPreparedStatements(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("accessToUnderlyingConnectionAllowed")) != null && ra.getContent() != null) {
                this.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(ra.getContent().toString()));
            }
            cpds = this;
        }
        return cpds;
    }

    private void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(Properties props) {
        this.assertInitializationAllowed();
        this.connectionProperties = props;
        if (this.connectionProperties != null) {
            if (this.connectionProperties.containsKey(KEY_USER)) {
                this.setUser(this.connectionProperties.getProperty(KEY_USER));
            }
            if (this.connectionProperties.containsKey(KEY_PASSWORD)) {
                this.setPassword(this.connectionProperties.getProperty(KEY_PASSWORD));
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    public char[] getPasswordCharArray() {
        return this.userPassword;
    }

    public String getPassword() {
        return Utils.toString(this.userPassword);
    }

    public void setPassword(char[] userPassword) {
        this.assertInitializationAllowed();
        this.userPassword = userPassword;
        this.update(this.connectionProperties, KEY_PASSWORD, Utils.toString(userPassword));
    }

    public void setPassword(String userPassword) {
        this.assertInitializationAllowed();
        this.userPassword = Utils.toCharArray(userPassword);
        this.update(this.connectionProperties, KEY_PASSWORD, userPassword);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String v) {
        this.assertInitializationAllowed();
        this.url = v;
    }

    public String getUser() {
        return this.userName;
    }

    public void setUser(String v) {
        this.assertInitializationAllowed();
        this.userName = v;
        this.update(this.connectionProperties, KEY_USER, v);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String v) throws ClassNotFoundException {
        this.assertInitializationAllowed();
        this.driver = v;
        Class.forName(v);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean poolPreparedStatements) {
        this.assertInitializationAllowed();
        this.poolPreparedStatements = poolPreparedStatements;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.assertInitializationAllowed();
        this.maxIdle = maxIdle;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.assertInitializationAllowed();
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.assertInitializationAllowed();
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }

    public int getMaxPreparedStatements() {
        return this.maxPreparedStatements;
    }

    public void setMaxPreparedStatements(int maxPreparedStatements) {
        this.maxPreparedStatements = maxPreparedStatements;
    }

    private void update(Properties properties, String key, String value) {
        if (properties != null) {
            if (value == null) {
                properties.remove(key);
            } else {
                properties.setProperty(key, value);
            }
        }
    }

    static {
        DriverManager.getDrivers();
    }
}

