/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.dbcp2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import oadd.org.apache.commons.dbcp2.DelegatingConnection;
import oadd.org.apache.commons.dbcp2.DelegatingPreparedStatement;
import oadd.org.apache.commons.dbcp2.PStmtKey;
import oadd.org.apache.commons.dbcp2.PoolableCallableStatement;
import oadd.org.apache.commons.dbcp2.PoolablePreparedStatement;
import oadd.org.apache.commons.pool2.KeyedObjectPool;
import oadd.org.apache.commons.pool2.KeyedPooledObjectFactory;
import oadd.org.apache.commons.pool2.PooledObject;
import oadd.org.apache.commons.pool2.impl.DefaultPooledObject;

public class PoolingConnection
extends DelegatingConnection<Connection>
implements KeyedPooledObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    private KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pstmtPool;

    public PoolingConnection(Connection connection) {
        super(connection);
    }

    public void activateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws Exception {
        ((DelegatingPreparedStatement)pooledObject.getObject()).activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        block11: {
            try {
                if (null == this.pstmtPool) break block11;
                KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> oldpool = this.pstmtPool;
                this.pstmtPool = null;
                try {
                    oldpool.close();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLException("Cannot close connection", e);
                }
            }
            finally {
                try {
                    this.getDelegateInternal().close();
                }
                finally {
                    this.setClosedInternal(true);
                }
            }
        }
    }

    protected PStmtKey createKey(String sql) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull());
    }

    protected PStmtKey createKey(String sql, int[] columnIndexes) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), columnIndexes);
    }

    protected PStmtKey createKey(String sql, int autoGeneratedKeys) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), autoGeneratedKeys);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, resultSetHoldability, statementType);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, statementType);
    }

    protected PStmtKey createKey(String sql, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), statementType, null);
    }

    protected PStmtKey createKey(String sql, String[] columnNames) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), columnNames);
    }

    public void destroyObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws Exception {
        ((DelegatingPreparedStatement)pooledObject.getObject()).getInnermostDelegate().close();
    }

    private String getCatalogOrNull() {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return catalog;
    }

    private String getSchemaOrNull() {
        String catalog = null;
        try {
            catalog = this.getSchema();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return catalog;
    }

    public PooledObject<DelegatingPreparedStatement> makeObject(PStmtKey key) throws Exception {
        if (null == key) {
            throw new IllegalArgumentException("Prepared statement key is null or invalid.");
        }
        if (key.getStmtType() == StatementType.PREPARED_STATEMENT) {
            PreparedStatement statement = (PreparedStatement)key.createStatement((Connection)this.getDelegate());
            PoolablePreparedStatement<PStmtKey> pps = new PoolablePreparedStatement<PStmtKey>(statement, key, this.pstmtPool, this);
            return new DefaultPooledObject(pps);
        }
        CallableStatement statement = (CallableStatement)key.createStatement((Connection)this.getDelegate());
        PoolableCallableStatement pcs = new PoolableCallableStatement(statement, key, this.pstmtPool, this);
        return new DefaultPooledObject((Object)pcs);
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    public void passivateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) throws Exception {
        DelegatingPreparedStatement dps = (DelegatingPreparedStatement)pooledObject.getObject();
        dps.clearParameters();
        dps.passivate();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return (CallableStatement)this.pstmtPool.borrowObject((Object)this.createKey(sql, StatementType.CALLABLE_STATEMENT));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return (CallableStatement)this.pstmtPool.borrowObject((Object)this.createKey(sql, resultSetType, resultSetConcurrency, StatementType.CALLABLE_STATEMENT));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return (CallableStatement)this.pstmtPool.borrowObject((Object)this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability, StatementType.CALLABLE_STATEMENT));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject((Object)this.createKey(sql));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject((Object)this.createKey(sql, autoGeneratedKeys));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject((Object)this.createKey(sql, columnIndexes));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject((Object)this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject((Object)this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (null == this.pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return (PreparedStatement)this.pstmtPool.borrowObject((Object)this.createKey(sql, columnNames));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    public void setStatementPool(KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pool) {
        this.pstmtPool = pool;
    }

    @Override
    public String toString() {
        if (this.pstmtPool != null) {
            return "PoolingConnection: " + this.pstmtPool.toString();
        }
        return "PoolingConnection: null";
    }

    public boolean validateObject(PStmtKey key, PooledObject<DelegatingPreparedStatement> pooledObject) {
        return true;
    }

    public static enum StatementType {
        CALLABLE_STATEMENT,
        PREPARED_STATEMENT;

    }
}

