/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.configuration.beanutils;

import java.util.ArrayList;
import java.util.Iterator;
import oadd.org.apache.commons.beanutils.DynaBean;
import oadd.org.apache.commons.beanutils.DynaClass;
import oadd.org.apache.commons.beanutils.DynaProperty;
import oadd.org.apache.commons.configuration.Configuration;
import oadd.org.apache.commons.configuration.beanutils.ConfigurationDynaBean;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;

public class ConfigurationDynaClass
implements DynaClass {
    private static Log log = LogFactory.getLog(ConfigurationDynaClass.class);
    private Configuration configuration;

    public ConfigurationDynaClass(Configuration configuration) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("ConfigurationDynaClass(" + configuration + ")"));
        }
        this.configuration = configuration;
    }

    public DynaProperty getDynaProperty(String name) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getDynaProperty(" + name + ")"));
        }
        if (name == null) {
            throw new IllegalArgumentException("Property name must not be null!");
        }
        Object value = this.configuration.getProperty(name);
        if (value == null) {
            return null;
        }
        Class<Object> type = value.getClass();
        if (type == Byte.class) {
            type = Byte.TYPE;
        }
        if (type == Character.class) {
            type = Character.TYPE;
        } else if (type == Boolean.class) {
            type = Boolean.TYPE;
        } else if (type == Double.class) {
            type = Double.TYPE;
        } else if (type == Float.class) {
            type = Float.TYPE;
        } else if (type == Integer.class) {
            type = Integer.TYPE;
        } else if (type == Long.class) {
            type = Long.TYPE;
        } else if (type == Short.class) {
            type = Short.TYPE;
        }
        return new DynaProperty(name, type);
    }

    public DynaProperty[] getDynaProperties() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"getDynaProperties()");
        }
        Iterator<String> keys = this.configuration.getKeys();
        ArrayList<DynaProperty> properties = new ArrayList<DynaProperty>();
        while (keys.hasNext()) {
            String key = keys.next();
            DynaProperty property = this.getDynaProperty(key);
            properties.add(property);
        }
        DynaProperty[] propertyArray = new DynaProperty[properties.size()];
        properties.toArray(propertyArray);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + properties.size() + " properties."));
        }
        return propertyArray;
    }

    public String getName() {
        return ConfigurationDynaBean.class.getName();
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return new ConfigurationDynaBean(this.configuration);
    }
}

