/*
 * Decompiled with CFR 0.152.
 */
package fr.bmartel.pcapdecoder.structure.options.impl;

import fr.bmartel.pcapdecoder.network.NetworkUtils;
import fr.bmartel.pcapdecoder.structure.options.abstr.OptionsAbstr;
import fr.bmartel.pcapdecoder.structure.options.inter.IOptions;
import fr.bmartel.pcapdecoder.structure.options.object.OptionInterfaceDescriptionObject;
import fr.bmartel.pcapdecoder.utils.UtilFunctions;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class OptionsInterfaceDescriptionHeader
extends OptionsAbstr {
    private OptionInterfaceDescriptionObject commonObject = null;

    public OptionsInterfaceDescriptionHeader(int optionCode, byte[] data, boolean isBigEndian, IOptions currentOption) {
        super(optionCode, data, isBigEndian, currentOption);
        this.commonObject = (OptionInterfaceDescriptionObject)currentOption;
        this.decode();
    }

    public void decode() {
        try {
            switch (this.optionCode) {
                case 1: {
                    if (!this.isBigEndian) {
                        this.commonObject.setComment(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setComment(new String(this.data, "UTF-8"));
                    break;
                }
                case 2: {
                    if (!this.isBigEndian) {
                        this.commonObject.setInterfaceName(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setInterfaceName(new String(this.data, "UTF-8"));
                    break;
                }
                case 3: {
                    if (!this.isBigEndian) {
                        this.commonObject.setInterfaceDescription(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setInterfaceDescription(new String(this.data, "UTF-8"));
                    break;
                }
                case 4: {
                    byte[] interfaceAddr = new byte[4];
                    byte[] netmask = new byte[4];
                    if (!this.isBigEndian) {
                        interfaceAddr = UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 4));
                        netmask = UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 4, 8));
                    } else {
                        interfaceAddr = Arrays.copyOfRange(this.data, 0, 4);
                        netmask = Arrays.copyOfRange(this.data, 4, 8);
                    }
                    this.commonObject.setInterfaceIpv4NetworkAddr(NetworkUtils.formatIpv4Addr(interfaceAddr));
                    this.commonObject.setInterfaceNetmask(NetworkUtils.formatIpv4Addr(netmask));
                    break;
                }
                case 5: {
                    byte[] interfaceIpv6Addr = new byte[17];
                    interfaceIpv6Addr = !this.isBigEndian ? UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 17)) : Arrays.copyOfRange(this.data, 0, 17);
                    this.commonObject.setInterfaceIpv6NetworkAddr(NetworkUtils.formatIpv6AddrWithPort(interfaceIpv6Addr));
                    break;
                }
                case 6: {
                    byte[] macAddr = new byte[6];
                    macAddr = !this.isBigEndian ? UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 6)) : Arrays.copyOfRange(this.data, 0, 6);
                    this.commonObject.setInterfaceMacAddr(NetworkUtils.formatMacAddr(macAddr));
                    break;
                }
                case 7: {
                    byte[] euiAddr = new byte[8];
                    euiAddr = !this.isBigEndian ? UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8)) : Arrays.copyOfRange(this.data, 0, 8);
                    this.commonObject.setInterfaceEuiAddr(NetworkUtils.formatMacAddr(euiAddr));
                    break;
                }
                case 8: {
                    byte[] speed = new byte[8];
                    speed = !this.isBigEndian ? UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8)) : Arrays.copyOfRange(this.data, 0, 8);
                    this.commonObject.setInterfaceSpeed(UtilFunctions.convertByteArrayToInt(speed));
                    break;
                }
                case 9: {
                    byte timeResolution = 0;
                    timeResolution = this.data[0];
                    this.commonObject.setTimestampResolution(timeResolution & 0xFF);
                    break;
                }
                case 10: {
                    byte[] biasTime = new byte[8];
                    biasTime = !this.isBigEndian ? UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 4)) : Arrays.copyOfRange(this.data, 0, 4);
                    this.commonObject.setTimeBias(UtilFunctions.convertByteArrayToInt(biasTime));
                    break;
                }
                case 11: {
                    if (!this.isBigEndian) {
                        this.commonObject.setInterfaceFilter(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setInterfaceFilter(new String(this.data, "UTF-8"));
                    break;
                }
                case 12: {
                    if (!this.isBigEndian) {
                        this.commonObject.setInterfaceOperatingSystem(new String(UtilFunctions.convertLeToBe(this.data), "UTF-8"));
                        break;
                    }
                    this.commonObject.setInterfaceOperatingSystem(new String(this.data, "UTF-8"));
                    break;
                }
                case 13: {
                    this.commonObject.setInterfaceFrameCheckSequenceLength(this.data[0] & 0xFF);
                    break;
                }
                case 14: {
                    byte[] offsetTime = new byte[8];
                    offsetTime = !this.isBigEndian ? UtilFunctions.convertLeToBe(Arrays.copyOfRange(this.data, 0, 8)) : Arrays.copyOfRange(this.data, 0, 8);
                    this.commonObject.setPacketOffsetTime(UtilFunctions.convertByteArrayToInt(offsetTime));
                    break;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

