/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.sampling;

import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRegion;
import com.yahoo.memory.NativeMemory;
import com.yahoo.sketches.ArrayOfItemsSerDe;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.sampling.PreambleUtil;
import com.yahoo.sketches.sampling.ReservoirItemsSketch;
import com.yahoo.sketches.sampling.SamplingUtil;
import com.yahoo.sketches.sampling.VersionConverter;
import java.util.ArrayList;

public final class ReservoirItemsUnion<T> {
    private ReservoirItemsSketch<T> gadget_;
    private final int maxK_;

    private ReservoirItemsUnion(int maxK) {
        this.maxK_ = maxK;
    }

    public static <T> ReservoirItemsUnion<T> getInstance(int maxK) {
        return new ReservoirItemsUnion<T>(maxK);
    }

    public static <T> ReservoirItemsUnion<T> getInstance(Memory srcMem, ArrayOfItemsSerDe<T> serDe) {
        int maxK;
        boolean isEmpty;
        int serVer;
        int numPreLongs;
        Family.RESERVOIR_UNION.checkFamilyID(srcMem.getByte(2L));
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            numPreLongs = srcMem.getByte(0L) & 0x3F;
            serVer = srcMem.getByte(1L) & 0xFF;
            isEmpty = (srcMem.getInt(3L) & 4) != 0;
            maxK = srcMem.getInt(4L);
        } else {
            Object memObj = srcMem.array();
            long memAddr = srcMem.getCumulativeOffset(0L);
            numPreLongs = PreambleUtil.extractPreLongs(memObj, memAddr);
            serVer = PreambleUtil.extractSerVer(memObj, memAddr);
            isEmpty = (PreambleUtil.extractFlags(memObj, memAddr) & 4) != 0;
            maxK = PreambleUtil.extractMaxK(memObj, memAddr);
        }
        boolean preLongsEqMin = numPreLongs == Family.RESERVOIR_UNION.getMinPreLongs();
        boolean preLongsEqMax = numPreLongs == Family.RESERVOIR_UNION.getMaxPreLongs();
        if (!preLongsEqMin & !preLongsEqMax) {
            throw new SketchesArgumentException("Possible corruption: Non-empty union with only " + Family.RESERVOIR_UNION.getMinPreLongs() + "preLongs");
        }
        if (serVer != 2) {
            if (serVer == 1) {
                srcMem = VersionConverter.convertUnion1to2(srcMem);
                maxK = PreambleUtil.extractMaxK(srcMem.array(), srcMem.getCumulativeOffset(0L));
            } else {
                throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 2: " + serVer);
            }
        }
        ReservoirItemsUnion<T> riu = new ReservoirItemsUnion<T>(maxK);
        if (!isEmpty) {
            int preLongBytes = numPreLongs << 3;
            MemoryRegion sketchMem = new MemoryRegion(srcMem, preLongBytes, srcMem.getCapacity() - (long)preLongBytes);
            riu.update(srcMem.isReadOnly() ? sketchMem.asReadOnlyMemory() : sketchMem, serDe);
        }
        return riu;
    }

    public int getMaxK() {
        return this.maxK_;
    }

    public void update(ReservoirItemsSketch<T> sketchIn) {
        boolean isModifiable;
        if (sketchIn == null) {
            return;
        }
        ReservoirItemsSketch<T> ris = sketchIn.getK() <= this.maxK_ ? sketchIn : sketchIn.downsampledCopy(this.maxK_);
        boolean bl = isModifiable = sketchIn != ris;
        if (this.gadget_ == null) {
            this.createNewGadget(ris, isModifiable);
        } else {
            this.twoWayMergeInternal(ris, isModifiable);
        }
    }

    public void update(Memory mem, ArrayOfItemsSerDe<T> serDe) {
        if (mem == null) {
            return;
        }
        ReservoirItemsSketch<T> ris = ReservoirItemsSketch.getInstance(mem, serDe);
        ReservoirItemsSketch<T> reservoirItemsSketch = ris = ris.getK() <= this.maxK_ ? ris : ris.downsampledCopy(this.maxK_);
        if (this.gadget_ == null) {
            this.createNewGadget(ris, true);
        } else {
            this.twoWayMergeInternal(ris, true);
        }
    }

    public void update(T datum) {
        if (datum == null) {
            return;
        }
        if (this.gadget_ == null) {
            this.gadget_ = ReservoirItemsSketch.getInstance(this.maxK_);
        }
        this.gadget_.update(datum);
    }

    public void update(long n, int k, ArrayList<T> input) {
        ReservoirItemsSketch<T> ris = ReservoirItemsSketch.getInstance(input, n, ResizeFactor.X8, k);
        ReservoirItemsSketch<T> reservoirItemsSketch = ris = ris.getK() <= this.maxK_ ? ris : ris.downsampledCopy(this.maxK_);
        if (this.gadget_ == null) {
            this.createNewGadget(ris, true);
        } else {
            this.twoWayMergeInternal(ris, true);
        }
    }

    public ReservoirItemsSketch<T> getResult() {
        return this.gadget_ != null ? this.gadget_.copy() : null;
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe) {
        if (this.gadget_ == null || this.gadget_.getNumSamples() == 0) {
            return this.toByteArray(serDe, null);
        }
        return this.toByteArray(serDe, this.gadget_.getValueAtPosition(0).getClass());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append(Util.LS);
        sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("   Max k: ").append(this.maxK_).append(Util.LS);
        if (this.gadget_ == null) {
            sb.append("   Gadget is null").append(Util.LS);
        } else {
            sb.append("   Gadget summary: ").append(this.gadget_.toString());
        }
        sb.append("### END UNION SUMMARY").append(Util.LS);
        return sb.toString();
    }

    public byte[] toByteArray(ArrayOfItemsSerDe<T> serDe, Class<?> clazz) {
        int outBytes;
        int preLongs;
        byte[] gadgetBytes;
        boolean empty = this.gadget_ == null;
        byte[] byArray = gadgetBytes = this.gadget_ != null ? this.gadget_.toByteArray(serDe, clazz) : null;
        if (empty) {
            preLongs = Family.RESERVOIR_UNION.getMinPreLongs();
            outBytes = 8;
        } else {
            preLongs = Family.RESERVOIR_UNION.getMaxPreLongs();
            outBytes = (preLongs << 3) + gadgetBytes.length;
        }
        byte[] outArr = new byte[outBytes];
        NativeMemory mem = new NativeMemory(outArr);
        Object memObj = mem.array();
        long memAddr = mem.getCumulativeOffset(0L);
        PreambleUtil.insertPreLongs(memObj, memAddr, preLongs);
        PreambleUtil.insertSerVer(memObj, memAddr, 2);
        PreambleUtil.insertFamilyID(memObj, memAddr, Family.RESERVOIR_UNION.getID());
        if (empty) {
            PreambleUtil.insertFlags(memObj, memAddr, 4);
        } else {
            PreambleUtil.insertFlags(memObj, memAddr, 0);
        }
        PreambleUtil.insertMaxK(memObj, memAddr, this.maxK_);
        if (!empty) {
            int preBytes = preLongs << 3;
            mem.putByteArray(preBytes, gadgetBytes, 0, gadgetBytes.length);
        }
        return outArr;
    }

    private void createNewGadget(ReservoirItemsSketch<T> sketchIn, boolean isModifiable) {
        if (sketchIn.getK() < this.maxK_ && sketchIn.getN() <= (long)sketchIn.getK()) {
            this.gadget_ = ReservoirItemsSketch.getInstance(this.maxK_);
            this.twoWayMergeInternal(sketchIn, isModifiable);
        } else {
            this.gadget_ = isModifiable ? sketchIn : sketchIn.copy();
        }
    }

    private void twoWayMergeInternal(ReservoirItemsSketch<T> sketchIn, boolean isModifiable) {
        if (sketchIn.getN() <= (long)sketchIn.getK()) {
            this.twoWayMergeInternalStandard(sketchIn);
        } else if (this.gadget_.getN() < (long)this.gadget_.getK()) {
            ReservoirItemsSketch<T> tmpSketch = this.gadget_;
            this.gadget_ = isModifiable ? sketchIn : sketchIn.copy();
            this.twoWayMergeInternalStandard(tmpSketch);
        } else if (sketchIn.getImplicitSampleWeight() < (double)this.gadget_.getN() / (double)(this.gadget_.getK() - 1)) {
            this.twoWayMergeInternalWeighted(sketchIn);
        } else {
            ReservoirItemsSketch<T> tmpSketch = this.gadget_;
            this.gadget_ = isModifiable ? sketchIn : sketchIn.copy();
            this.twoWayMergeInternalWeighted(tmpSketch);
        }
    }

    private void twoWayMergeInternalStandard(ReservoirItemsSketch<T> source) {
        assert (source.getN() <= (long)source.getK());
        int numInputSamples = source.getNumSamples();
        for (int i = 0; i < numInputSamples; ++i) {
            this.gadget_.update(source.getValueAtPosition(i));
        }
    }

    private void twoWayMergeInternalWeighted(ReservoirItemsSketch<T> source) {
        assert (this.gadget_.getN() >= (long)this.gadget_.getK());
        int numSourceSamples = source.getK();
        double sourceItemWeight = (double)source.getN() / (double)numSourceSamples;
        double rescaled_prob = (double)this.gadget_.getK() * sourceItemWeight;
        double targetTotal = this.gadget_.getN();
        int tgtK = this.gadget_.getK();
        for (int i = 0; i < numSourceSamples; ++i) {
            double rescaled_one = targetTotal += sourceItemWeight;
            assert (rescaled_prob < rescaled_one);
            double rescaled_flip = rescaled_one * SamplingUtil.rand.nextDouble();
            if (!(rescaled_flip < rescaled_prob)) continue;
            int slotNo = SamplingUtil.rand.nextInt(tgtK);
            this.gadget_.insertValueAtPosition(source.getValueAtPosition(i), slotNo);
        }
        long checkN = (long)Math.floor(0.5 + targetTotal);
        this.gadget_.forceIncrementItemsSeen(source.getN());
        assert (checkN == this.gadget_.getN());
    }
}

