/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.json;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oadd.org.json.JSONArray;
import oadd.org.json.JSONException;
import oadd.org.json.JSONObject;
import oadd.org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonOrgJsonProvider
extends AbstractJsonProvider {
    private static final Logger logger = LoggerFactory.getLogger(GsonJsonProvider.class);

    @Override
    public Object parse(String json) throws InvalidJsonException {
        try {
            return new JSONTokener(json).nextValue();
        }
        catch (JSONException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return new JSONTokener(new InputStreamReader(jsonStream, charset)).nextValue();
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonPathException(e);
        }
        catch (JSONException e) {
            throw new InvalidJsonException(e);
        }
    }

    @Override
    public Object unwrap(Object obj) {
        if (obj == JSONObject.NULL) {
            return null;
        }
        return obj;
    }

    @Override
    public String toJson(Object obj) {
        return obj.toString();
    }

    @Override
    public Object createArray() {
        return new JSONArray();
    }

    @Override
    public Object createMap() {
        return new JSONObject();
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof JSONArray || obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        try {
            return this.toJsonArray(obj).get(idx);
        }
        catch (JSONException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        try {
            if (!this.isArray(array)) {
                throw new UnsupportedOperationException();
            }
            this.toJsonArray(array).put(index, this.createJsonElement(newValue));
        }
        catch (JSONException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        try {
            JSONObject jsonObject = this.toJsonObject(obj);
            Object o = jsonObject.opt(key);
            if (o == null) {
                return UNDEFINED;
            }
            return this.unwrap(o);
        }
        catch (JSONException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        try {
            if (this.isMap(obj)) {
                this.toJsonObject(obj).put(key.toString(), this.createJsonElement(value));
            } else {
                JSONArray array;
                int index = key != null ? (key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString())) : array.length();
                if (index == (array = this.toJsonArray(obj)).length()) {
                    array.put(this.createJsonElement(value));
                } else {
                    array.put(index, this.createJsonElement(value));
                }
            }
        }
        catch (JSONException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public void removeProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            this.toJsonObject(obj).remove(key.toString());
        } else {
            JSONArray array = this.toJsonArray(obj);
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            array.remove(index);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof JSONObject;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        JSONObject jsonObject = this.toJsonObject(obj);
        ArrayList<String> keys = new ArrayList<String>();
        try {
            for (int i = 0; i < jsonObject.names().length(); ++i) {
                String key = (String)jsonObject.names().get(i);
                keys.add(key);
            }
            return keys;
        }
        catch (JSONException e) {
            throw new JsonPathException(e);
        }
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            return this.toJsonArray(obj).length();
        }
        if (this.isMap(obj)) {
            return this.toJsonObject(obj).length();
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        throw new JsonPathException("length operation can not applied to " + obj != null ? obj.getClass().getName() : "null");
    }

    @Override
    public Iterable<?> toIterable(Object obj) {
        try {
            if (this.isArray(obj)) {
                JSONArray arr = this.toJsonArray(obj);
                ArrayList<Object> values = new ArrayList<Object>(arr.length());
                for (int i = 0; i < arr.length(); ++i) {
                    values.add(this.unwrap(arr.get(i)));
                }
                return values;
            }
            JSONObject jsonObject = this.toJsonObject(obj);
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < jsonObject.names().length(); ++i) {
                String key = (String)jsonObject.names().get(i);
                Object val = jsonObject.get(key);
                values.add(this.unwrap(val));
            }
            return values;
        }
        catch (JSONException e) {
            throw new JsonPathException(e);
        }
    }

    private Object createJsonElement(Object o) {
        return o;
    }

    private JSONArray toJsonArray(Object o) {
        return (JSONArray)o;
    }

    private JSONObject toJsonObject(Object o) {
        return (JSONObject)o;
    }
}

