/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.server.authorization.HttpStatusServerAccessDeniedHandler;
import org.springframework.security.web.server.authorization.ServerAccessDeniedHandler;
import org.springframework.security.web.server.csrf.CsrfException;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.WebSessionServerCsrfTokenRepository;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CsrfWebFilter
implements WebFilter {
    private ServerWebExchangeMatcher requireCsrfProtectionMatcher = new DefaultRequireCsrfProtectionMatcher();
    private ServerCsrfTokenRepository csrfTokenRepository = new WebSessionServerCsrfTokenRepository();
    private ServerAccessDeniedHandler accessDeniedHandler = new HttpStatusServerAccessDeniedHandler(HttpStatus.FORBIDDEN);

    public void setAccessDeniedHandler(ServerAccessDeniedHandler accessDeniedHandler) {
        Assert.notNull((Object)accessDeniedHandler, "accessDeniedHandler");
        this.accessDeniedHandler = accessDeniedHandler;
    }

    public void setCsrfTokenRepository(ServerCsrfTokenRepository csrfTokenRepository) {
        Assert.notNull((Object)csrfTokenRepository, "csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
    }

    public void setRequireCsrfProtectionMatcher(ServerWebExchangeMatcher requireCsrfProtectionMatcher) {
        Assert.notNull((Object)requireCsrfProtectionMatcher, "requireCsrfProtectionMatcher cannot be null");
        this.requireCsrfProtectionMatcher = requireCsrfProtectionMatcher;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return this.requireCsrfProtectionMatcher.matches(exchange2).filter(matchResult -> matchResult.isMatch()).filter(matchResult -> !exchange2.getAttributes().containsKey(CsrfToken.class.getName())).flatMap(m -> this.validateToken(exchange2)).flatMap(m -> this.continueFilterChain(exchange2, chain)).switchIfEmpty(this.continueFilterChain(exchange2, chain).then(Mono.empty())).onErrorResume(CsrfException.class, e -> this.accessDeniedHandler.handle(exchange2, (AccessDeniedException)e));
    }

    private Mono<Void> validateToken(ServerWebExchange exchange2) {
        return this.csrfTokenRepository.loadToken(exchange2).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new CsrfException("CSRF Token has been associated to this client")))).filterWhen(expected -> this.containsValidCsrfToken(exchange2, (CsrfToken)expected)).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new CsrfException("Invalid CSRF Token")))).then();
    }

    private Mono<Boolean> containsValidCsrfToken(ServerWebExchange exchange2, CsrfToken expected) {
        return exchange2.getFormData().flatMap(data -> Mono.justOrEmpty(data.getFirst(expected.getParameterName()))).switchIfEmpty(Mono.justOrEmpty((Object)exchange2.getRequest().getHeaders().getFirst(expected.getHeaderName()))).map(actual -> actual.equals(expected.getToken()));
    }

    private Mono<Void> continueFilterChain(ServerWebExchange exchange2, WebFilterChain chain) {
        return Mono.defer(() -> {
            Mono<CsrfToken> csrfToken = this.csrfToken(exchange2);
            exchange2.getAttributes().put(CsrfToken.class.getName(), csrfToken);
            return chain.filter(exchange2);
        });
    }

    private Mono<CsrfToken> csrfToken(ServerWebExchange exchange2) {
        return this.csrfTokenRepository.loadToken(exchange2).switchIfEmpty(this.generateToken(exchange2));
    }

    private Mono<CsrfToken> generateToken(ServerWebExchange exchange2) {
        return this.csrfTokenRepository.generateToken(exchange2).delayUntil(token -> this.csrfTokenRepository.saveToken(exchange2, (CsrfToken)token));
    }

    private static class DefaultRequireCsrfProtectionMatcher
    implements ServerWebExchangeMatcher {
        private static final Set<HttpMethod> ALLOWED_METHODS = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.TRACE, HttpMethod.OPTIONS));

        private DefaultRequireCsrfProtectionMatcher() {
        }

        @Override
        public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange2) {
            return Mono.just((Object)exchange2.getRequest()).flatMap(r -> Mono.justOrEmpty((Object)((Object)r.getMethod()))).filter(m -> ALLOWED_METHODS.contains(m)).flatMap(m -> ServerWebExchangeMatcher.MatchResult.notMatch()).switchIfEmpty(ServerWebExchangeMatcher.MatchResult.match());
        }
    }
}

