/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication.logout;

import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.RedirectServerLogoutSuccessHandler;
import org.springframework.security.web.server.authentication.logout.SecurityContextServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LogoutWebFilter
implements WebFilter {
    private AnonymousAuthenticationToken anonymousAuthenticationToken = new AnonymousAuthenticationToken("key", (Object)"anonymous", AuthorityUtils.createAuthorityList("ROLE_ANONYMOUS"));
    private ServerLogoutHandler logoutHandler = new SecurityContextServerLogoutHandler();
    private ServerLogoutSuccessHandler logoutSuccessHandler = new RedirectServerLogoutSuccessHandler();
    private ServerWebExchangeMatcher requiresLogout = ServerWebExchangeMatchers.pathMatchers(HttpMethod.POST, "/logout");

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return this.requiresLogout.matches(exchange2).filter(result -> result.isMatch()).switchIfEmpty(chain.filter(exchange2).then(Mono.empty())).map(result -> exchange2).flatMap(this::flatMapAuthentication).flatMap(authentication -> {
            WebFilterExchange webFilterExchange = new WebFilterExchange(exchange2, chain);
            return this.logout(webFilterExchange, (Authentication)authentication);
        });
    }

    private Mono<Authentication> flatMapAuthentication(ServerWebExchange exchange2) {
        return exchange2.getPrincipal().cast(Authentication.class).defaultIfEmpty((Object)this.anonymousAuthenticationToken);
    }

    private Mono<Void> logout(WebFilterExchange webFilterExchange, Authentication authentication) {
        return this.logoutHandler.logout(webFilterExchange, authentication).then(this.logoutSuccessHandler.onLogoutSuccess(webFilterExchange, authentication)).subscriberContext(ReactiveSecurityContextHolder.clearContext());
    }

    public void setLogoutSuccessHandler(ServerLogoutSuccessHandler logoutSuccessHandler) {
        Assert.notNull((Object)logoutSuccessHandler, "logoutSuccessHandler cannot be null");
        this.logoutSuccessHandler = logoutSuccessHandler;
    }

    public void setLogoutHandler(ServerLogoutHandler logoutHandler) {
        Assert.notNull((Object)logoutHandler, "logoutHandler must not be null");
        this.logoutHandler = logoutHandler;
    }

    public void setRequiresLogoutMatcher(ServerWebExchangeMatcher requiresLogoutMatcher) {
        Assert.notNull((Object)requiresLogoutMatcher, "requiresLogoutMatcher must not be null");
        this.requiresLogout = requiresLogoutMatcher;
    }
}

