/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.List;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MatcherSecurityWebFilterChain
implements SecurityWebFilterChain {
    private final ServerWebExchangeMatcher matcher;
    private final List<WebFilter> filters;

    public MatcherSecurityWebFilterChain(ServerWebExchangeMatcher matcher, List<WebFilter> filters) {
        Assert.notNull((Object)matcher, "matcher cannot be null");
        Assert.notEmpty(filters, "filters cannot be null or empty. Got " + filters);
        this.matcher = matcher;
        this.filters = filters;
    }

    @Override
    public Mono<Boolean> matches(ServerWebExchange exchange2) {
        return this.matcher.matches(exchange2).map(m -> m.isMatch());
    }

    @Override
    public Flux<WebFilter> getWebFilters() {
        return Flux.fromIterable(this.filters);
    }
}

