/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.jackson2;

import java.io.IOException;
import javax.servlet.http.Cookie;
import oadd.com.fasterxml.jackson.core.JsonParser;
import oadd.com.fasterxml.jackson.core.JsonProcessingException;
import oadd.com.fasterxml.jackson.databind.DeserializationContext;
import oadd.com.fasterxml.jackson.databind.JsonDeserializer;
import oadd.com.fasterxml.jackson.databind.JsonNode;
import oadd.com.fasterxml.jackson.databind.ObjectMapper;
import oadd.com.fasterxml.jackson.databind.node.MissingNode;
import oadd.com.fasterxml.jackson.databind.node.NullNode;

class CookieDeserializer
extends JsonDeserializer<Cookie> {
    CookieDeserializer() {
    }

    @Override
    public Cookie deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(jp);
        Cookie cookie = new Cookie(this.readJsonNode(jsonNode, "name").asText(), this.readJsonNode(jsonNode, "value").asText());
        cookie.setComment(this.readJsonNode(jsonNode, "comment").asText());
        cookie.setDomain(this.readJsonNode(jsonNode, "domain").asText());
        cookie.setMaxAge(this.readJsonNode(jsonNode, "maxAge").asInt(-1));
        cookie.setSecure(this.readJsonNode(jsonNode, "secure").asBoolean());
        cookie.setVersion(this.readJsonNode(jsonNode, "version").asInt());
        cookie.setPath(this.readJsonNode(jsonNode, "path").asText());
        cookie.setHttpOnly(this.readJsonNode(jsonNode, "httpOnly").asBoolean());
        return cookie;
    }

    private JsonNode readJsonNode(JsonNode jsonNode, String field) {
        return jsonNode.has(field) && !(jsonNode.get(field) instanceof NullNode) ? jsonNode.get(field) : MissingNode.getInstance();
    }
}

