/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.session;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oadd.org.apache.commons.logging.Log;
import oadd.org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.Assert;

public class CompositeSessionAuthenticationStrategy
implements SessionAuthenticationStrategy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final List<SessionAuthenticationStrategy> delegateStrategies;

    public CompositeSessionAuthenticationStrategy(List<SessionAuthenticationStrategy> delegateStrategies) {
        Assert.notEmpty(delegateStrategies, "delegateStrategies cannot be null or empty");
        for (SessionAuthenticationStrategy strategy : delegateStrategies) {
            if (strategy != null) continue;
            throw new IllegalArgumentException("delegateStrategies cannot contain null entires. Got " + delegateStrategies);
        }
        this.delegateStrategies = delegateStrategies;
    }

    @Override
    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws SessionAuthenticationException {
        for (SessionAuthenticationStrategy delegate : this.delegateStrategies) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Delegating to " + delegate));
            }
            delegate.onAuthentication(authentication, request, response);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [delegateStrategies = " + this.delegateStrategies + "]";
    }
}

