/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import javax.servlet.ServletRequest;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.PortMapperImpl;
import org.springframework.security.web.PortResolver;
import org.springframework.util.Assert;

public class PortResolverImpl
implements PortResolver {
    private PortMapper portMapper = new PortMapperImpl();

    public PortMapper getPortMapper() {
        return this.portMapper;
    }

    @Override
    public int getServerPort(ServletRequest request) {
        int serverPort = request.getServerPort();
        Integer portLookup = null;
        String scheme = request.getScheme().toLowerCase();
        if ("http".equals(scheme)) {
            portLookup = this.portMapper.lookupHttpPort(serverPort);
        } else if ("https".equals(scheme)) {
            portLookup = this.portMapper.lookupHttpsPort(serverPort);
        }
        if (portLookup != null) {
            serverPort = portLookup;
        }
        return serverPort;
    }

    public void setPortMapper(PortMapper portMapper) {
        Assert.notNull((Object)portMapper, "portMapper cannot be null");
        this.portMapper = portMapper;
    }
}

