/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.prepost;

import java.lang.reflect.Method;
import java.util.Collection;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.reactivestreams.Publisher;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.method.MethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PostInvocationAttribute;
import org.springframework.security.access.prepost.PostInvocationAuthorizationAdvice;
import org.springframework.security.access.prepost.PreInvocationAttribute;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdvice;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.util.Assert;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PrePostAdviceReactiveMethodInterceptor
implements MethodInterceptor {
    private Authentication anonymous = new AnonymousAuthenticationToken("key", (Object)"anonymous", AuthorityUtils.createAuthorityList("ROLE_ANONYMOUS"));
    private final MethodSecurityMetadataSource attributeSource;
    private final PreInvocationAuthorizationAdvice preInvocationAdvice;
    private final PostInvocationAuthorizationAdvice postAdvice;

    public PrePostAdviceReactiveMethodInterceptor(MethodSecurityMetadataSource attributeSource, PreInvocationAuthorizationAdvice preInvocationAdvice, PostInvocationAuthorizationAdvice postInvocationAdvice) {
        Assert.notNull((Object)attributeSource, "attributeSource cannot be null");
        Assert.notNull((Object)preInvocationAdvice, "preInvocationAdvice cannot be null");
        Assert.notNull((Object)postInvocationAdvice, "postInvocationAdvice cannot be null");
        this.attributeSource = attributeSource;
        this.preInvocationAdvice = preInvocationAdvice;
        this.postAdvice = postInvocationAdvice;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Class<?> returnType = method.getReturnType();
        if (!Publisher.class.isAssignableFrom(returnType)) {
            throw new IllegalStateException("The returnType " + returnType + " on " + method + " must return an instance of org.reactivestreams.Publisher (i.e. Mono / Flux) in order to support Reactor Context");
        }
        Class<?> targetClass = invocation.getThis().getClass();
        Collection<ConfigAttribute> attributes = this.attributeSource.getAttributes(method, targetClass);
        PreInvocationAttribute preAttr = PrePostAdviceReactiveMethodInterceptor.findPreInvocationAttribute(attributes);
        Mono toInvoke = ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).defaultIfEmpty((Object)this.anonymous).filter(auth -> this.preInvocationAdvice.before((Authentication)auth, invocation, preAttr)).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)new AccessDeniedException("Denied"))));
        PostInvocationAttribute attr = PrePostAdviceReactiveMethodInterceptor.findPostInvocationAttribute(attributes);
        if (Mono.class.isAssignableFrom(returnType)) {
            return toInvoke.flatMap(auth -> ((Mono)PrePostAdviceReactiveMethodInterceptor.proceed(invocation)).map(r -> attr == null ? r : this.postAdvice.after((Authentication)auth, invocation, attr, r)));
        }
        if (Flux.class.isAssignableFrom(returnType)) {
            return toInvoke.flatMapMany(auth -> ((Flux)PrePostAdviceReactiveMethodInterceptor.proceed(invocation)).map(r -> attr == null ? r : this.postAdvice.after((Authentication)auth, invocation, attr, r)));
        }
        return toInvoke.flatMapMany(auth -> Flux.from(PrePostAdviceReactiveMethodInterceptor.proceed(invocation)).map(r -> attr == null ? r : this.postAdvice.after((Authentication)auth, invocation, attr, r)));
    }

    private static <T extends Publisher<?>> T proceed(MethodInvocation invocation) {
        try {
            return (T)((Publisher)invocation.proceed());
        }
        catch (Throwable throwable) {
            throw Exceptions.propagate((Throwable)throwable);
        }
    }

    private static PostInvocationAttribute findPostInvocationAttribute(Collection<ConfigAttribute> config) {
        for (ConfigAttribute attribute : config) {
            if (!(attribute instanceof PostInvocationAttribute)) continue;
            return (PostInvocationAttribute)attribute;
        }
        return null;
    }

    private static PreInvocationAttribute findPreInvocationAttribute(Collection<ConfigAttribute> config) {
        for (ConfigAttribute attribute : config) {
            if (!(attribute instanceof PreInvocationAttribute)) continue;
            return (PreInvocationAttribute)attribute;
        }
        return null;
    }
}

