/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.zookeeper.jmx;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import oadd.org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanRegistry.class);
    private static volatile MBeanRegistry instance = new MBeanRegistry();
    private Map<ZKMBeanInfo, String> mapBean2Path = new ConcurrentHashMap<ZKMBeanInfo, String>();
    private Map<String, ZKMBeanInfo> mapName2Bean = new ConcurrentHashMap<String, ZKMBeanInfo>();
    private MBeanServer mBeanServer;

    public static void setInstance(MBeanRegistry instance) {
        MBeanRegistry.instance = instance;
    }

    public static MBeanRegistry getInstance() {
        return instance;
    }

    public MBeanRegistry() {
        try {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Error e) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
        }
    }

    public MBeanServer getPlatformMBeanServer() {
        return this.mBeanServer;
    }

    public void register(ZKMBeanInfo bean2, ZKMBeanInfo parent) throws JMException {
        assert (bean2 != null);
        String path = null;
        if (parent != null) {
            path = this.mapBean2Path.get(parent);
            assert (path != null);
        }
        path = this.makeFullPath(path, parent);
        if (bean2.isHidden()) {
            return;
        }
        ObjectName oname = this.makeObjectName(path, bean2);
        try {
            this.mBeanServer.registerMBean(bean2, oname);
            this.mapBean2Path.put(bean2, path);
            this.mapName2Bean.put(bean2.getName(), bean2);
        }
        catch (JMException e) {
            LOG.warn("Failed to register MBean " + bean2.getName());
            throw e;
        }
    }

    private void unregister(String path, ZKMBeanInfo bean2) throws JMException {
        if (path == null) {
            return;
        }
        if (!bean2.isHidden()) {
            try {
                this.mBeanServer.unregisterMBean(this.makeObjectName(path, bean2));
            }
            catch (JMException e) {
                LOG.warn("Failed to unregister MBean " + bean2.getName());
                throw e;
            }
        }
    }

    public void unregister(ZKMBeanInfo bean2) {
        if (bean2 == null) {
            return;
        }
        String path = this.mapBean2Path.get(bean2);
        try {
            this.unregister(path, bean2);
        }
        catch (JMException e) {
            LOG.warn("Error during unregister", e);
        }
        this.mapBean2Path.remove(bean2);
        this.mapName2Bean.remove(bean2.getName());
    }

    public void unregisterAll() {
        for (Map.Entry<ZKMBeanInfo, String> e : this.mapBean2Path.entrySet()) {
            try {
                this.unregister(e.getValue(), e.getKey());
            }
            catch (JMException e1) {
                LOG.warn("Error during unregister", e1);
            }
        }
        this.mapBean2Path.clear();
        this.mapName2Bean.clear();
    }

    public String makeFullPath(String prefix, String ... name) {
        StringBuilder sb = new StringBuilder(prefix == null ? "/" : (prefix.equals("/") ? prefix : prefix + "/"));
        boolean first = true;
        for (String s : name) {
            if (s == null) continue;
            if (!first) {
                sb.append("/");
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    protected String makeFullPath(String prefix, ZKMBeanInfo bean2) {
        return this.makeFullPath(prefix, bean2 == null ? null : bean2.getName());
    }

    private int tokenize(StringBuilder sb, String path, int index) {
        String[] tokens;
        for (String s : tokens = path.split("/")) {
            if (s.length() == 0) continue;
            sb.append("name").append(index++).append("=").append(s).append(",");
        }
        return index;
    }

    protected ObjectName makeObjectName(String path, ZKMBeanInfo bean2) throws MalformedObjectNameException {
        if (path == null) {
            return null;
        }
        StringBuilder beanName = new StringBuilder("org.apache.ZooKeeperService:");
        int counter = 0;
        counter = this.tokenize(beanName, path, counter);
        this.tokenize(beanName, bean2.getName(), counter);
        beanName.deleteCharAt(beanName.length() - 1);
        try {
            return new ObjectName(beanName.toString());
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Invalid name \"" + beanName.toString() + "\" for class " + bean2.getClass().toString());
            throw e;
        }
    }
}

