/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.metastore;

import java.util.HashMap;
import java.util.Map;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.SchemaPathUtils;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.metastore.BaseMetadata;
import oadd.org.apache.drill.metastore.ColumnStatistics;
import oadd.org.apache.drill.metastore.LocationProvider;
import oadd.org.apache.drill.metastore.StatisticsKind;
import org.apache.hadoop.fs.Path;

public class RowGroupMetadata
implements BaseMetadata,
LocationProvider {
    private final TupleMetadata schema;
    private final Map<SchemaPath, ColumnStatistics> columnsStatistics;
    private final Map<String, Object> rowGroupStatistics;
    private final Map<String, StatisticsKind> statisticsKinds;
    private Map<String, Float> hostAffinity;
    private int rowGroupIndex;
    private Path location;

    public RowGroupMetadata(TupleMetadata schema, Map<SchemaPath, ColumnStatistics> columnsStatistics, Map<StatisticsKind, Object> rowGroupStatistics, Map<String, Float> hostAffinity, int rowGroupIndex, Path location) {
        this.schema = schema;
        this.columnsStatistics = columnsStatistics;
        this.rowGroupStatistics = new HashMap<String, Object>();
        this.statisticsKinds = new HashMap<String, StatisticsKind>();
        rowGroupStatistics.forEach((statisticsKind, value) -> {
            this.rowGroupStatistics.put(statisticsKind.getName(), value);
            this.statisticsKinds.put(statisticsKind.getName(), (StatisticsKind)statisticsKind);
        });
        this.hostAffinity = hostAffinity;
        this.rowGroupIndex = rowGroupIndex;
        this.location = location;
    }

    @Override
    public Map<SchemaPath, ColumnStatistics> getColumnsStatistics() {
        return this.columnsStatistics;
    }

    @Override
    public ColumnStatistics getColumnStatistics(SchemaPath columnName) {
        return this.columnsStatistics.get(columnName);
    }

    @Override
    public TupleMetadata getSchema() {
        return this.schema;
    }

    @Override
    public ColumnMetadata getColumn(SchemaPath name) {
        return SchemaPathUtils.getColumnMetadata(name, this.schema);
    }

    @Override
    public Object getStatistic(StatisticsKind statisticsKind) {
        return this.rowGroupStatistics.get(statisticsKind.getName());
    }

    @Override
    public boolean containsExactStatistics(StatisticsKind statisticsKind) {
        return this.statisticsKinds.get(statisticsKind.getName()).isExact();
    }

    @Override
    public Path getLocation() {
        return this.location;
    }

    @Override
    public Object getStatisticsForColumn(SchemaPath columnName, StatisticsKind statisticsKind) {
        return this.columnsStatistics.get(columnName).getStatistic(statisticsKind);
    }

    public int getRowGroupIndex() {
        return this.rowGroupIndex;
    }

    public Map<String, Float> getHostAffinity() {
        return this.hostAffinity;
    }
}

